/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.C2S;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.level.item.SPItems;
import net.zeus.sp.level.item.items.Tablet;
import net.zeus.sp.networking.Packet;
import software.bernie.geckolib.animatable.GeoItem;

public class UpdateCameraPacket
extends Packet {
    private final float yRot;
    private final float xRot;
    private final float zoom;
    private final boolean dismounted;

    public UpdateCameraPacket(float yRot, float xRot, float zoom, boolean dismounted) {
        this.yRot = yRot;
        this.xRot = xRot;
        this.zoom = zoom;
        this.dismounted = dismounted;
    }

    public UpdateCameraPacket(FriendlyByteBuf byteBuf) {
        this.yRot = byteBuf.readFloat();
        this.xRot = byteBuf.readFloat();
        this.zoom = byteBuf.readFloat();
        this.dismounted = byteBuf.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.writeFloat(this.yRot);
        byteBuf.writeFloat(this.xRot);
        byteBuf.writeFloat(this.zoom);
        byteBuf.writeBoolean(this.dismounted);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Tablet.getCurrentCamera((Player)player).ifPresent(camera -> camera.updateCamera(player, this.yRot, this.xRot, this.zoom, this.dismounted));
            ItemStack stack = player.m_21120_(player.m_7655_());
            if (stack.m_150930_((Item)SPItems.TABLET.get())) {
                ((GeoItem)SPItems.TABLET.get()).triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)player.m_284548_()), "controller", "flip_down");
            }
        });
        context.setPacketHandled(true);
    }
}

