/*
 * Decompiled with CFR 0.152.
 */
package net.zeus.sp.networking.S2C;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.zeus.sp.client.ClientData;
import net.zeus.sp.networking.Packet;

public class SetCameraPacket
extends Packet {
    private final int id;
    private final BlockPos pos;
    private final float accumulatedYRot;
    private final float accumulatedXRot;
    private final float yRot;
    private final float xRot;
    private final boolean controller;

    public SetCameraPacket(int id, BlockPos pos, float accumulatedYRot, float accumulatedXRot, float yRot, float xRot, boolean controller) {
        this.id = id;
        this.pos = pos;
        this.accumulatedYRot = accumulatedYRot;
        this.accumulatedXRot = accumulatedXRot;
        this.yRot = yRot;
        this.xRot = xRot;
        this.controller = controller;
    }

    public SetCameraPacket(FriendlyByteBuf byteBuf) {
        this.id = byteBuf.readInt();
        this.pos = byteBuf.m_130135_();
        this.accumulatedYRot = byteBuf.readFloat();
        this.accumulatedXRot = byteBuf.readFloat();
        this.yRot = byteBuf.readFloat();
        this.xRot = byteBuf.readFloat();
        this.controller = byteBuf.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.id);
        byteBuf.m_130064_(this.pos);
        byteBuf.writeFloat(this.accumulatedYRot);
        byteBuf.writeFloat(this.accumulatedXRot);
        byteBuf.writeFloat(this.yRot);
        byteBuf.writeFloat(this.xRot);
        byteBuf.writeBoolean(this.controller);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientData.handleCameraChange(this.id, this.pos, this.accumulatedYRot, this.accumulatedXRot, this.yRot, this.xRot, this.controller));
        context.setPacketHandled(true);
    }
}

