/*
 * Decompiled with CFR 0.152.
 */
package net.cathienova.havenanimalseeds.block.mobseeds;

import net.cathienova.havenanimalseeds.config.HavenConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class MobSeedEntity<T extends Mob>
extends BlockEntity {
    private int spawnTimer;
    private final EntityType<T> entityType;
    private final int maxGrowthTime;

    public MobSeedEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int spawnTimer, EntityType<T> entityType, int maxGrowthTime) {
        super(type, pos, state);
        this.spawnTimer = spawnTimer;
        this.entityType = entityType;
        this.maxGrowthTime = maxGrowthTime;
    }

    public void tick(Level level, BlockPos pos, BlockState state, MobSeedEntity<?> blockEntity) {
        Mob mob;
        boolean playerNearby;
        if (level.f_46443_) {
            return;
        }
        FluidState fluidState = level.m_6425_(pos);
        if (level.m_8055_(pos.m_7495_()).m_60819_().m_76152_() == Fluids.f_76193_) {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60819_().m_76152_() == Fluids.f_76195_) {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50016_)) {
            return;
        }
        int pDist = HavenConfig.playerGrowthDistance;
        boolean bl = playerNearby = !level.m_45976_(Player.class, new AABB(pos.m_7918_(-pDist, -pDist, -pDist), pos.m_7918_(pDist, pDist, pDist))).isEmpty();
        if (!playerNearby) {
            --this.spawnTimer;
            this.m_6596_();
            this.sync();
        }
        if (this.spawnTimer <= 0 && (mob = (Mob)this.entityType.m_20615_(level)) != null) {
            Vec3 spawnPosition = Vec3.m_82539_((Vec3i)pos);
            mob.m_6034_(spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_);
            if (mob instanceof AgeableMob) {
                mob.m_6863_(true);
            }
            level.m_7967_((Entity)mob);
            if (fluidState.m_76152_() == Fluids.f_76193_) {
                level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
            } else if (fluidState.m_76152_() == Fluids.f_76195_) {
                level.m_7731_(pos, Blocks.f_49991_.m_49966_(), 3);
            } else {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
            level.m_5594_(null, pos, SoundType.f_56740_.m_56777_(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public int getAge() {
        return Math.max(0, this.maxGrowthTime - this.spawnTimer);
    }

    public int getRemainingTime() {
        return Math.max(0, this.spawnTimer);
    }

    public float getGrowthScale() {
        float scale = 0.1f + 0.9f * (1.0f - (float)this.spawnTimer / (float)this.maxGrowthTime);
        return scale;
    }

    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("SpawnTimer")) {
            this.spawnTimer = tag.m_128451_("SpawnTimer");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SpawnTimer", this.spawnTimer);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

