/*
 * Decompiled with CFR 0.152.
 */
package net.phremic.cageriumrecaged.entityrenderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.phremic.cageriumrecaged.block.FarmBlock;
import net.phremic.cageriumrecaged.blockentity.FarmBlockEntity;
import org.jetbrains.annotations.NotNull;

public class FarmBlockEntityRenderer
implements BlockEntityRenderer<FarmBlockEntity> {
    private Entity entity;
    private float entity_offset;
    private float entity_scale;
    private float entity_rotation;
    private final BlockEntityRendererProvider.Context context;

    public FarmBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.context = pContext;
    }

    public void render(@NotNull FarmBlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
    }

    public void renderEntity(@NotNull FarmBlockEntity pBlockEntity, float pY, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.m_58904_();
        if (level == null) {
            return;
        }
        ItemStack stack = pBlockEntity.getStack();
        if (stack.m_41619_()) {
            return;
        }
        Entity entity = pBlockEntity.getEntity();
        if (entity != null) {
            this.renderLivingEntity(pBlockEntity, entity, pY, pPoseStack, pBuffer, pPackedLight);
        } else {
            this.renderItemEntity(pBlockEntity, stack, level, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    private void renderLivingEntity(@NotNull FarmBlockEntity pBlockEntity, Entity pEntity, float pY, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        if (!Objects.equals(this.entity, pEntity)) {
            this.updateEntityData(pBlockEntity, pEntity);
        }
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.5f, pY + this.entity_offset, 0.5f);
        pPoseStack.m_85841_(this.entity_scale, this.entity_scale, this.entity_scale);
        pPoseStack.m_252781_(Axis.f_252392_.m_252977_(this.entity_rotation));
        this.context.m_234446_().m_114384_(this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.m_85849_();
    }

    private void renderItemEntity(@NotNull FarmBlockEntity pBlockEntity, ItemStack pStack, Level pLevel, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_85841_(0.4f, 0.4f, 0.4f);
        pPoseStack.m_252781_(Axis.f_252392_.m_252977_(((Direction)pBlockEntity.m_58900_().m_61143_((Property)FarmBlock.f_54117_)).m_122435_()));
        this.context.m_234447_().m_269128_(pStack, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, pLevel, 0);
        pPoseStack.m_85849_();
    }

    private void updateEntityData(FarmBlockEntity pBlockEntity, Entity pEntity) {
        if (pEntity instanceof ZombieVillager) {
            ZombieVillager zombie_villager = (ZombieVillager)pEntity;
            zombie_villager.m_34375_(zombie_villager.m_7141_().m_35565_(VillagerProfession.f_35585_));
        }
        float offset = 0.0f;
        float scale = Math.min(0.85f / (pEntity.m_20205_() + pEntity.m_20206_()), 0.4f);
        float rotation = ((Direction)pBlockEntity.m_58900_().m_61143_((Property)FarmBlock.f_54117_)).m_122435_();
        if (pEntity instanceof EnderDragon) {
            offset = 0.15625f;
        }
        if (pEntity instanceof Ghast) {
            offset = 0.28125f;
        }
        if (pEntity instanceof Squid) {
            offset = 0.34375f;
        }
        if (pEntity instanceof Bat) {
            scale = 0.7f;
        }
        if (pEntity instanceof EnderDragon) {
            scale = 0.07f;
        }
        if (pEntity instanceof HoglinBase) {
            scale = 0.23f;
        }
        if (pEntity instanceof IronGolem) {
            scale = 0.26f;
        }
        if (pEntity instanceof Rabbit) {
            scale = 0.6f;
        }
        if (pEntity instanceof Turtle) {
            scale = 0.3f;
        }
        if (pEntity instanceof EnderDragon) {
            rotation += 180.0f;
        }
        this.entity = pEntity;
        this.entity_offset = offset;
        this.entity_scale = scale;
        this.entity_rotation = rotation;
    }
}

