/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.scrollable_page;

import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class ScrollBarComponent
extends AbstractWidget {
    protected final Dim2i dim;
    private final int frameLength;
    private final int viewPortLength;
    private final int maxScrollBarOffset;
    private final Runnable onSetOffset;
    private int offset = 0;
    private boolean isDragging;
    private Dim2i scrollThumb = null;
    private int scrollThumbClickOffset;
    private Dim2i extendedScrollArea = null;

    public ScrollBarComponent(Dim2i trackArea, int frameLength, int viewPortLength, Runnable onSetOffset) {
        this.dim = trackArea;
        this.frameLength = frameLength;
        this.viewPortLength = viewPortLength;
        this.onSetOffset = onSetOffset;
        this.maxScrollBarOffset = this.frameLength - this.viewPortLength;
    }

    public ScrollBarComponent(Dim2i scrollBarArea, int frameLength, int viewPortLength, Runnable onSetOffset, Dim2i extendedTrackArea) {
        this(scrollBarArea, frameLength, viewPortLength, onSetOffset);
        this.extendedScrollArea = extendedTrackArea;
    }

    public void updateThumbPosition() {
        int scrollThumbLength = this.viewPortLength * this.dim.getHeight() / this.frameLength;
        int maximumScrollThumbOffset = this.viewPortLength - scrollThumbLength;
        int scrollThumbOffset = this.offset * maximumScrollThumbOffset / this.maxScrollBarOffset;
        this.scrollThumb = new Dim2i(this.dim.getOriginX() + 2, this.dim.getOriginY() + 2 + scrollThumbOffset, this.dim.getWidth() - 4, scrollThumbLength - 4);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.drawRectOutline(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        this.drawRect(this.scrollThumb.getOriginX(), this.scrollThumb.getOriginY(), this.scrollThumb.getLimitX(), this.scrollThumb.getLimitY(), -5592406);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY)) {
            if (this.scrollThumb.containsCursor(mouseX, mouseY)) {
                this.scrollThumbClickOffset = (int)(mouseY - (double)(this.scrollThumb.getOriginY() + this.scrollThumb.getHeight() / 2));
                this.isDragging = true;
            } else {
                int value = (int)((mouseY - (double)this.dim.getOriginY() - (double)(this.scrollThumb.getHeight() / 2)) / (double)(this.dim.getHeight() - this.scrollThumb.getHeight()) * (double)this.maxScrollBarOffset);
                this.setOffset(value);
                this.isDragging = false;
            }
            return true;
        }
        this.isDragging = false;
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            int value = (int)((mouseY - (double)this.scrollThumbClickOffset - (double)this.dim.getOriginY() - (double)(this.scrollThumb.getHeight() / 2)) / (double)(this.dim.getHeight() - this.scrollThumb.getHeight()) * (double)this.maxScrollBarOffset);
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if ((this.dim.containsCursor(mouseX, mouseY) || this.extendedScrollArea != null && this.extendedScrollArea.containsCursor(mouseX, mouseY)) && this.offset <= this.maxScrollBarOffset && this.offset >= 0) {
            int value = (int)((double)this.offset - amount * 6.0);
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public int getOffset() {
        return this.offset;
    }

    private void setOffset(int value) {
        this.offset = class_3532.method_15340((int)value, (int)0, (int)this.maxScrollBarOffset);
        this.updateThumbPosition();
        this.onSetOffset.run();
    }

    protected void drawRectOutline(double x, double y, double w, double h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> {
            ScrollBarComponent.addQuad((class_4588)vertices, (double)x, (double)y, (double)w, (double)(y + 1.0), (float)a, (float)r, (float)g, (float)b);
            ScrollBarComponent.addQuad((class_4588)vertices, (double)x, (double)(h - 1.0), (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
            ScrollBarComponent.addQuad((class_4588)vertices, (double)x, (double)y, (double)(x + 1.0), (double)h, (float)a, (float)r, (float)g, (float)b);
            ScrollBarComponent.addQuad((class_4588)vertices, (double)(w - 1.0), (double)y, (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
        });
    }
}

