/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse;

import com.mojang.logging.LogUtils;
import com.olivadevelop.buildhouse.block.ModBlocks;
import com.olivadevelop.buildhouse.entity.ModEntities;
import com.olivadevelop.buildhouse.item.ModItems;
import com.olivadevelop.buildhouse.loot.ModLootModifiers;
import com.olivadevelop.buildhouse.menu.ModConfiguration;
import com.olivadevelop.buildhouse.menu.ModOptionsScreen;
import com.olivadevelop.buildhouse.sound.ModSounds;
import com.olivadevelop.buildhouse.structure.Structures;
import com.olivadevelop.buildhouse.thirdparty.buildadmintools.BuildAdminToolsModCompatPlugin;
import com.olivadevelop.buildhouse.thirdparty.buildadmintools.ModItemsAdminTools;
import com.olivadevelop.buildhouse.util.ModCreativeTabs;
import com.olivadevelop.buildhouse.villager.ModVillagers;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="buildhouse")
public class BuildHouse {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String ERROR_LOADING_STRUCTURES = "//////////////////////////////////////////////////////// Error loading structures. If the error persists, disable this mod and contact the developer, sorry for the inconvenience.";

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    public BuildHouse() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCreativeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        ModSounds.register(modEventBus);
        ModVillagers.register(modEventBus);
        ModEntities.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfiguration.CLIENT_CONFIG);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        try {
            Structures.loadAllOnServer();
            LOGGER.error("///////////////////////////////// Common structures loaded (" + Structures.getStructures().size() + ").");
        }
        catch (IOException e) {
            throw new RuntimeException(ERROR_LOADING_STRUCTURES);
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BASIC_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.COPPER_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.IRON_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.GOLD_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DIAMOND_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.NETHERITE_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.PLATINUM_CAPSULE_ENTITY.get()), ThrownItemRenderer::new);
        MinecraftForge.EVENT_BUS.addListener(ModEventBusSubscriber::onScreenInit);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (BuildAdminToolsModCompatPlugin.Instance.isServiceActive() && event.getTabKey() == CreativeModeTabs.f_256837_) {
            event.accept(ModItemsAdminTools.CS_LOTTER_BASIC);
            event.accept(ModItemsAdminTools.CD_LOOTER_BASIC);
            event.accept(ModItemsAdminTools.BA_LOOTER_BASIC);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModEventBusSubscriber {
        private static void onScreenInit(ScreenEvent.Init event) {
            Screen screen = event.getScreen();
            if (screen instanceof OptionsScreen) {
                OptionsScreen optScreen = (OptionsScreen)screen;
                int buttonWidth = 150;
                int buttonHeight = 20;
                int posX = (optScreen.f_96543_ - buttonWidth) / 2 - 80;
                int posY = optScreen.f_96544_ / 6 + 24 - 6;
                event.addListener((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"menu.title"), button -> Minecraft.m_91087_().m_91152_((Screen)new ModOptionsScreen((Screen)optScreen))).m_252987_(posX, posY, buttonWidth, buttonHeight).m_253136_());
            }
        }
    }
}

