/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.block;

import com.olivadevelop.buildhouse.block.light.LightBlock;
import com.olivadevelop.buildhouse.block.ores.AntimoniumOreBlock;
import com.olivadevelop.buildhouse.block.ores.PlatinumOreBlock;
import com.olivadevelop.buildhouse.block.tools.SpongeXXLBlock;
import com.olivadevelop.buildhouse.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"buildhouse");
    public static final RegistryObject<Block> PLATINUM_BLOCK = ModBlocks.registerBlock("platinum_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ANTIMONIUM_BLOCK = ModBlocks.registerBlock("antimonium_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50090_).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> ANTIMONIUM_ORE = ModBlocks.registerBlock("antimonium_ore", AntimoniumOreBlock::new);
    public static final RegistryObject<Block> PLATINUM_ORE = ModBlocks.registerBlock("platinum_ore", PlatinumOreBlock::new);
    public static final RegistryObject<Block> WHITE_LIGHT_BLOCK = ModBlocks.registerBlock("white_block", LightBlock::new);
    public static final RegistryObject<Block> WHITE_LIGHT_STAIRS = ModBlocks.registerBlock("white_block_stairs", LightBlock::getStairs);
    public static final RegistryObject<Block> WHITE_LIGHT_SLAB = ModBlocks.registerBlock("white_block_slab", LightBlock::getSlab);
    public static final RegistryObject<Block> WHITE_LIGHT_BUTTON = ModBlocks.registerBlock("white_block_button", LightBlock::getButton);
    public static final RegistryObject<Block> WHITE_LIGHT_PRESSURE_PLATE = ModBlocks.registerBlock("white_block_pressure_plate", LightBlock::getPressurePlate);
    public static final RegistryObject<Block> WHITE_LIGHT_FENCE = ModBlocks.registerBlock("white_block_fence", LightBlock::getFence);
    public static final RegistryObject<Block> WHITE_LIGHT_FENCE_GATE = ModBlocks.registerBlock("white_block_fence_gate", LightBlock::getFenceGate);
    public static final RegistryObject<Block> WHITE_LIGHT_WALL = ModBlocks.registerBlock("white_block_wall", LightBlock::getWall);
    public static final RegistryObject<Block> WHITE_LIGHT_DOOR = ModBlocks.registerBlock("white_block_door", LightBlock::getDoor);
    public static final RegistryObject<Block> WHITE_LIGHT_TRAP_DOOR = ModBlocks.registerBlock("white_block_trapdoor", LightBlock::getTrapDoor);
    public static final RegistryObject<Block> SPONGE_XXL_BLOCK = ModBlocks.registerBlock("sponge_xxl_block", SpongeXXLBlock::new);
    public static final RegistryObject<Block> YELLOW_CONCRETE_STAIRS = ModBlocks.registerBlock("yellow_concrete_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50494_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50494_)));
    public static final RegistryObject<Block> GRAY_CONCRETE_STAIRS = ModBlocks.registerBlock("gray_concrete_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50497_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50497_)));
    public static final RegistryObject<Block> WHITE_CONCRETE_STAIRS = ModBlocks.registerBlock("white_concrete_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50542_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50542_)));
    public static final RegistryObject<Block> ORANGE_CONCRETE_STAIRS = ModBlocks.registerBlock("orange_concrete_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50543_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50543_)));
    public static final RegistryObject<Block> MAGENTA_CONCRETE_STAIRS = ModBlocks.registerBlock("magenta_concrete_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50544_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50544_)));
    public static final RegistryObject<Block> PURPLE_CONCRETE_STAIRS = ModBlocks.registerBlock("purple_concrete_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50500_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50500_)));
    public static final RegistryObject<Block> CRY_OBSIDIAN_STAIRS = ModBlocks.registerBlock("cry_obsidian_stairs", () -> new StairBlock(() -> ((Block)Blocks.f_50723_).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50723_)));
    public static final RegistryObject<Block> CRY_OBSIDIAN_SLAB = ModBlocks.registerBlock("cry_obsidian_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50723_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

