/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.datagen;

import com.olivadevelop.buildhouse.block.ModBlocks;
import com.olivadevelop.buildhouse.block.crop.CustomCropBlock;
import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public static final String BLOCK_PREFIX = "block/";

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "buildhouse", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.WHITE_LIGHT_BLOCK);
        this.blockWithItem(ModBlocks.SPONGE_XXL_BLOCK);
        this.blockWithItem(ModBlocks.PLATINUM_ORE);
        this.blockWithItem(ModBlocks.ANTIMONIUM_ORE);
        this.blockWithItem(ModBlocks.PLATINUM_BLOCK);
        this.blockWithItem(ModBlocks.ANTIMONIUM_BLOCK);
        this.stairsBlock((StairBlock)ModBlocks.WHITE_LIGHT_STAIRS.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.slabBlock((SlabBlock)ModBlocks.WHITE_LIGHT_SLAB.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.WHITE_LIGHT_BUTTON.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.WHITE_LIGHT_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.fenceBlock((FenceBlock)ModBlocks.WHITE_LIGHT_FENCE.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.WHITE_LIGHT_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.wallBlock((WallBlock)ModBlocks.WHITE_LIGHT_WALL.get(), this.blockTexture((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()));
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.WHITE_LIGHT_DOOR.get(), this.modLoc("block/white_block_door_bottom"), this.modLoc("block/white_block_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.WHITE_LIGHT_TRAP_DOOR.get(), this.modLoc("block/white_block_trapdoor"), true, "cutout");
        this.stairsBlock((StairBlock)ModBlocks.YELLOW_CONCRETE_STAIRS.get(), this.blockTexture(Blocks.f_50494_));
        this.stairsBlock((StairBlock)ModBlocks.GRAY_CONCRETE_STAIRS.get(), this.blockTexture(Blocks.f_50497_));
        this.stairsBlock((StairBlock)ModBlocks.WHITE_CONCRETE_STAIRS.get(), this.blockTexture(Blocks.f_50542_));
        this.stairsBlock((StairBlock)ModBlocks.ORANGE_CONCRETE_STAIRS.get(), this.blockTexture(Blocks.f_50543_));
        this.stairsBlock((StairBlock)ModBlocks.MAGENTA_CONCRETE_STAIRS.get(), this.blockTexture(Blocks.f_50544_));
        this.stairsBlock((StairBlock)ModBlocks.PURPLE_CONCRETE_STAIRS.get(), this.blockTexture(Blocks.f_50500_));
        this.stairsBlock((StairBlock)ModBlocks.CRY_OBSIDIAN_STAIRS.get(), this.blockTexture(Blocks.f_50723_));
        this.slabBlock((SlabBlock)ModBlocks.CRY_OBSIDIAN_SLAB.get(), this.blockTexture(Blocks.f_50723_), this.blockTexture(Blocks.f_50723_));
    }

    public <T extends CustomCropBlock> void makeCrop(T block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.cropStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private <T extends CustomCropBlock> ConfiguredModel[] cropStates(BlockState state, T block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + state.m_61143_((Property)block.m_7959_()), new ResourceLocation("buildhouse", BLOCK_PREFIX + textureName + state.m_61143_((Property)block.m_7959_())))).renderType("cutout"))};
        return models;
    }

    public void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        super.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }
}

