/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.datagen;

import com.olivadevelop.buildhouse.block.ModBlocks;
import com.olivadevelop.buildhouse.item.ModItems;
import com.olivadevelop.buildhouse.thirdparty.buildadmintools.BuildAdminToolsModCompatPlugin;
import com.olivadevelop.buildhouse.thirdparty.buildadmintools.ModItemsAdminTools;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();
    public static final String ITEM_GENERATED = "item/generated";
    public static final String ITEM_HANDHELD = "item/handheld";
    public static final String LAYER_0 = "layer0";
    public static final String LAYER_1 = "layer1";
    public static final String ITEM_SUFFIX = "item/";
    public static final String BLOCK_SUFFIX = "block/";
    public static final String TEXTURE_SUFFIX = "texture";
    public static final String WALL_SUFFIX = "wall";
    public static final String BLOCK_FENCE_INVENTORY = "block/fence_inventory";
    public static final String BLOCK_BUTTON_INVENTORY = "block/button_inventory";
    public static final String BLOCK_WALL_INVENTORY = "block/wall_inventory";
    public static final String BOTTOM = "_bottom";

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "buildhouse", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.BASIC_CAPSULE);
        this.simpleItem(ModItems.IRON_CAPSULE);
        this.simpleItem(ModItems.COPPER_CAPSULE);
        this.simpleItem(ModItems.GOLD_CAPSULE);
        this.simpleItem(ModItems.DIAMOND_CAPSULE);
        this.simpleItem(ModItems.NETHERITE_CAPSULE);
        this.simpleItem(ModItems.PLATINUM_CAPSULE);
        this.simpleItem(ModItems.PLATINUM_RAW);
        this.simpleItem(ModItems.PLATINUM_INGOT);
        this.simpleItem(ModItems.ANTIMONIUM_RAW);
        this.simpleItem(ModItems.ANTIMONIUM_INGOT);
        this.simpleItem(ModItems.METAL_DETECTOR);
        this.handheldItem(ModItems.PLATINUM_SWORD);
        this.handheldItem(ModItems.PLATINUM_AXE);
        this.handheldItem(ModItems.PLATINUM_PICKAXE);
        this.handheldItem(ModItems.PLATINUM_HOE);
        this.handheldItem(ModItems.PLATINUM_SHOVEL);
        this.handheldItem(ModItems.PLATINUM_SHEARS);
        this.trimmedArmorItem(ModItems.PLATINUM_ARMOR_HELMET);
        this.trimmedArmorItem(ModItems.PLATINUM_ARMOR_CHEST);
        this.trimmedArmorItem(ModItems.PLATINUM_ARMOR_LEGS);
        this.trimmedArmorItem(ModItems.PLATINUM_ARMOR_BOOTS);
        this.simpleBlockItem(ModBlocks.WHITE_LIGHT_DOOR);
        this.fenceItem(ModBlocks.WHITE_LIGHT_FENCE, ModBlocks.WHITE_LIGHT_BLOCK);
        this.buttonItem(ModBlocks.WHITE_LIGHT_BUTTON, ModBlocks.WHITE_LIGHT_BLOCK);
        this.wallItem(ModBlocks.WHITE_LIGHT_WALL, ModBlocks.WHITE_LIGHT_BLOCK);
        this.evenSimplerBlockItem(ModBlocks.WHITE_LIGHT_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.WHITE_LIGHT_SLAB);
        this.evenSimplerBlockItem(ModBlocks.WHITE_LIGHT_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.WHITE_LIGHT_FENCE_GATE);
        this.trapdoorItem(ModBlocks.WHITE_LIGHT_TRAP_DOOR);
        if (BuildAdminToolsModCompatPlugin.Instance.isServiceActive()) {
            this.simpleItem(ModItemsAdminTools.CS_LOTTER_BASIC);
            this.simpleItem(ModItemsAdminTools.CD_LOOTER_BASIC);
            this.simpleItem(ModItemsAdminTools.BA_LOOTER_BASIC);
        }
        this.evenSimplerBlockItem(ModBlocks.YELLOW_CONCRETE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.GRAY_CONCRETE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.WHITE_CONCRETE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.ORANGE_CONCRETE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.MAGENTA_CONCRETE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.PURPLE_CONCRETE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CRY_OBSIDIAN_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CRY_OBSIDIAN_SLAB);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation(ITEM_GENERATED))).texture(LAYER_0, new ResourceLocation("buildhouse", ITEM_SUFFIX + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("buildhouse:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc(BLOCK_SUFFIX + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc(BLOCK_SUFFIX + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + BOTTOM));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc(BLOCK_FENCE_INVENTORY))).texture(TEXTURE_SUFFIX, new ResourceLocation("buildhouse", BLOCK_SUFFIX + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc(BLOCK_BUTTON_INVENTORY))).texture(TEXTURE_SUFFIX, new ResourceLocation("buildhouse", BLOCK_SUFFIX + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc(BLOCK_WALL_INVENTORY))).texture(WALL_SUFFIX, new ResourceLocation("buildhouse", BLOCK_SUFFIX + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation(ITEM_HANDHELD))).texture(LAYER_0, new ResourceLocation("buildhouse", ITEM_SUFFIX + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation(ITEM_GENERATED))).texture(LAYER_0, new ResourceLocation("buildhouse", ITEM_SUFFIX + item.getId().m_135815_()));
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "buildhouse";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = ITEM_SUFFIX + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("buildhouse", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("buildhouse", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile(ITEM_GENERATED))).texture(LAYER_0, armorItemResLoc)).texture(LAYER_1, trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc(ITEM_GENERATED))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture(LAYER_0, new ResourceLocation("buildhouse", ITEM_SUFFIX + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

