/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.entity.capsule;

import com.olivadevelop.buildhouse.entity.CapsuleType;
import com.olivadevelop.buildhouse.sound.ModSounds;
import com.olivadevelop.buildhouse.structure.Structures;
import com.olivadevelop.buildhouse.util.ModUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCapsuleProjectileEntity
extends ThrowableItemProjectile {
    private static final int MAX_INTENTS = 10;
    private static final double BOUNCE_FACTOR = 0.5;
    private int intents;
    protected final CapsuleType capsuleType;

    public AbstractCapsuleProjectileEntity(CapsuleType capsuleType, EntityType<? extends AbstractCapsuleProjectileEntity> type, Level pLevel, LivingEntity livingEntity) {
        super(type, livingEntity, pLevel);
        this.capsuleType = capsuleType;
        this.intents = 0;
    }

    public AbstractCapsuleProjectileEntity(CapsuleType capsuleType, EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.capsuleType = capsuleType;
        this.intents = 0;
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        if (!this.m_9236_().m_5776_() && this.m_19749_() != null) {
            BlockPos centerPivot = pResult.m_82425_();
            if (this.m_9236_().m_8055_(centerPivot).m_60795_()) {
                return;
            }
            if (this.m_9236_().m_6857_().m_61937_(centerPivot)) {
                if (ModUtils.isBlockFloor(this.m_9236_().m_8055_(centerPivot).m_60734_()) && Direction.UP.equals((Object)pResult.m_82434_())) {
                    this.m_9236_().m_7605_((Entity)this, (byte)3);
                    this.generateBlocksAndEntitiesToWorld((ServerLevel)this.m_9236_(), centerPivot, this.m_19749_());
                    this.m_146870_();
                } else if (this.intents >= 10) {
                    this.discardEffect(centerPivot);
                } else {
                    ++this.intents;
                    Vec3 motion = this.m_20184_();
                    Vec3i vnormal = pResult.m_82434_().m_122424_().m_122436_();
                    Vec3 normal = new Vec3((double)vnormal.m_123341_(), (double)vnormal.m_123342_(), (double)vnormal.m_123343_());
                    Vec3 newMotion = motion.m_82546_(normal.m_82490_(2.0 * motion.m_82526_(normal))).m_82542_(0.5, 0.5, 0.5);
                    this.m_20256_(newMotion);
                }
            } else {
                this.discardEffect(centerPivot);
            }
        }
        super.m_8060_(pResult);
    }

    private void discardEffect(BlockPos centerPivot) {
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        BlockPos pos = centerPivot.m_7494_();
        Particle p = particleEngine.m_107370_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.1, 0.1, 0.1);
        if (p != null) {
            p.m_6569_(4.0f);
        }
        ModSounds.playSound(this.m_9236_(), centerPivot, SoundEvents.f_12031_);
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Class<?> clazz = pResult.m_82443_().getClass();
        if (this.capsuleType.getMonsterKillOnConstruct().contains(clazz)) {
            pResult.m_82443_().m_6074_();
        } else {
            for (Class<? extends Mob> mob : this.capsuleType.getMonsterKillOnConstruct()) {
                if (!mob.isAssignableFrom(clazz)) continue;
                pResult.m_82443_().m_6074_();
            }
        }
        super.m_5790_(pResult);
    }

    protected void generateBlocksAndEntitiesToWorld(ServerLevel level, BlockPos centerPos, Entity owner) {
        Structures.startPlace(level, owner, centerPos.m_7494_(), this.capsuleType);
    }
}

