/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.item.armor;

import com.google.common.collect.ImmutableMap;
import com.olivadevelop.buildhouse.interfaces.IRecipeBuilder;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomArmorItem
extends ArmorItem
implements IRecipeBuilder {
    protected static final Item.Properties properties = new Item.Properties().m_41486_().m_41497_(Rarity.EPIC);
    private Map<ArmorMaterial, List<MobEffectInstance>> effectsFromMaterial;
    private final List<Enchantment> enchantmentsFilter = new ArrayList<Enchantment>();
    private final String description;
    private final String descriptionShift;

    protected void fillFilter() {
    }

    public CustomArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties, String description, String descriptionShift, List<MobEffectInstance> effectsFullArmorOn) {
        super(pMaterial, pType, pProperties);
        this.description = description;
        this.descriptionShift = descriptionShift;
        if (effectsFullArmorOn != null && !effectsFullArmorOn.isEmpty()) {
            this.effectsFromMaterial = new ImmutableMap.Builder().put((Object)pMaterial, effectsFullArmorOn).build();
        }
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        if (!level.m_5776_() && this.effectsFromMaterial != null && this.hasFullSuitOfArmorOn(player)) {
            this.evaluateArmorEffects(player);
        }
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        this.fillFilter();
        components.add((Component)Component.m_237115_((String)this.description).m_130940_(ChatFormatting.BLUE));
        if (Screen.m_96638_() && !this.enchantmentsFilter.isEmpty()) {
            components.add((Component)Component.m_237113_((String)""));
            if (this.descriptionShift != null) {
                components.add((Component)Component.m_237115_((String)this.descriptionShift).m_130940_(ChatFormatting.AQUA));
            }
            for (Enchantment enchantment : this.enchantmentsFilter) {
                components.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)enchantment.m_44704_()).m_130940_(ChatFormatting.AQUA)));
            }
        }
        super.m_7373_(itemStack, level, components, flag);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (this.enchantmentsFilter.isEmpty()) {
            this.fillFilter();
            return super.isBookEnchantable(stack, book);
        }
        return ModUtils.validateEnchantments(book, super.isBookEnchantable(stack, book), this.enchantmentsFilter);
    }

    protected void addEnchantmentsFilter(Enchantment enchantment) {
        if (this.enchantmentsFilter.contains(enchantment)) {
            return;
        }
        this.enchantmentsFilter.add(enchantment);
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !leggings.m_41619_() && !chestplate.m_41619_() && !boots.m_41619_();
    }

    private void evaluateArmorEffects(Player player) {
        if (this.effectsFromMaterial == null) {
            return;
        }
        for (Map.Entry<ArmorMaterial, List<MobEffectInstance>> entry : this.effectsFromMaterial.entrySet()) {
            ArmorMaterial am = entry.getKey();
            List<MobEffectInstance> mei = entry.getValue();
            if (!this.hasCorrectArmorOn(am, player)) continue;
            this.addStatusEffectForMaterial(player, am, mei);
        }
    }

    private boolean hasCorrectArmorOn(ArmorMaterial am, Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            if (armorStack.m_41720_() instanceof ArmorItem) continue;
            return false;
        }
        ArmorItem boots = (ArmorItem)player.m_150109_().m_36052_(0).m_41720_();
        ArmorItem leggings = (ArmorItem)player.m_150109_().m_36052_(1).m_41720_();
        ArmorItem chestplate = (ArmorItem)player.m_150109_().m_36052_(2).m_41720_();
        ArmorItem helmet = (ArmorItem)player.m_150109_().m_36052_(3).m_41720_();
        return boots.m_40401_() == am && leggings.m_40401_() == am && chestplate.m_40401_() == am && helmet.m_40401_() == am;
    }

    private void addStatusEffectForMaterial(Player player, ArmorMaterial am, List<MobEffectInstance> mei) {
        for (MobEffectInstance m : mei) {
            boolean hasPlayerEffect = player.m_21023_(m.m_19544_());
            if (!this.hasCorrectArmorOn(am, player) || hasPlayerEffect) continue;
            player.m_7292_(new MobEffectInstance(m));
        }
    }
}

