/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.item.capsule;

import com.olivadevelop.buildhouse.entity.capsule.AbstractCapsuleProjectileEntity;
import com.olivadevelop.buildhouse.interfaces.ICreativeTabOrder;
import com.olivadevelop.buildhouse.item.capsule.CapsuleItemProperty;
import com.olivadevelop.buildhouse.item.capsule.CapsuleItemPropertyType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCapsuleItem<T extends AbstractCapsuleProjectileEntity>
extends Item
implements ICreativeTabOrder {
    public static final Item.Properties properties = new Item.Properties().m_41497_(Rarity.COMMON).m_41487_(64).m_41486_();
    private final CapsuleItemProperty capsuleProperties;

    public AbstractCapsuleItem(@NotNull CapsuleItemProperty capsuleProperties) {
        super((Item.Properties)capsuleProperties.getTypeProperty(CapsuleItemPropertyType.ITEM_PROPERTIES));
        this.capsuleProperties = capsuleProperties;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        String text = "item.buildhouse.generic_capsule_descript";
        String descriptionShift = null;
        if (this.capsuleProperties.hasProperty(CapsuleItemPropertyType.LABEL)) {
            text = this.capsuleProperties.getStringProperty(CapsuleItemPropertyType.LABEL);
        }
        if (this.capsuleProperties.hasProperty(CapsuleItemPropertyType.DESCRIPTION)) {
            descriptionShift = this.capsuleProperties.getStringProperty(CapsuleItemPropertyType.DESCRIPTION);
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)text).m_130940_(ChatFormatting.WHITE));
        if (Screen.m_96638_() && descriptionShift != null) {
            pTooltipComponents.add((Component)Component.m_237115_((String)text).m_130940_(ChatFormatting.AQUA));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public abstract T buildProjectileInstance(Level var1, Player var2);

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            if (pPlayer.m_36335_().m_41519_(itemstack.m_41720_())) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
            }
            T capsuleProjectile = this.buildProjectileInstance(pLevel, pPlayer);
            capsuleProjectile.m_37446_(itemstack);
            capsuleProjectile.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 1.5f, 1.0f);
            pLevel.m_7967_(capsuleProjectile);
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12437_, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.m_213780_().m_188501_() * 0.4f + 0.8f));
            if (this.capsuleProperties.hasProperty(CapsuleItemPropertyType.COOLDOWN)) {
                Integer cooldownDuration = this.capsuleProperties.getIntProperty(CapsuleItemPropertyType.COOLDOWN);
                pPlayer.m_36335_().m_41524_(itemstack.m_41720_(), TimeUtil.m_145020_((int)cooldownDuration, (int)cooldownDuration).m_142739_());
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }
}

