/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.item.metaldetector;

import com.olivadevelop.buildhouse.sound.ModSounds;
import com.olivadevelop.buildhouse.tag.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MetalDetectorItem
extends Item {
    private static final int COOLDOWN_DURATION = 1;
    private final int maxDeepth;
    private final SoundEvent soundEvent;

    public MetalDetectorItem(Item.Properties pProperties, SoundEvent sound, int maxDeepth) {
        super(pProperties);
        this.maxDeepth = maxDeepth;
        this.soundEvent = sound;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        boolean foundBlock = false;
        BlockPos below = BlockPos.f_121853_;
        Block block = Blocks.f_50016_;
        Player player = pContext.m_43723_();
        BlockPos posClicked = pContext.m_8083_();
        if (player != null && !pContext.m_43725_().m_5776_()) {
            ItemStack itemstack = pContext.m_43722_();
            if (player.m_36335_().m_41519_(itemstack.m_41720_())) {
                return InteractionResult.FAIL;
            }
            for (int y = 0; y <= posClicked.m_123342_() + this.maxDeepth; ++y) {
                BlockPos posBelow = posClicked.m_6625_(y);
                BlockState state = pContext.m_43725_().m_8055_(posBelow);
                if (!this.isValuableBlock(state)) continue;
                below = posBelow;
                block = state.m_60734_();
                foundBlock = true;
                break;
            }
            player.m_36335_().m_41524_(itemstack.m_41720_(), TimeUtil.m_145020_((int)1, (int)1).m_142739_());
            itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            if (foundBlock) {
                this.detectedObject(pContext, posClicked, below, player, block);
            } else {
                this.undetectedObject(pContext, player, posClicked);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void undetectedObject(UseOnContext pContext, Player player, BlockPos posClicked) {
        player.m_213846_((Component)Component.m_237115_((String)"item.buildhouse.metal_detector.message_ore_not_found"));
        ModSounds.playSound(pContext.m_43725_(), posClicked, (SoundEvent)ModSounds.METAL_DETECTO_NOT_FOUND_ORE.get());
    }

    private void detectedObject(UseOnContext pContext, BlockPos posClicked, BlockPos below, Player player, Block block) {
        if (this.soundEvent != null) {
            ModSounds.playSound(pContext.m_43725_(), posClicked, this.soundEvent);
        }
        int distance = posClicked.m_123342_() - below.m_123342_();
        player.m_213846_((Component)Component.m_237110_((String)"item.buildhouse.metal_detector.message_ore_found", (Object[])new Object[]{Component.m_237115_((String)block.m_7705_()).m_130938_(style -> style.m_131140_(ChatFormatting.GOLD)), Component.m_237113_((String)("" + below.m_123341_())).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA)), Component.m_237113_((String)("" + below.m_123342_())).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA)), Component.m_237113_((String)("" + below.m_123343_())).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA)), distance}));
    }

    private boolean isValuableBlock(BlockState state) {
        return state.m_204336_(ModTags.Blocks.METAL_DETECTOR_VALUABLES);
    }
}

