/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.item.tool.axe;

import com.olivadevelop.buildhouse.interfaces.ICreativeTabOrder;
import com.olivadevelop.buildhouse.interfaces.IEventActionsTool;
import com.olivadevelop.buildhouse.item.tool.ToolBuilders;
import com.olivadevelop.buildhouse.util.CustomToolBuilder;
import com.olivadevelop.buildhouse.util.MobEffectConfig;
import com.olivadevelop.buildhouse.util.ModUtils;
import com.olivadevelop.buildhouse.util.MultiplierDropExperienceFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomAxeItemTool
extends AxeItem
implements ICreativeTabOrder,
IEventActionsTool {
    protected int dropMultiplier;
    protected int expMultiplier;
    private final int order;
    private final boolean makePiglinsNeutral;
    private final String description;
    private final String descriptionShift;
    private final List<MultiplierDropExperienceFilter<Integer, Class<? extends Entity>>> dropMobMultiplierFilter = new ArrayList<MultiplierDropExperienceFilter<Integer, Class<? extends Entity>>>();
    private final List<MultiplierDropExperienceFilter<Integer, Class<? extends Entity>>> dropMobExperienceMultiplierFilter = new ArrayList<MultiplierDropExperienceFilter<Integer, Class<? extends Entity>>>();
    private final List<MultiplierDropExperienceFilter<Integer, Class<? extends Block>>> dropBlockMultiplierFilter = new ArrayList<MultiplierDropExperienceFilter<Integer, Class<? extends Block>>>();
    private final List<MultiplierDropExperienceFilter<Integer, Class<? extends Block>>> dropBlockExperienceMultiplierFilter = new ArrayList<MultiplierDropExperienceFilter<Integer, Class<? extends Block>>>();
    private final List<MobEffectConfig> playerEffects = new ArrayList<MobEffectConfig>();

    protected abstract void _build();

    public CustomAxeItemTool(String description) {
        this(ToolBuilders.PLATINUM_TOOL_BUILDER.setDescription(description));
    }

    public CustomAxeItemTool(String description, String descriptionShift) {
        this(ToolBuilders.PLATINUM_TOOL_BUILDER.setDescription(description).setDescriptionShift(descriptionShift));
    }

    public CustomAxeItemTool(CustomToolBuilder builder) {
        super(builder.getTier(), (float)((int)builder.getDamage()), builder.getUseTime(), builder.getProperties());
        this.dropMultiplier = builder.getDropMultiplier();
        this.expMultiplier = builder.getExpMultiplier();
        this.order = builder.getOrder();
        this.description = builder.getDescription();
        this.descriptionShift = builder.getDescriptionShift();
        this.makePiglinsNeutral = builder.isMakePiglingsNeutral();
        this._build();
    }

    public boolean m_6813_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockPos pPos, @NotNull LivingEntity pEntityLiving) {
        boolean mined = super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
        if (!pLevel.m_5776_() && mined && ModUtils.isTree(pState.m_60734_()) && pEntityLiving instanceof Player) {
            ModUtils.fellTree(pLevel, (Player)pEntityLiving, pPos, pState);
        }
        return mined;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)this.description).m_130940_(ChatFormatting.BLUE));
        if (Screen.m_96638_() && this.descriptionShift != null) {
            components.add((Component)Component.m_237115_((String)this.descriptionShift).m_130940_(ChatFormatting.AQUA));
        }
        super.m_7373_(itemStack, level, components, flag);
    }

    @Override
    public int getCreativeTabOrder() {
        return this.order;
    }

    @Override
    public int getGenericDropMultiplier() {
        return this.dropMultiplier;
    }

    @Override
    public int getGenericExperienceMultiplier() {
        return this.expMultiplier;
    }

    @Override
    public boolean isMakePiglinsNeutral() {
        return this.makePiglinsNeutral;
    }

    @Override
    public List<MultiplierDropExperienceFilter<Integer, Class<? extends Entity>>> getDropMobMultiplierFilter() {
        return this.dropMobMultiplierFilter;
    }

    @Override
    public List<MultiplierDropExperienceFilter<Integer, Class<? extends Entity>>> getDropMobExperienceMultiplierFilter() {
        return this.dropMobExperienceMultiplierFilter;
    }

    @Override
    public List<MultiplierDropExperienceFilter<Integer, Class<? extends Block>>> getDropBlockMultiplierFilter() {
        return this.dropBlockMultiplierFilter;
    }

    @Override
    public List<MultiplierDropExperienceFilter<Integer, Class<? extends Block>>> getDropBlockExperienceMultiplierFilter() {
        return this.dropBlockExperienceMultiplierFilter;
    }

    @Override
    public List<MobEffectConfig> getPlayerEffects() {
        return this.playerEffects;
    }
}

