/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemsProbabilityModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemsProbabilityModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemsProbabilityModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.list((Codec)ForgeRegistries.ITEMS.getCodec()).fieldOf("items").forGetter(m -> m.items)).and((App)Codec.list((Codec)Codec.FLOAT).fieldOf("itemsProbabilities").forGetter(m -> m.itemsProbabilities)).apply((Applicative)inst, AddItemsProbabilityModifier::new)));
    private final List<Item> items;
    private final List<Float> itemsProbabilities;

    public AddItemsProbabilityModifier(LootItemCondition[] conditionsIn, List<Item> items, List<Float> itemsProbabilities) {
        super(conditionsIn);
        this.items = items;
        this.itemsProbabilities = itemsProbabilities;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition c : this.conditions) {
            if (c.test((Object)context)) continue;
            return generatedLoot;
        }
        float probab = context.m_230907_().m_188501_();
        this.itemsProbabilities.stream().max(Float::compareTo).ifPresent(p -> {
            if (probab < p.floatValue()) {
                Item i = null;
                for (int x = 0; x < this.itemsProbabilities.size(); ++x) {
                    if (!(probab < this.itemsProbabilities.get(x).floatValue())) continue;
                    i = this.items.get(x);
                }
                if (i != null) {
                    generatedLoot.add((Object)new ItemStack(i));
                }
            }
        });
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

