/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.menu;

import com.olivadevelop.buildhouse.BuildHouse;
import com.olivadevelop.buildhouse.menu.ModConfiguration;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class IntegerSlider
extends AbstractSliderButton {
    private final ForgeConfigSpec.IntValue valueConfig;
    private final int minValue;
    private final int maxValue;
    private final String messageKey;
    private final String[] labelValues;

    public IntegerSlider(@NotNull Builder builder) {
        super(builder.x, builder.y, builder.width, builder.height, (Component)Component.m_237115_((String)builder.messageKey), (double)((Integer)builder.valueConfig.get() - builder.minValue) / (double)(builder.maxValue - builder.minValue));
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.valueConfig = builder.valueConfig;
        this.messageKey = builder.messageKey;
        this.labelValues = Component.m_237115_((String)(this.messageKey + ".values")).getString().split(";");
        this.m_257544_(builder.tooltip);
        this.m_5695_();
    }

    protected void m_5695_() {
        int value = this.minValue + (int)(this.f_93577_ * (double)(this.maxValue - this.minValue));
        this.m_93666_((Component)Component.m_237113_((String)(Component.m_237115_((String)this.messageKey).getString() + this.labelValues[value - 1])));
    }

    protected void m_5697_() {
        try {
            int value = this.minValue + (int)(this.f_93577_ * (double)(this.maxValue - this.minValue));
            ModConfiguration.updateIntConfigValueFromPath(this.valueConfig, value);
        }
        catch (Exception e) {
            try {
                int value = this.minValue + (int)(this.f_93577_ * (double)(this.maxValue - this.minValue));
                ModConfiguration.updateIntConfigValueFromPath(this.valueConfig, value);
            }
            catch (Exception e2) {
                BuildHouse.LOGGER.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final ForgeConfigSpec.IntValue valueConfig;
        private final String messageKey;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private final int minValue;
        private final int maxValue;

        public Builder(ForgeConfigSpec.IntValue valueConfig, String messageKey, int minValue, int maxValue) {
            this.valueConfig = valueConfig;
            this.messageKey = messageKey;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public Builder pos(int pX, int pY) {
            this.x = pX;
            this.y = pY;
            return this;
        }

        public Builder width(int pWidth) {
            this.width = pWidth;
            return this;
        }

        public Builder size(int pWidth, int pHeight) {
            this.width = pWidth;
            this.height = pHeight;
            return this;
        }

        public Builder bounds(int pX, int pY, int pWidth, int pHeight) {
            return this.pos(pX, pY).size(pWidth, pHeight);
        }

        public Builder tooltip(@Nullable Tooltip pTooltip) {
            this.tooltip = pTooltip;
            return this;
        }

        public IntegerSlider build() {
            return this.build(IntegerSlider::new);
        }

        public IntegerSlider build(Function<Builder, IntegerSlider> builder) {
            return builder.apply(this);
        }
    }
}

