/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.menu;

import java.util.HashMap;
import java.util.Map;

public enum LevelConfigOption {
    LOW(1, 1000),
    Normal(2, 5000),
    High(3, 10000),
    EPIC(4, 20000),
    EXTREM(5, 40000);

    private final int level;
    private final int id;
    private static final Map<Integer, LevelConfigOption> ID_TO_OPTION_MAP;

    private LevelConfigOption(int id, int level) {
        this.level = level;
        this.id = id;
    }

    public int getLevel() {
        return this.level;
    }

    public int getId() {
        return this.id;
    }

    public static LevelConfigOption getLevel(Integer id) {
        return ID_TO_OPTION_MAP.getOrDefault(id, LOW);
    }

    public static int getLevelConfig(Integer id) {
        LevelConfigOption opt = ID_TO_OPTION_MAP.getOrDefault(id, LOW);
        return opt.getLevel() / 20;
    }

    static {
        ID_TO_OPTION_MAP = new HashMap<Integer, LevelConfigOption>();
        for (LevelConfigOption option : LevelConfigOption.values()) {
            ID_TO_OPTION_MAP.put(option.getId(), option);
        }
    }
}

