/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.menu;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfiguration {
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final ConfigValues CLIENT;
    public static final String BUILDHOUSE = "buildhouse";

    public static void updateIntConfigValueFromPath(ForgeConfigSpec.IntValue pathRef, int value) {
        Optional<String> path = pathRef.getPath().stream().filter(p -> !p.equals(BUILDHOUSE)).findFirst();
        if (path.isPresent()) {
            if (ModConfiguration.CLIENT.blocksPerSecond.getPath().contains(path.get())) {
                ModConfiguration.CLIENT.blocksPerSecond.set((Object)value);
            } else if (ModConfiguration.CLIENT.groundBlocksPerSecond.getPath().contains(path.get())) {
                ModConfiguration.CLIENT.groundBlocksPerSecond.set((Object)value);
            } else if (ModConfiguration.CLIENT.entitiesPerSecond.getPath().contains(path.get())) {
                ModConfiguration.CLIENT.entitiesPerSecond.set((Object)value);
            } else if (ModConfiguration.CLIENT.groundGenerationType.getPath().contains(path.get())) {
                ModConfiguration.CLIENT.groundGenerationType.set((Object)value);
            }
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ConfigValues::new);
        CLIENT_CONFIG = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ConfigValues)specPair.getLeft();
    }

    public static class ConfigValues {
        public final ForgeConfigSpec.IntValue blocksPerSecond;
        public final ForgeConfigSpec.IntValue groundBlocksPerSecond;
        public final ForgeConfigSpec.IntValue entitiesPerSecond;
        public final ForgeConfigSpec.BooleanValue shuflleGenerationBlocks;
        public final ForgeConfigSpec.BooleanValue groundGenerationBlocks;
        public final ForgeConfigSpec.IntValue groundGenerationType;
        public final ForgeConfigSpec.BooleanValue capsuleDimensionRestricted;

        public ConfigValues(ForgeConfigSpec.Builder builder) {
            builder.push(ModConfiguration.BUILDHOUSE);
            this.blocksPerSecond = builder.comment(Component.m_237115_((String)"menu.comment.blocks_per_second").getString()).defineInRange("blocksPerSecond", 2, 1, 5);
            this.groundBlocksPerSecond = builder.comment(Component.m_237115_((String)"menu.comment.ground_blocks_per_second").getString()).defineInRange("groundBlocksPerSecond", 2, 1, 5);
            this.entitiesPerSecond = builder.comment(Component.m_237115_((String)"menu.comment.entities_per_second").getString()).defineInRange("entitiesPerSecond", 2, 1, 5);
            this.shuflleGenerationBlocks = builder.comment(Component.m_237115_((String)"menu.comment.shuflle_generation_blocks").getString()).define("shufllegenerationblocks", false);
            this.groundGenerationBlocks = builder.comment(Component.m_237115_((String)"menu.comment.ground_generation_active").getString()).define("groundGenerationActive", true);
            this.groundGenerationType = builder.comment(Component.m_237115_((String)"menu.comment.ground_generation_type").getString()).defineInRange("groundGenerationType", 1, 1, 6);
            this.capsuleDimensionRestricted = builder.comment(Component.m_237115_((String)"menu.comment.capsule_dimension_restricted").getString()).define("capsuleDimensionRestricted", true);
            builder.pop();
        }
    }
}

