/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.olivadevelop.buildhouse.BuildHouse;
import com.olivadevelop.buildhouse.Constants;
import com.olivadevelop.buildhouse.core.ServerPlayerConfig;
import com.olivadevelop.buildhouse.entity.CapsuleType;
import com.olivadevelop.buildhouse.sound.ModSounds;
import com.olivadevelop.buildhouse.structure.data.StructureData;
import com.olivadevelop.buildhouse.structure.data.StructurePart;
import com.olivadevelop.buildhouse.structure.data.StructureProperty;
import com.olivadevelop.buildhouse.structure.processors.CapsuleStructureProcessor;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.thirdparty.xaerosworldmap.CapsuleActivatedPacket;
import com.olivadevelop.buildhouse.thirdparty.xaerosworldmap.XaerosWorldMapModCompatPlugin;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public abstract class Structures {
    private static final List<StructureData> STRUCTURES = new ArrayList<StructureData>();

    public static List<StructureData> getStructures() {
        return Collections.unmodifiableList(STRUCTURES);
    }

    public static List<StructureData> getStructures(@NotNull CapsuleType capsule) {
        return STRUCTURES.stream().filter(s -> s.getCapsuleType().equals((Object)capsule)).toList();
    }

    public static List<StructureData> getStructures(@NotNull CapsuleType capsule, @NotNull String dimension) {
        ArrayList<StructureData> s = new ArrayList<StructureData>();
        for (StructureData structure : STRUCTURES) {
            if (structure.getDimension() == null || !dimension.equals(structure.getDimension().m_135815_()) || !structure.getCapsuleType().getName().equalsIgnoreCase(capsule.getName())) continue;
            s.add(structure);
        }
        return s;
    }

    public static void startPlace(ServerLevel level, Entity owner, BlockPos collisionPos, CapsuleType capsule) {
        ResourceLocation dimension = level.m_46472_().m_135782_();
        List<StructureData> listStructures = ServerPlayerConfig.getPlayerPref(owner.m_20149_()).getCapsuleDimensionRestricted() != false ? Structures.getStructures(capsule, dimension.m_135815_()) : Structures.getStructures(capsule);
        if (ModUtils.isEmpty(listStructures)) {
            owner.m_213846_((Component)Component.m_237115_((String)"structure.buildhouse.structures_empty"));
            return;
        }
        StructureData structure = listStructures.get(level.m_213780_().m_188503_(listStructures.size()));
        StructureTemplateManager stm = level.m_215082_();
        ArrayList<StructurePart> fullStructure = new ArrayList<StructurePart>();
        fullStructure.add(structure.getStructure().copy());
        fullStructure.addAll(Optional.of(structure.getParts().stream().map(StructurePart::copy).toList()).orElse(Collections.emptyList()));
        BlockPos centerPos = Structures.getCenterPos(collisionPos, fullStructure);
        DataProceduralGenerationStructure data = new DataProceduralGenerationStructure(capsule, level, owner, centerPos);
        data.getStructuresName().addAll(fullStructure.stream().map(StructurePart::getName).toList());
        for (StructurePart structurePart : fullStructure) {
            data.getEntities().addAll(structurePart.getTag().m_128437_("entities", 10).stream().map(te -> {
                Optional<Double> below;
                CompoundTag ct = (CompoundTag)te;
                BlockPos bPos = ModUtils.listTagToBlockPos(ct.m_128437_("blockPos", 3));
                bPos = bPos.m_121955_((Vec3i)centerPos);
                bPos = bPos.m_121955_((Vec3i)structurePart.getStartPos());
                if (structurePart.hasProperty(Constants.StructureParams.POS_BELOW) && (below = structurePart.getExplicitProperty(Constants.StructureParams.POS_BELOW, Double.class)).isPresent()) {
                    bPos = bPos.m_6625_(below.get().intValue());
                }
                Vec3 pos = new Vec3((double)bPos.m_123341_(), (double)bPos.m_123342_(), (double)bPos.m_123343_());
                CompoundTag nbt = ct.m_128469_("nbt");
                return new StructureTemplate.StructureEntityInfo(pos, bPos, nbt);
            }).toList());
            structurePart.getTag().m_128437_("entities", 10).clear();
            StructureTemplate st = stm.m_230404_(structurePart.getTag());
            StructurePlaceSettings sps = new StructurePlaceSettings();
            sps.m_163782_(false);
            sps.m_74383_((StructureProcessor)new CapsuleStructureProcessor(data, st, structurePart));
            BlockPos offset = Structures.applyStructureProperties(centerPos, structurePart);
            st.m_230328_((ServerLevelAccessor)level, offset, centerPos, sps, level.m_213780_(), 3);
        }
        Structures.showParticles(level, collisionPos);
        ModSounds.playSound((Level)level, collisionPos, (SoundEvent)ModSounds.CAPSULE_SOUND.get());
        XaerosWorldMapModCompatPlugin.Instance.handlePacket(new CapsuleActivatedPacket("", collisionPos));
    }

    public static void loadAllOnServer() throws IOException {
        ResourceLocation structuresDir = new ResourceLocation("buildhouse", "structures/");
        Gson mapper = ModUtils.getGson();
        for (ResourceLocation level : Constants.LEVELS) {
            for (CapsuleType capsule : CapsuleType.values()) {
                if (capsule.getName().equalsIgnoreCase(CapsuleType.PLATINUM.getName())) {
                    Structures.loadPlatinumCapsule(mapper);
                    continue;
                }
                Structures.loadCapsules(level, capsule, structuresDir, mapper);
            }
        }
    }

    private static void loadCapsules(ResourceLocation level, CapsuleType capsule, ResourceLocation structuresDir, Gson mapper) throws IOException {
        String structuresGroupFileName = String.format("structures_%s_%s.json", capsule.getName().toLowerCase(), level.m_135815_());
        ResourceLocation location = new ResourceLocation("buildhouse", structuresDir.m_135815_() + structuresGroupFileName);
        Optional<InputStream> opt = ModUtils.getResource(location);
        if (opt.isEmpty()) {
            return;
        }
        InputStream inputStream = opt.get();
        Type listType = new TypeToken<List<StructureData>>(){}.getType();
        List structureDataList = (List)mapper.fromJson(ModUtils.readJsonFromInputStream(inputStream), listType);
        inputStream.close();
        if (ModUtils.isEmpty(structureDataList)) {
            return;
        }
        for (StructureData sd : structureDataList) {
            sd.setDimension(level);
            if (Structures.readInternalStructurePart(sd, level, sd.getStructure())) continue;
            if (ModUtils.isNotEmpty(sd.getParts())) {
                for (StructurePart part : sd.getParts()) {
                    Structures.readInternalStructurePart(sd, level, part);
                }
            }
            STRUCTURES.add(sd);
        }
    }

    private static boolean readInternalStructurePart(StructureData sd, ResourceLocation level, StructurePart sd1) throws IOException {
        ResourceLocation pLocation = new ResourceLocation("buildhouse", String.format("structures/%s/%s/%s", sd.getCapsuleType().getName().toLowerCase(), level.m_135815_().toLowerCase(), sd1.getName() + ".nbt"));
        Optional<InputStream> opt = ModUtils.getResource(pLocation);
        if (opt.isEmpty()) {
            return true;
        }
        InputStream nbtFile = opt.get();
        sd1.setTag(NbtIo.m_128939_((InputStream)nbtFile));
        nbtFile.close();
        return false;
    }

    private static void loadPlatinumCapsule(Gson mapper) {
        File structuresExternalDir = new File(FMLPaths.GAMEDIR.get().toString(), "structures");
        if (!structuresExternalDir.exists() && structuresExternalDir.mkdir()) {
            structuresExternalDir = new File(FMLPaths.GAMEDIR.get().toString(), "structures");
        }
        if (structuresExternalDir.exists()) {
            if (!structuresExternalDir.canRead()) {
                throw new RuntimeException("No se puede leer el directorio structures");
            }
            Object[] files = structuresExternalDir.listFiles();
            if (ModUtils.isNotEmpty(files)) {
                Arrays.stream(files).filter(File::isFile).filter(f -> f.getName().endsWith(".json")).forEach(arg_0 -> Structures.lambda$loadPlatinumCapsule$3(mapper, (File[])files, arg_0));
            }
        }
    }

    private static void getNbtFileStructurePart(File[] files, StructurePart strData, StructureData strData1) throws IOException {
        Optional<File> optNbt = Arrays.stream(files).filter(File::isFile).filter(f -> f.getName().endsWith(".nbt")).filter(f -> Structures.validateName(f, strData)).findFirst();
        if (optNbt.isPresent()) {
            strData1.getStructure().setTag(Structures.getTag(optNbt.get()));
        }
    }

    private static boolean validateName(File f, StructurePart strData) {
        String[] nameWithOutExt = f.getName().split("\\.");
        return nameWithOutExt[0].equalsIgnoreCase(strData.getName());
    }

    private static CompoundTag getTag(File nbtFile) throws IOException {
        return NbtIo.m_128939_((InputStream)new DataInputStream(new FileInputStream(nbtFile.getPath())));
    }

    private static BlockPos applyStructureProperties(BlockPos blockPos, StructurePart structurePart) {
        if (structurePart == null || ModUtils.isEmpty(structurePart.getProperties())) {
            return blockPos;
        }
        for (StructureProperty property : structurePart.getProperties()) {
            if (Constants.StructureParams.POS_BELOW.equals(property.getProperty())) {
                blockPos = blockPos.m_6625_(((Double)property.getValue()).intValue());
                continue;
            }
            if (!Constants.StructureParams.XYZ.equals(property.getProperty())) continue;
            Object object = property.getValue();
            if (object instanceof ArrayList) {
                ArrayList list = (ArrayList)object;
                if (list.size() != 3) continue;
                Vec3i vec3i = new Vec3i(((Double)list.get(0)).intValue(), ((Double)list.get(1)).intValue(), ((Double)list.get(2)).intValue());
                blockPos = blockPos.m_121955_(vec3i);
                continue;
            }
            blockPos = blockPos.m_121955_((Vec3i)property.getValue());
        }
        return blockPos;
    }

    private static void showParticles(ServerLevel level, BlockPos centerPivot) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)centerPivot.m_123341_(), (double)centerPivot.m_123342_(), (double)centerPivot.m_123343_(), 100, 0.0, 0.0, 0.0, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)centerPivot.m_123341_(), (double)centerPivot.m_123342_(), (double)centerPivot.m_123343_(), 100, 0.0, 0.0, 0.0, 0.01);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)centerPivot.m_123341_(), (double)centerPivot.m_123342_(), (double)centerPivot.m_123343_(), 500, 2.0, 2.0, 2.0, 0.001);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)centerPivot.m_123341_(), (double)centerPivot.m_123342_(), (double)centerPivot.m_123343_(), 2, 0.0, 0.0, 0.0, 0.5);
    }

    @NotNull
    private static BlockPos getCenterPos(BlockPos collisionPos, List<StructurePart> fullStructure) {
        Vec3 sizeStructure = Vec3.f_82478_;
        for (StructurePart structurePart : fullStructure) {
            sizeStructure = sizeStructure.m_82549_(ModUtils.listTagToIntVec3(structurePart.getTag().m_128437_("size", 3)));
        }
        Vec3 center = sizeStructure.m_82490_(0.5);
        return collisionPos.m_121996_(new Vec3i((int)center.m_7096_(), 0, (int)center.m_7094_()));
    }

    private static /* synthetic */ void lambda$loadPlatinumCapsule$3(Gson mapper, File[] files, File file) {
        try {
            StructureData strData = (StructureData)mapper.fromJson(Files.readString(file.toPath()), StructureData.class);
            if (strData == null) {
                return;
            }
            strData.setCapsuleType(CapsuleType.PLATINUM);
            strData.setDimension(Constants.LEVELS.get(0));
            Structures.getNbtFileStructurePart(files, strData.getStructure(), strData);
            if (ModUtils.isNotEmpty(strData.getParts())) {
                for (StructurePart part : strData.getParts()) {
                    Structures.getNbtFileStructurePart(files, part, strData);
                }
            }
            if (!STRUCTURES.contains(strData)) {
                STRUCTURES.add(strData);
            }
        }
        catch (IOException e) {
            BuildHouse.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

