/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.background;

import com.olivadevelop.buildhouse.datagen.loot.ModChestLootTables;
import com.olivadevelop.buildhouse.entity.CapsuleType;
import com.olivadevelop.buildhouse.menu.LevelConfigOption;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

class GenerationUtils {
    GenerationUtils() {
    }

    static void processBlocks(DataProceduralGenerationStructure currentData, Queue<StructureTemplate.StructureBlockInfo> blockQueue, BlockProcessor processor, Integer level) {
        for (int i = 0; i < LevelConfigOption.getLevelConfig(level) && !blockQueue.isEmpty(); ++i) {
            StructureTemplate.StructureBlockInfo block = blockQueue.poll();
            if (block == null) continue;
            processor.process(currentData, block);
        }
    }

    static void processEntities(DataProceduralGenerationStructure currentData, Queue<StructureTemplate.StructureEntityInfo> entityQueue, Integer level) {
        for (int i = 0; i < LevelConfigOption.getLevelConfig(level) && !entityQueue.isEmpty(); ++i) {
            StructureTemplate.StructureEntityInfo entityInfo = entityQueue.poll();
            if (entityInfo == null) continue;
            GenerationUtils.placeEntity(currentData, entityInfo);
        }
    }

    static void placeGroundBlock(DataProceduralGenerationStructure currentData, StructureTemplate.StructureBlockInfo block) {
        currentData.getLevel().m_46597_(block.f_74675_(), block.f_74676_());
    }

    static void placeStructureBlock(DataProceduralGenerationStructure currentData, StructureTemplate.StructureBlockInfo block) {
        BlockEntity entity;
        currentData.getLevel().m_46597_(block.f_74675_(), block.f_74676_());
        if (block.f_74677_() != null && (entity = currentData.getLevel().m_7702_(block.f_74675_())) != null) {
            entity.m_142466_(block.f_74677_());
            entity.m_6596_();
            if (CapsuleType.PLATINUM.equals((Object)currentData.getCapsule()) && entity instanceof RandomizableContainerBlockEntity) {
                RandomizableContainerBlockEntity cbe = (RandomizableContainerBlockEntity)entity;
                ChestLootValidation clv = new ChestLootValidation(cbe);
                if (cbe.m_7983_() && !clv.hasLootTable()) {
                    cbe.m_59626_(ModChestLootTables.PLATINUM_CAPSULE_CHEST_LOOT, 0L);
                    entity.m_6596_();
                }
            }
        }
    }

    static void placeEntity(DataProceduralGenerationStructure currentData, StructureTemplate.StructureEntityInfo entityInfo) {
        Vec3 pos = entityInfo.f_74683_;
        CompoundTag nbt = entityInfo.f_74685_.m_6426_();
        if (!nbt.m_128425_("id", 8)) {
            return;
        }
        String entityId = nbt.m_128461_("id");
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityId));
        if (entityType == null) {
            return;
        }
        Entity e = entityType.m_20615_((Level)currentData.getLevel());
        if (e == null) {
            return;
        }
        e.m_20258_(nbt);
        e.m_20084_(UUID.randomUUID());
        if (e instanceof ArmorStand) {
            e.m_7678_(pos.f_82479_ + 0.5, pos.f_82480_, pos.f_82481_ + 0.5, e.m_146908_(), e.m_146909_());
        } else {
            e.m_7678_(pos.f_82479_, pos.f_82480_, pos.f_82481_, e.m_146908_(), e.m_146909_());
        }
        currentData.getLevel().m_7967_(e);
    }

    @FunctionalInterface
    static interface BlockProcessor {
        public void process(DataProceduralGenerationStructure var1, StructureTemplate.StructureBlockInfo var2);
    }

    static class ChestLootValidation
    extends RandomizableContainerBlockEntity {
        protected ChestLootValidation(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
            super(pType, pPos, pBlockState);
        }

        public ChestLootValidation(RandomizableContainerBlockEntity cbe) {
            this(cbe.m_58903_(), cbe.m_58899_(), cbe.m_58900_());
        }

        protected NonNullList<ItemStack> m_7086_() {
            return null;
        }

        protected void m_6520_(NonNullList<ItemStack> pItemStacks) {
        }

        protected Component m_6820_() {
            return null;
        }

        protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
            return null;
        }

        public int m_6643_() {
            return 0;
        }

        public boolean hasLootTable() {
            return this.f_59605_ != null;
        }
    }
}

