/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.background;

import com.olivadevelop.buildhouse.core.ServerPlayerConfig;
import com.olivadevelop.buildhouse.structure.background.GenerationUtils;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="buildhouse", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GroundGeneration {
    private static boolean started;
    private static final Queue<StructureTemplate.StructureBlockInfo> groundBlocks;
    private static final Queue<DataProceduralGenerationStructure> queue;
    private static DataProceduralGenerationStructure currentData;
    private static boolean printedGroundMessage;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && started) {
            if (ModUtils.isEmpty(groundBlocks)) {
                if (ModUtils.isNotEmpty(queue)) {
                    GroundGeneration.internalStart();
                } else {
                    GroundGeneration.reset();
                }
            } else if (ModUtils.isNotEmpty(groundBlocks)) {
                if (!printedGroundMessage) {
                    printedGroundMessage = true;
                }
                GroundGeneration.writeGroundBlocks();
            }
        } else if (ModUtils.isNotEmpty(queue)) {
            GroundGeneration.internalStart();
        }
    }

    public static void addGeneration(@NotNull DataProceduralGenerationStructure data) {
        queue.add(data);
    }

    private static void internalStart() {
        DataProceduralGenerationStructure data;
        if (ModUtils.isNotEmpty(queue) && (data = queue.poll()) != null) {
            GroundGeneration.processData(data);
            started = true;
            printedGroundMessage = false;
        }
    }

    private static void processData(DataProceduralGenerationStructure data) {
        if (ServerPlayerConfig.getPlayerPref(data.getPlayer().m_20149_()).getShuflleGenerationBlocks().booleanValue()) {
            Collections.shuffle(data.getGroundBlocks());
        }
        groundBlocks.addAll(data.getGroundBlocks());
        currentData = data;
    }

    private static void reset() {
        started = false;
        printedGroundMessage = false;
        currentData = null;
        queue.clear();
    }

    private static void writeGroundBlocks() {
        GenerationUtils.processBlocks(currentData, groundBlocks, GenerationUtils::placeGroundBlock, ServerPlayerConfig.getPlayerPref(currentData.getPlayer().m_20149_()).getGroundBlocksPerSecond());
    }

    static {
        groundBlocks = new ConcurrentLinkedQueue<StructureTemplate.StructureBlockInfo>();
        queue = new ConcurrentLinkedQueue<DataProceduralGenerationStructure>();
    }
}

