/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.background;

import com.olivadevelop.buildhouse.core.ServerPlayerConfig;
import com.olivadevelop.buildhouse.structure.background.GenerationUtils;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="buildhouse", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StructureGeneration {
    private static boolean started;
    private static final Queue<StructureTemplate.StructureBlockInfo> structureBlocks;
    private static final Queue<StructureTemplate.StructureEntityInfo> entities;
    private static final Queue<DataProceduralGenerationStructure> queue;
    private static DataProceduralGenerationStructure currentData;
    private static boolean printedEntitiesMessage;
    private static boolean printedStructureMessage;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && started) {
            if (ModUtils.isEmpty(structureBlocks) && ModUtils.isEmpty(entities)) {
                if (ModUtils.isNotEmpty(queue)) {
                    StructureGeneration.internalStart();
                } else {
                    if (currentData != null) {
                        currentData.getPlayer().m_213846_((Component)Component.m_237115_((String)"structure.buildhouse.building_finished"));
                    }
                    StructureGeneration.reset();
                }
            } else if (ModUtils.isNotEmpty(structureBlocks)) {
                if (!printedStructureMessage) {
                    currentData.getPlayer().m_213846_((Component)Component.m_237115_((String)"structure.buildhouse.building_structure"));
                    printedStructureMessage = true;
                }
                StructureGeneration.writeStructureBlocks();
            } else if (ModUtils.isNotEmpty(entities)) {
                if (!printedEntitiesMessage) {
                    currentData.getPlayer().m_213846_((Component)Component.m_237115_((String)"structure.buildhouse.building_last_adjustments"));
                    printedEntitiesMessage = true;
                }
                StructureGeneration.writeEntities();
            }
        } else if (ModUtils.isNotEmpty(queue)) {
            StructureGeneration.internalStart();
        }
    }

    public static void addGeneration(@NotNull DataProceduralGenerationStructure data) {
        queue.add(data);
    }

    private static void internalStart() {
        DataProceduralGenerationStructure data;
        if (ModUtils.isNotEmpty(queue) && (data = queue.poll()) != null) {
            StructureGeneration.processData(data);
            started = true;
            data.getPlayer().m_213846_((Component)Component.m_237115_((String)"structure.buildhouse.building_started"));
            printedEntitiesMessage = false;
            printedStructureMessage = false;
        }
    }

    private static void processData(DataProceduralGenerationStructure data) {
        if (ServerPlayerConfig.getPlayerPref(data.getPlayer().m_20149_()).getShuflleGenerationBlocks().booleanValue()) {
            Collections.shuffle(data.getStructureBlocks());
        }
        data.getStructureBlocks().sort((o1, o2) -> {
            boolean isO2Air;
            boolean isO1Air = o1.f_74676_().m_60734_() == Blocks.f_50016_;
            boolean bl = isO2Air = o2.f_74676_().m_60734_() == Blocks.f_50016_;
            if (isO1Air && !isO2Air) {
                return -1;
            }
            if (!isO1Air && isO2Air) {
                return 1;
            }
            return 0;
        });
        structureBlocks.addAll(data.getStructureBlocks());
        entities.addAll(data.getEntities());
        currentData = data;
    }

    private static void reset() {
        started = false;
        printedEntitiesMessage = false;
        printedStructureMessage = false;
        currentData = null;
        queue.clear();
    }

    private static void writeStructureBlocks() {
        GenerationUtils.processBlocks(currentData, structureBlocks, GenerationUtils::placeStructureBlock, ServerPlayerConfig.getPlayerPref(currentData.getPlayer().m_20149_()).getBlocksPerSecond());
    }

    private static void writeEntities() {
        GenerationUtils.processEntities(currentData, entities, ServerPlayerConfig.getPlayerPref(currentData.getPlayer().m_20149_()).getEntitiesPerSecond());
    }

    static {
        structureBlocks = new ConcurrentLinkedQueue<StructureTemplate.StructureBlockInfo>();
        entities = new ConcurrentLinkedQueue<StructureTemplate.StructureEntityInfo>();
        queue = new ConcurrentLinkedQueue<DataProceduralGenerationStructure>();
    }
}

