/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.data;

import com.olivadevelop.buildhouse.BuildHouse;
import com.olivadevelop.buildhouse.structure.data.StructureProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;

public class StructurePart {
    private String name;
    private CompoundTag tag;
    private BlockPos startPos = BlockPos.f_121853_;
    private List<StructureProperty> properties = new ArrayList<StructureProperty>();

    public StructurePart() {
    }

    public StructurePart(StructurePart st) {
        this.name = st.name;
        this.tag = st.tag.m_6426_();
        this.startPos = new BlockPos((Vec3i)st.startPos);
        this.properties = new ArrayList<StructureProperty>(st.properties);
    }

    public StructurePart(String name, List<StructureProperty> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<StructureProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<StructureProperty> properties) {
        this.properties = properties;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public void setStartPos(BlockPos startPos) {
        this.startPos = startPos;
    }

    public boolean hasProperty(String key) {
        return this.properties != null && this.properties.stream().anyMatch(p -> p.getProperty().equals(key));
    }

    public Optional<StructureProperty> getProperty(String key) {
        Optional<StructureProperty> value = Optional.empty();
        if (this.hasProperty(key)) {
            value = this.properties.stream().filter(p -> p.getProperty().equals(key)).findFirst();
        }
        return value;
    }

    public boolean getBooleanProperty(String key) {
        boolean value = false;
        try {
            if (this.hasProperty(key)) {
                if (this.getProperty(key).isEmpty()) {
                    throw new ClassCastException("Property " + key + " is not found");
                }
                value = (Boolean)this.getProperty(key).get().getValue();
            }
        }
        catch (ClassCastException e) {
            BuildHouse.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public <T> Optional<T> getExplicitProperty(String key, Class<T> type) {
        try {
            Optional<StructureProperty> value = this.getProperty(key);
            if (value.isPresent() && type.isInstance(value.get().getValue())) {
                return Optional.of(type.cast(value.get().getValue()));
            }
            BuildHouse.LOGGER.error("Property {} is not of type {}", (Object)key, (Object)type.getName());
        }
        catch (ClassCastException e) {
            BuildHouse.LOGGER.error("Error casting property {} to type {}: {}", new Object[]{key, type.getName(), e.getMessage(), e});
        }
        return Optional.empty();
    }

    public StructurePart copy() {
        return new StructurePart(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructurePart that = (StructurePart)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.tag, that.tag) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tag, this.properties);
    }
}

