/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.processors;

import com.olivadevelop.buildhouse.core.ServerPlayerConfig;
import com.olivadevelop.buildhouse.structure.background.StructureGeneration;
import com.olivadevelop.buildhouse.structure.data.StructurePart;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.structure.processors.GroundProcessor;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class CapsuleStructureProcessor
extends StructureProcessor {
    private final DataProceduralGenerationStructure data;
    private final StructureTemplate st;
    private final StructurePart structurePart;

    public CapsuleStructureProcessor(DataProceduralGenerationStructure data, StructureTemplate st, StructurePart sp) {
        this.data = data;
        this.st = st;
        this.structurePart = sp;
    }

    @NotNull
    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorType.f_74459_;
    }

    @NotNull
    public List<StructureTemplate.StructureBlockInfo> m_276976_(@NotNull ServerLevelAccessor pServerLevel, @NotNull BlockPos pOffset, @NotNull BlockPos pPos, @NotNull List<StructureTemplate.StructureBlockInfo> pOriginalBlockInfos, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, @NotNull StructurePlaceSettings pSettings) {
        this.updateProcessedBlockInfos(pProcessedBlockInfos, this.structurePart.getStartPos());
        this.saveProcessedBlocks(pProcessedBlockInfos, (ServerLevel)pServerLevel, pPos.m_121955_((Vec3i)this.structurePart.getStartPos()), pSettings);
        return super.m_276976_(pServerLevel, pOffset, pPos, pOriginalBlockInfos, List.of(), pSettings);
    }

    private void updateProcessedBlockInfos(List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, BlockPos offsetStructure) {
        if (offsetStructure != null) {
            pProcessedBlockInfos.replaceAll(s -> new StructureTemplate.StructureBlockInfo(ModUtils.offset(s.f_74675_(), offsetStructure), s.f_74676_(), s.f_74677_()));
        }
    }

    private void saveProcessedBlocks(List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, ServerLevel pServerLevel, BlockPos pPos, StructurePlaceSettings pSettings) {
        this.data.getStructureBlocks().addAll(pProcessedBlockInfos);
        if (ServerPlayerConfig.getPlayerPref(this.data.getPlayer().m_20149_()).getGroundGenerationBlocks().booleanValue()) {
            GroundProcessor.prepareGroundBlocks(this.data, pProcessedBlockInfos, pServerLevel, pPos, this.st.m_74633_(pSettings, pPos));
        }
        this.data.addProcessedStructuresName();
        if (this.data.getProcess().isProcessed()) {
            if (ServerPlayerConfig.getPlayerPref(this.data.getPlayer().m_20149_()).getGroundGenerationBlocks().booleanValue()) {
                GroundProcessor.generateGroundBlocksAsync(this.data);
            }
            StructureGeneration.addGeneration(this.data);
        }
    }
}

