/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.processors;

import com.olivadevelop.buildhouse.entity.CapsuleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DataProceduralGenerationStructure {
    private final CapsuleType capsule;
    private final ServerLevel level;
    private final Entity player;
    private final BlockPos center;
    private final List<String> structuresName = new ArrayList<String>();
    private final List<StructureTemplate.StructureBlockInfo> groundBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
    private final List<StructureTemplate.StructureBlockInfo> structureBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
    private final List<StructureTemplate.StructureEntityInfo> entities = new ArrayList<StructureTemplate.StructureEntityInfo>();
    private final Process process = new Process();

    public DataProceduralGenerationStructure(CapsuleType capsule, ServerLevel level, Entity player, BlockPos center) {
        this.capsule = capsule;
        this.level = level;
        this.player = player;
        this.center = center;
    }

    public static DataProceduralGenerationStructure copy(DataProceduralGenerationStructure original) {
        DataProceduralGenerationStructure data = new DataProceduralGenerationStructure(original.capsule, original.level, original.player, original.center);
        data.getStructuresName().addAll(original.getStructuresName());
        original.getGroundBlocks().addAll(original.getGroundBlocks());
        original.getStructureBlocks().addAll(original.getStructureBlocks());
        original.getEntities().addAll(original.getEntities());
        return data;
    }

    public CapsuleType getCapsule() {
        return this.capsule;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public Entity getPlayer() {
        return this.player;
    }

    public List<StructureTemplate.StructureBlockInfo> getGroundBlocks() {
        return this.groundBlocks;
    }

    public List<StructureTemplate.StructureBlockInfo> getStructureBlocks() {
        return this.structureBlocks;
    }

    public List<StructureTemplate.StructureEntityInfo> getEntities() {
        return this.entities;
    }

    public List<String> getStructuresName() {
        return this.structuresName;
    }

    public Process getProcess() {
        return this.process;
    }

    public void addProcessedStructuresName() {
        ++this.process.processedStructuresName;
        if (this.process.processedStructuresName == this.structuresName.size()) {
            this.process.structureBlocksFinished = true;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProceduralGenerationStructure that = (DataProceduralGenerationStructure)o;
        return Objects.equals(this.level, that.level) && Objects.equals(this.player, that.player) && Objects.equals(this.center, that.center) && Objects.equals(this.groundBlocks, that.groundBlocks) && Objects.equals(this.structureBlocks, that.structureBlocks) && Objects.equals(this.entities, that.entities);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.player, this.center, this.groundBlocks, this.structureBlocks, this.entities);
    }

    public static class Process {
        private int processedStructuresName;
        private boolean structureBlocksFinished;

        public boolean isProcessed() {
            return this.structureBlocksFinished;
        }
    }
}

