/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.processors;

import com.olivadevelop.buildhouse.BuildHouse;
import com.olivadevelop.buildhouse.core.ServerPlayerConfig;
import com.olivadevelop.buildhouse.structure.background.GroundGeneration;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.structure.processors.TypeGeneration;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public abstract class GroundProcessor {
    private static final ConcurrentMap<DataProceduralGenerationStructure, List<GroundData>> groundData = new ConcurrentHashMap<DataProceduralGenerationStructure, List<GroundData>>();

    public static void prepareGroundBlocks(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
        if (!groundData.containsKey(data)) {
            groundData.put(data, new ArrayList());
        }
        ((List)groundData.get(data)).add(new GroundData(pProcessedBlockInfos, world, startPos, bounds));
    }

    public static void generateGroundBlocksAsync(@NotNull DataProceduralGenerationStructure data) {
        if (!groundData.containsKey(data)) {
            return;
        }
        List gds = (List)groundData.get(data);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> GroundProcessor.generateGroundBlocksInternal(data, gds), ModUtils.executorService).thenAccept(GroundProcessor::onGroundBlocksGenerated)).exceptionally(GroundProcessor::handleGenerationException);
        groundData.remove(data);
    }

    private static void onGroundBlocksGenerated(@NotNull DataProceduralGenerationStructure data) {
        GroundGeneration.addGeneration(data);
    }

    private static Void handleGenerationException(Throwable e) {
        BuildHouse.LOGGER.error(e.getMessage(), e);
        return null;
    }

    private static DataProceduralGenerationStructure generateGroundBlocksInternal(@NotNull DataProceduralGenerationStructure data, List<GroundData> groundData) {
        data.getPlayer().m_213846_((Component)Component.m_237115_((String)"structure.buildhouse.preparing_ground"));
        for (GroundData gData : groundData) {
            TypeGeneration.find(ServerPlayerConfig.getPlayerPref(data.getPlayer().m_20149_()).getGroundGenerationType()).ifPresent(g -> g.run(data, gData.blocks(), gData.world(), gData.startPos(), gData.bounds()));
        }
        return data;
    }

    public record GroundData(List<StructureTemplate.StructureBlockInfo> blocks, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
    }
}

