/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.processors;

import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.structure.processors.IGroundGenerator;
import com.olivadevelop.buildhouse.structure.processors.generators.FullConeGenerator;
import com.olivadevelop.buildhouse.structure.processors.generators.FullNaturalGenerator;
import com.olivadevelop.buildhouse.structure.processors.generators.FullSimpleGenerator;
import com.olivadevelop.buildhouse.structure.processors.generators.HollowConeGenerator;
import com.olivadevelop.buildhouse.structure.processors.generators.HollowNaturalGenerator;
import com.olivadevelop.buildhouse.structure.processors.generators.HollowSimpleGenerator;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public enum TypeGeneration {
    HOLLOW_SIMPLE(1, HollowSimpleGenerator.class),
    FULL_SIMPLE(2, FullSimpleGenerator.class),
    HOLLOW_CONE(3, HollowConeGenerator.class),
    FULL_CONE(4, FullConeGenerator.class),
    HOLLOW_NATURAL(5, HollowNaturalGenerator.class),
    FULL_NATURAL(6, FullNaturalGenerator.class);

    private final Integer code;
    private final Class<? extends IGroundGenerator> gen;

    private TypeGeneration(Integer code, Class<? extends IGroundGenerator> gen) {
        this.code = code;
        this.gen = gen;
    }

    public Integer getCode() {
        return this.code;
    }

    public Class<? extends IGroundGenerator> getGen() {
        return this.gen;
    }

    public static Optional<TypeGeneration> find(int id) {
        for (TypeGeneration t : TypeGeneration.values()) {
            if (!t.getCode().equals(id)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public void run(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
        try {
            this.getGen().getDeclaredConstructor(DataProceduralGenerationStructure.class, List.class, ServerLevel.class, BlockPos.class, BoundingBox.class).newInstance(data, processedBlocks, world, startPos, bounds);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

