/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.processors.generators;

import com.olivadevelop.buildhouse.Constants;
import com.olivadevelop.buildhouse.block.ModBlocks;
import com.olivadevelop.buildhouse.structure.background.GroundGeneration;
import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.structure.processors.IGroundGenerator;
import com.olivadevelop.buildhouse.util.ModUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

abstract class AbstractGroundGenerator
implements IGroundGenerator {
    public AbstractGroundGenerator(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
        this.init(data, processedBlocks, world, startPos, bounds);
    }

    private void init(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
        LinkedList<StructureTemplate.StructureBlockInfo> newBlocks = new LinkedList<StructureTemplate.StructureBlockInfo>();
        this.generation(data, processedBlocks, world, startPos, bounds, newBlocks);
        List<StructureTemplate.StructureBlockInfo> b = newBlocks.stream().collect(Collectors.toMap(StructureTemplate.StructureBlockInfo::f_74675_, info -> info, (existing, replacement) -> existing)).values().stream().toList();
        data.getGroundBlocks().addAll(b);
        ArrayList<StructureTemplate.StructureBlockInfo> finalBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        finalBlocks.addAll(processedBlocks);
        finalBlocks.addAll(b);
        this.background(data, finalBlocks, world, startPos, bounds);
    }

    protected abstract void generation(@NotNull DataProceduralGenerationStructure var1, @NotNull List<StructureTemplate.StructureBlockInfo> var2, ServerLevel var3, BlockPos var4, BoundingBox var5, List<StructureTemplate.StructureBlockInfo> var6);

    protected void doInBackground(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds, List<StructureTemplate.StructureBlockInfo> blocks) {
    }

    private void background(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
        CompletableFuture.runAsync(() -> {
            LinkedList<StructureTemplate.StructureBlockInfo> blocks = new LinkedList<StructureTemplate.StructureBlockInfo>();
            this.doInBackground(data, processedBlocks, world, startPos, bounds, blocks);
            if (blocks.isEmpty()) {
                return;
            }
            DataProceduralGenerationStructure d = DataProceduralGenerationStructure.copy(data);
            d.getGroundBlocks().addAll(blocks);
            d.addProcessedStructuresName();
            GroundGeneration.addGeneration(d);
        }, ModUtils.executorService);
    }

    protected void generateLayer(int centerX, int centerZ, int radius, int y, BlockPos startPos, List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, ServerLevel world, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z > radius * radius) continue;
                BlockPos pos = startPos.m_7918_(centerX + x, y, centerZ + z);
                this.generateBlockAt(false, y, pos, pProcessedBlockInfos, world, newBlocks);
            }
        }
    }

    protected void generateLayerEdge(int centerX, int centerZ, int radius, int y, BlockPos startPos, List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, ServerLevel world, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance >= (double)(radius - 1)) || !(distance <= (double)radius)) continue;
                BlockPos pos = startPos.m_7918_(centerX + x, y, centerZ + z);
                this.generateBlockAt(true, y, pos, pProcessedBlockInfos, world, newBlocks);
            }
        }
    }

    protected void generateLayerLight(int centerX, int centerZ, int radius, int y, BlockPos startPos, List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, ServerLevel world, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos pos;
                if (x * x + z * z > radius * radius || !this.isPositionValid(pProcessedBlockInfos, pos = startPos.m_7918_(centerX + x, y, centerZ + z)) || !this.canSpawnTerrainToGround((Level)world, pos)) continue;
                newBlocks.add(new StructureTemplate.StructureBlockInfo(pos, ((Block)ModBlocks.WHITE_LIGHT_BLOCK.get()).m_49966_(), null));
            }
        }
    }

    protected int calculateDimension(int min, int max) {
        return Math.abs(min - max);
    }

    protected int calculateCenter(int dimension) {
        return dimension / 2 - (dimension / 2 % 2 == 0 ? 1 : 0);
    }

    protected void generateBlockAt(boolean isSurface, int y, BlockPos pos, List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, ServerLevel world, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        if (this.isPositionValid(pProcessedBlockInfos, pos) && this.canSpawnTerrainToGround((Level)world, pos)) {
            BlockState state = this.getBlockState(isSurface, world, y, pos, pProcessedBlockInfos, newBlocks);
            newBlocks.add(new StructureTemplate.StructureBlockInfo(pos, state, null));
        }
    }

    protected boolean isPositionValid(List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, BlockPos pos) {
        for (StructureTemplate.StructureBlockInfo info : pProcessedBlockInfos) {
            if (!info.f_74675_().equals((Object)pos)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected BlockState getBlockState(boolean isSurface, ServerLevel world, int y, BlockPos pos, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos, @NotNull List<StructureTemplate.StructureBlockInfo> newBlocks) {
        if (world.m_46472_().m_135782_().equals((Object)Level.f_46429_.m_135782_())) {
            return this.getNetherBlockState();
        }
        if (world.m_46472_().m_135782_().equals((Object)Level.f_46430_.m_135782_())) {
            return this.getEndBlockState();
        }
        Holder biome = world.m_204166_(pos);
        if (biome.m_203373_(Constants.Biomes.SNOWY_SLOPES)) {
            return this.getSnowySlopesBlockState(world, pos, newBlocks);
        }
        if ((Math.abs(y) == 1 || isSurface) && world.m_8055_(pos.m_7494_()).m_60795_()) {
            if (biome.m_203373_(Constants.Biomes.MUSHROOM_FIELDS)) {
                return this.getMyceliumBlockState(world, pos, newBlocks, pProcessedBlockInfos);
            }
            if (biome.m_203373_(Constants.Biomes.SPRUCE_TAIGA)) {
                return this.getSpruceTaigaBlockState(world, pos, newBlocks, pProcessedBlockInfos);
            }
            if (biome.m_203373_(Constants.Biomes.WOODED_BADLANDS)) {
                return this.getWoodedBadlandsBlockState(world, pos, newBlocks, pProcessedBlockInfos);
            }
            if (biome.m_203373_(Constants.Biomes.CHERRY_GROVE)) {
                return this.getCherryGroveBlockState(world, pos, newBlocks, pProcessedBlockInfos);
            }
            if (biome.m_203373_(Constants.Biomes.DESERT)) {
                return this.getSandBlockState(world, pos, Blocks.f_49992_, newBlocks);
            }
            return this.getGrassBlockState(world, pos, newBlocks);
        }
        if (biome.m_203373_(Constants.Biomes.BEACH)) {
            return this.getSandBlockState(world, pos, Blocks.f_50062_, newBlocks);
        }
        return ModUtils.getGroundRandomBlock().m_49966_();
    }

    @NotNull
    protected BlockState getGrassBlockState(ServerLevel world, BlockPos pos, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        BlockState blockState = Blocks.f_50440_.m_49966_();
        this.addSurfaceBlock(world, pos, Blocks.f_50034_, 40, newBlocks, List.of());
        return blockState;
    }

    @NotNull
    protected BlockState getMyceliumBlockState(ServerLevel world, BlockPos pos, List<StructureTemplate.StructureBlockInfo> newBlocks, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos) {
        BlockState blockState = Blocks.f_50195_.m_49966_();
        this.addSurfaceBlock(world, pos, Blocks.f_50072_, 4, newBlocks, pProcessedBlockInfos);
        return blockState;
    }

    @NotNull
    protected BlockState getSandBlockState(ServerLevel world, BlockPos pos, Block block, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        BlockState blockState = block.m_49966_();
        if (Blocks.f_49992_.equals(block)) {
            this.addSurfaceBlock(world, pos, Blocks.f_50128_, 1, newBlocks, List.of());
        }
        return blockState;
    }

    @NotNull
    protected BlockState getSpruceTaigaBlockState(ServerLevel world, BlockPos pos, List<StructureTemplate.StructureBlockInfo> newBlocks, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos) {
        BlockState blockState = Blocks.f_50599_.m_49966_();
        this.addSurfaceBlock(world, pos, Blocks.f_50035_, 20, newBlocks, pProcessedBlockInfos);
        return blockState;
    }

    @NotNull
    protected BlockState getWoodedBadlandsBlockState(ServerLevel world, BlockPos pos, List<StructureTemplate.StructureBlockInfo> newBlocks, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos) {
        BlockState blockState = Blocks.f_50394_.m_49966_();
        this.addSurfaceBlock(world, pos, Blocks.f_50036_, 20, newBlocks, pProcessedBlockInfos);
        return blockState;
    }

    @NotNull
    protected BlockState getCherryGroveBlockState(ServerLevel world, BlockPos pos, List<StructureTemplate.StructureBlockInfo> newBlocks, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos) {
        BlockState blockState = Blocks.f_50440_.m_49966_();
        this.addSurfaceBlock(world, pos, Blocks.f_271445_, 60, newBlocks, pProcessedBlockInfos);
        return blockState;
    }

    @NotNull
    protected BlockState getSnowySlopesBlockState(ServerLevel world, BlockPos pos, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        BlockState blockState = Blocks.f_50127_.m_49966_();
        this.addSurfaceBlock(world, pos, Blocks.f_50125_, 30, newBlocks, List.of());
        return blockState;
    }

    protected void addSurfaceBlock(ServerLevel world, BlockPos pos, Block surfaceBlock, int probability, @NotNull List<StructureTemplate.StructureBlockInfo> newBlocks, @NotNull List<StructureTemplate.StructureBlockInfo> pProcessedBlockInfos) {
        if (world.m_213780_().m_216332_(0, 100) > 100 - probability) {
            StructureTemplate.StructureBlockInfo info = new StructureTemplate.StructureBlockInfo(pos.m_7494_(), surfaceBlock.m_49966_(), null);
            if (this.canSpawnTerrainToGround((Level)world, pos) && newBlocks.stream().noneMatch(n -> n.f_74675_().equals((Object)pos.m_7494_())) && pProcessedBlockInfos.stream().noneMatch(n -> n.f_74675_().equals((Object)pos.m_7494_()))) {
                newBlocks.add(info);
            }
        }
    }

    @NotNull
    protected BlockState getNetherBlockState() {
        return Blocks.f_50134_.m_49966_();
    }

    @NotNull
    protected BlockState getEndBlockState() {
        return Blocks.f_50259_.m_49966_();
    }

    protected boolean canSpawnTerrainToGround(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return !state.m_155947_() && state.m_247087_() && !state.m_60713_(Blocks.f_50752_) && (state.m_60795_() || state.m_60734_() instanceof LiquidBlock || state.m_60734_() instanceof BushBlock);
    }

    protected int calcDistanceToGround(ServerLevel world, BlockPos offset) {
        int distance = 0;
        BlockPos p = offset;
        while (this.canSpawnTerrainToGround((Level)world, p)) {
            p = p.m_7495_();
            ++distance;
        }
        return distance;
    }

    protected int getDistanceToGround(ServerLevel world, BlockPos startPos, int radius, int centerX, int centerZ) {
        int distanceToGround = 0;
        for (int x = -(radius += 10); x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int d = this.calcDistanceToGround(world, startPos.m_7918_(centerX + x, -1, centerZ + z));
                distanceToGround = Math.max(d, distanceToGround);
            }
        }
        return distanceToGround;
    }
}

