/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.structure.processors.generators;

import com.olivadevelop.buildhouse.structure.processors.DataProceduralGenerationStructure;
import com.olivadevelop.buildhouse.structure.processors.generators.AbstractGroundGenerator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class FullNaturalGenerator
extends AbstractGroundGenerator {
    public FullNaturalGenerator(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds) {
        super(data, processedBlocks, world, startPos, bounds);
    }

    @Override
    protected void generation(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds, List<StructureTemplate.StructureBlockInfo> newBlocks) {
        int maxX = this.calculateDimension(bounds.m_162395_(), bounds.m_162399_());
        int maxZ = this.calculateDimension(bounds.m_162398_(), bounds.m_162401_());
        int centerX = this.calculateCenter(maxX);
        int centerZ = this.calculateCenter(maxZ);
        int distanceToGround = this.getDistanceToGround(world, startPos, maxX, centerX, centerZ);
        for (int y = 1; y < distanceToGround; ++y) {
            int radius = Math.min(y, 10);
            if (y == 1) {
                this.generateLayer(centerX, centerZ, maxX + radius, -y, startPos, processedBlocks, world, newBlocks);
                continue;
            }
            this.generateLayerEdge(centerX, centerZ, maxX + radius, -y, startPos, processedBlocks, world, newBlocks);
        }
    }

    @Override
    protected void doInBackground(@NotNull DataProceduralGenerationStructure data, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlocks, ServerLevel world, BlockPos startPos, BoundingBox bounds, List<StructureTemplate.StructureBlockInfo> blocks) {
        int maxX = Math.abs(bounds.m_162395_() - bounds.m_162399_());
        int maxZ = Math.abs(bounds.m_162398_() - bounds.m_162401_());
        int centerX = maxX / 2 - (maxX / 2 % 2 == 0 ? 1 : 0);
        int centerZ = maxZ / 2 - (maxZ / 2 % 2 == 0 ? 1 : 0);
        int distanceToGround = this.getDistanceToGround(world, startPos, maxX, centerX, centerZ);
        for (int y = 2; y < distanceToGround; ++y) {
            int radius = Math.min(y, 10);
            this.generateLayer(centerX, centerZ, maxX + (radius - 1), -y, startPos, processedBlocks, world, blocks);
        }
    }
}

