/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.util;

import com.olivadevelop.buildhouse.Constants;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;

public class CustomToolBuilder {
    private final int order;
    private final Tier tier;
    private final Item.Properties properties;
    private String description;
    private String descriptionShift;
    private float damage = 1.0f;
    private float useTime = 1.0f;
    private int dropMultiplier = 1;
    private int expMultiplier = 1;
    private boolean makePiglingsNeutral;
    private boolean mineFullVein;

    public CustomToolBuilder(Tier tier, int order, float damage, float useTime, Rarity rarity, Constants.DURABILITY durability, boolean makePiglingsNeutral, boolean mineFullVein) {
        this(tier, order, damage, useTime, rarity, durability, true, makePiglingsNeutral, mineFullVein);
    }

    public CustomToolBuilder(Tier tier, int order, float damage, float useTime, Rarity rarity, Constants.DURABILITY durability, boolean repairable, boolean makePiglingsNeutral, boolean mineFullVein) {
        this.order = order;
        this.damage = damage;
        this.useTime = useTime;
        this.tier = tier;
        this.properties = new Item.Properties().m_41497_(rarity).m_41503_(durability.getDurability());
        this.makePiglingsNeutral = makePiglingsNeutral;
        this.mineFullVein = mineFullVein;
        if (!repairable) {
            this.properties.setNoRepair();
        }
    }

    public static CustomToolBuilder getNew(Tier tier, int order, float damage, float useTime, Rarity rarity, Constants.DURABILITY durability, boolean makePiglingsNeutral, boolean mineFullVein) {
        return new CustomToolBuilder(tier, order, damage, useTime, rarity, durability, makePiglingsNeutral, mineFullVein);
    }

    public static CustomToolBuilder getNew(Tier tier, int order, float damage, float useTime, Rarity rarity, Constants.DURABILITY durability, boolean repairable, boolean makePiglingsNeutral, boolean mineFullVein) {
        return new CustomToolBuilder(tier, order, damage, useTime, rarity, durability, repairable, makePiglingsNeutral, mineFullVein);
    }

    public Tier getTier() {
        return this.tier;
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public int getOrder() {
        return this.order;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getUseTime() {
        return this.useTime;
    }

    public String getDescription() {
        return this.description;
    }

    public CustomToolBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public int getDropMultiplier() {
        return this.dropMultiplier;
    }

    public CustomToolBuilder setDropMultiplier(int dropMultiplier) {
        this.dropMultiplier = dropMultiplier;
        return this;
    }

    public int getExpMultiplier() {
        return this.expMultiplier;
    }

    public CustomToolBuilder setExpMultiplier(int expMultiplier) {
        this.expMultiplier = expMultiplier;
        return this;
    }

    public String getDescriptionShift() {
        return this.descriptionShift;
    }

    public CustomToolBuilder setDescriptionShift(String descriptionShift) {
        this.descriptionShift = descriptionShift;
        return this;
    }

    public boolean isMakePiglingsNeutral() {
        return this.makePiglingsNeutral;
    }

    public CustomToolBuilder setMakePiglingsNeutral(boolean makePiglingsNeutral) {
        this.makePiglingsNeutral = makePiglingsNeutral;
        return this;
    }

    public boolean isMineFullVein() {
        return this.mineFullVein;
    }

    public CustomToolBuilder setMineFullVein(boolean mineFullVein) {
        this.mineFullVein = mineFullVein;
        return this;
    }
}

