/*
 * Decompiled with CFR 0.152.
 */
package com.olivadevelop.buildhouse.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonNull;
import com.olivadevelop.buildhouse.BuildHouse;
import com.olivadevelop.buildhouse.block.ModBlocks;
import com.olivadevelop.buildhouse.util.KeyValue;
import com.olivadevelop.buildhouse.util.MobEffectConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ModUtils {
    public static final ExecutorService executorService = Executors.newCachedThreadPool();
    public static final List<Block> GROUND_BLOCKS;
    public static final List<Block> ORE_BLOCKS;
    public static final List<Block> LOG_BLOCKS;
    public static final List<Block> FARMABLE_BLOCKS;
    public static final List<Block> FOLIAGE_BLOCKS;
    public static final List<KeyValue<Block, Double>> GROUND_PROBABILITY_BLOCKS;
    public static final double MAX_GROUND_RANDOM_PROBABILITY = 1.0;

    private static double getProbability(double percent) {
        return 1.0 * (percent / 100.0);
    }

    public static boolean isBlockFloor(@NotNull Block block) {
        return GROUND_BLOCKS.contains(block) || block instanceof DropExperienceBlock;
    }

    public static boolean isBlockFloor(@NotNull List<Block> blocks) {
        return blocks.stream().anyMatch(ModUtils::isBlockFloor);
    }

    public static boolean isOre(@NotNull Block block) {
        return ORE_BLOCKS.contains(block) || block instanceof DropExperienceBlock;
    }

    public static boolean isTree(@NotNull Block block) {
        return LOG_BLOCKS.contains(block) || block instanceof RotatedPillarBlock;
    }

    public static boolean isFarmable(@NotNull Block block) {
        return FARMABLE_BLOCKS.contains(block);
    }

    public static boolean isFoliage(@NotNull Block block) {
        return FOLIAGE_BLOCKS.contains(block) || block instanceof LeavesBlock;
    }

    public static void mineVein(Level world, Player player, BlockPos pos, BlockState state) {
        ModUtils.mineBlocks(world, player, pos, state);
    }

    public static void fellTree(Level world, Player player, BlockPos pos, BlockState state) {
        ModUtils.mineBlocks(world, player, pos, state);
    }

    public static void trimFoliage(Level world, Player player, BlockPos pos, BlockState state) {
        ModUtils.mineBlocks(world, player, pos, state);
    }

    public static void tillSoil(Level world, Player player, BlockPos pos, BlockState state, UniformInt range) {
        int radius = range.m_142739_() / 2;
        BlockPos first = pos.m_7918_(radius, 0, radius);
        LinkedHashSet<BlockPos> posList = new LinkedHashSet<BlockPos>();
        for (int x = 0; x <= range.m_142737_(); ++x) {
            for (int z = 0; z <= range.m_142737_(); ++z) {
                BlockPos p2 = first.m_7918_(x, 0, z);
                if (ModUtils.isFarmable(world.m_8055_(p2).m_60734_())) {
                    posList.add(p2);
                    continue;
                }
                if (ModUtils.isFarmable(world.m_8055_(p2.m_7495_()).m_60734_())) {
                    posList.add(p2.m_7495_());
                    continue;
                }
                if (world.m_8055_(p2.m_7494_()).m_60795_()) {
                    posList.add(p2);
                    continue;
                }
                if (!ModUtils.isFarmable(world.m_8055_(p2.m_7494_()).m_60734_())) continue;
                posList.add(p2.m_7494_());
            }
        }
        posList.forEach(p -> world.m_46961_(p.m_7494_(), false));
        posList.forEach(p -> world.m_46961_(p.m_6630_(2), false));
        posList.forEach(p -> world.m_46597_(p, Blocks.f_50093_.m_49966_()));
        world.m_46597_(pos, Blocks.f_49990_.m_49966_());
        world.m_46597_(pos.m_7495_(), Blocks.f_50493_.m_49966_());
    }

    private static void mineBlocks(Level world, Player player, BlockPos pos, BlockState state) {
        ModUtils.mineBlocks(world, player, pos, state, UniformInt.m_146622_((int)-1, (int)1));
    }

    private static void mineBlocks(Level world, Player player, BlockPos pos, BlockState state, UniformInt range) {
        LinkedList<BlockPos> toBreak = new LinkedList<BlockPos>();
        toBreak.add(pos);
        while (!toBreak.isEmpty()) {
            BlockPos currentPos = (BlockPos)toBreak.poll();
            BlockState currentState = world.m_8055_(currentPos);
            if (!currentState.m_60734_().equals(state.m_60734_())) continue;
            currentState.m_60734_().m_6240_(world, player, currentPos, currentState, null, player.m_21205_());
            world.m_7471_(currentPos, false);
            List<BlockPos> bloquesAdyacentes = ModUtils.getEqualsAdjacentBlocksFromBlockPos(world, currentPos, state.m_60734_(), range);
            for (BlockPos adjacentPos : bloquesAdyacentes) {
                if (toBreak.contains(adjacentPos)) continue;
                toBreak.add(adjacentPos);
            }
        }
    }

    public static List<BlockPos> getEqualsAdjacentBlocksFromBlockPos(Level world, BlockPos currentPos, Block block, UniformInt range) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = range.m_142739_(); x <= range.m_142737_(); ++x) {
            for (int y = range.m_142739_(); y <= range.m_142737_(); ++y) {
                for (int z = range.m_142739_(); z <= range.m_142737_(); ++z) {
                    BlockPos pos = currentPos.m_7918_(x, y, z);
                    if (!world.m_8055_(pos).m_60713_(block)) continue;
                    list.add(pos);
                }
            }
        }
        return list;
    }

    public static boolean validateEnchantments(ItemStack book, boolean defaultValue, List<Enchantment> names) {
        boolean result = defaultValue;
        try {
            ListTag tags = (ListTag)book.getShareTag().m_128423_("StoredEnchantments");
            if (tags != null) {
                for (Tag tag : tags) {
                    String enchantment;
                    String[] bookTag = ((CompoundTag)tag).m_128423_("id").m_7916_().split(":");
                    String tagFinal = bookTag[bookTag.length - 1];
                    Iterator<String> iterator = names.stream().map(Enchantment::m_44704_).toList().iterator();
                    while (iterator.hasNext() && !(result = (enchantment = iterator.next()).contains(tagFinal))) {
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void addPlayerEffects(Player player, List<MobEffectConfig> playerEffects) {
        playerEffects.forEach(eff -> {
            if (!player.m_21220_().stream().map(MobEffectInstance::m_19544_).toList().contains(eff.effect())) {
                if (MobEffectConfig.KeyDown.Empty.equals((Object)eff.keyDown())) {
                    player.m_147215_(new MobEffectInstance(eff.effect(), eff.duration(), eff.amplifier()), (Entity)player);
                } else if (MobEffectConfig.KeyDown.Control.equals((Object)eff.keyDown()) && Screen.m_96637_()) {
                    player.m_147215_(new MobEffectInstance(eff.effect(), eff.duration(), eff.amplifier()), (Entity)player);
                } else if (MobEffectConfig.KeyDown.Shift.equals((Object)eff.keyDown()) && Screen.m_96638_()) {
                    player.m_147215_(new MobEffectInstance(eff.effect(), eff.duration(), eff.amplifier()), (Entity)player);
                } else if (MobEffectConfig.KeyDown.Alt.equals((Object)eff.keyDown()) && Screen.m_96639_()) {
                    player.m_147215_(new MobEffectInstance(eff.effect(), eff.duration(), eff.amplifier()), (Entity)player);
                }
            }
        });
    }

    public static Block getGroundRandomBlock() {
        double random = Math.random();
        double cumulativeProbability = 0.0;
        for (KeyValue<Block, Double> kv : GROUND_PROBABILITY_BLOCKS) {
            if (!(random <= (cumulativeProbability += kv.value().doubleValue()))) continue;
            return kv.key();
        }
        return Blocks.f_50493_;
    }

    public static BlockPos offset(BlockPos pos, BlockPos offset) {
        return pos.m_7918_(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    public static boolean isEmpty(Collection<?> obj) {
        return obj == null || obj.isEmpty();
    }

    public static boolean isEmpty(Object[] obj) {
        return obj == null || obj.length == 0;
    }

    public static boolean isNotEmpty(Collection<?> obj) {
        return !ModUtils.isEmpty(obj);
    }

    public static boolean isNotEmpty(Object[] obj) {
        return !ModUtils.isEmpty(obj);
    }

    public static String readJsonFromInputStream(@NotNull InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }

    public static Optional<InputStream> getResource(@NotNull ResourceLocation location) {
        return Optional.ofNullable(BuildHouse.class.getClassLoader().getResourceAsStream("assets/" + location.m_135827_() + "/" + location.m_135815_()));
    }

    @NotNull
    public static Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(Optional.class, (src, typeOfSrc, context) -> JsonNull.INSTANCE).registerTypeAdapter(Optional.class, (json, typeOfT, context) -> Optional.empty()).create();
    }

    public static Component booleanToString(boolean value) {
        return Component.m_237115_((String)(value ? "menu.boolean.true" : "menu.boolean.false"));
    }

    public static ListTag blockPosToListTag(BlockPos pos) {
        ListTag lt = new ListTag();
        lt.add((Object)IntTag.m_128679_((int)pos.m_123341_()));
        lt.add((Object)IntTag.m_128679_((int)pos.m_123342_()));
        lt.add((Object)IntTag.m_128679_((int)pos.m_123343_()));
        return lt;
    }

    public static Vec3 listTagToIntVec3(ListTag lt) {
        Vec3 i = Vec3.f_82478_;
        if (lt.size() == 3) {
            i = new Vec3((double)lt.m_128763_(0), (double)lt.m_128763_(1), (double)lt.m_128763_(2));
        }
        return i;
    }

    public static BlockPos listTagToBlockPos(ListTag lt) {
        BlockPos blockPos = BlockPos.f_121853_;
        if (lt.size() == 3) {
            blockPos = new BlockPos(lt.m_128763_(0), lt.m_128763_(1), lt.m_128763_(2));
        }
        return blockPos;
    }

    @NotNull
    public static Tooltip getTooltip(String pKey) {
        return Tooltip.m_257550_((Component)Component.m_237115_((String)pKey));
    }

    static {
        LinkedList<Block> gb = new LinkedList<Block>();
        LinkedList<Block> ob = new LinkedList<Block>();
        LinkedList<Block> lb = new LinkedList<Block>();
        LinkedList<Block> fb = new LinkedList<Block>();
        LinkedList<Block> fab = new LinkedList<Block>();
        LinkedList<KeyValue<Block, Double>> gpb = new LinkedList<KeyValue<Block, Double>>();
        gb.add(Blocks.f_50034_);
        gb.add(Blocks.f_50440_);
        gb.add(Blocks.f_50035_);
        gb.add(Blocks.f_50360_);
        gb.add(Blocks.f_50599_);
        gb.add(Blocks.f_50195_);
        gb.add(Blocks.f_152481_);
        gb.add(Blocks.f_50493_);
        gb.add(Blocks.f_50546_);
        gb.add(Blocks.f_152549_);
        gb.add(Blocks.f_220864_);
        gb.add(Blocks.f_50129_);
        gb.add(Blocks.f_49994_);
        gb.add(Blocks.f_49992_);
        gb.add(Blocks.f_49993_);
        gb.add(Blocks.f_50062_);
        gb.add(Blocks.f_50394_);
        gb.add(Blocks.f_50126_);
        gb.add(Blocks.f_50354_);
        gb.add(Blocks.f_50568_);
        gb.add(Blocks.f_50449_);
        gb.add(Blocks.f_50127_);
        gb.add(Blocks.f_50125_);
        gb.add(Blocks.f_152544_);
        gb.add(Blocks.f_152543_);
        gb.add(Blocks.f_152497_);
        gb.add(Blocks.f_152496_);
        gb.add(Blocks.f_152537_);
        gb.add(Blocks.f_220834_);
        gb.add(Blocks.f_50182_);
        gb.add(Blocks.f_50069_);
        gb.add(Blocks.f_50652_);
        gb.add(Blocks.f_50079_);
        gb.add(Blocks.f_50122_);
        gb.add(Blocks.f_50228_);
        gb.add(Blocks.f_50334_);
        gb.add(Blocks.f_276445_);
        gb.add(Blocks.f_271439_);
        gb.add(Blocks.f_152550_);
        gb.add(Blocks.f_49997_);
        gb.add(Blocks.f_152505_);
        gb.add(Blocks.f_50089_);
        gb.add(Blocks.f_49995_);
        gb.add(Blocks.f_50264_);
        gb.add(Blocks.f_49996_);
        gb.add(Blocks.f_50059_);
        gb.add(Blocks.f_50173_);
        gb.add(Blocks.f_152469_);
        gb.add(Blocks.f_152468_);
        gb.add(Blocks.f_152467_);
        gb.add(Blocks.f_152474_);
        gb.add(Blocks.f_152473_);
        gb.add(Blocks.f_152472_);
        gb.add(Blocks.f_152479_);
        gb.add(Blocks.f_50134_);
        gb.add(Blocks.f_50451_);
        gb.add(Blocks.f_50692_);
        gb.add(Blocks.f_50331_);
        gb.add(Blocks.f_49998_);
        gb.add(Blocks.f_50699_);
        gb.add(Blocks.f_50690_);
        gb.add(Blocks.f_50135_);
        gb.add(Blocks.f_50136_);
        gb.add(Blocks.f_50137_);
        gb.add(Blocks.f_152597_);
        gb.add(Blocks.f_50138_);
        gb.add(Blocks.f_50730_);
        gb.add(Blocks.f_50259_);
        GROUND_BLOCKS = Collections.unmodifiableList(gb);
        ob.add(Blocks.f_49997_);
        ob.add(Blocks.f_49996_);
        ob.add(Blocks.f_49995_);
        ob.add(Blocks.f_50089_);
        ob.add(Blocks.f_50173_);
        ob.add(Blocks.f_50059_);
        ob.add(Blocks.f_50264_);
        ob.add(Blocks.f_152469_);
        ob.add(Blocks.f_152468_);
        ob.add(Blocks.f_152467_);
        ob.add(Blocks.f_152474_);
        ob.add(Blocks.f_152473_);
        ob.add(Blocks.f_152472_);
        ob.add(Blocks.f_152479_);
        ob.add(Blocks.f_50331_);
        ob.add(Blocks.f_49998_);
        ob.add((Block)ModBlocks.ANTIMONIUM_ORE.get());
        ob.add((Block)ModBlocks.PLATINUM_ORE.get());
        ORE_BLOCKS = Collections.unmodifiableList(ob);
        lb.add(Blocks.f_49999_);
        lb.add(Blocks.f_50001_);
        lb.add(Blocks.f_50000_);
        lb.add(Blocks.f_50002_);
        lb.add(Blocks.f_50003_);
        lb.add(Blocks.f_50004_);
        lb.add(Blocks.f_271170_);
        lb.add(Blocks.f_220832_);
        lb.add(Blocks.f_50695_);
        lb.add(Blocks.f_50686_);
        LOG_BLOCKS = Collections.unmodifiableList(lb);
        fb.add(Blocks.f_50440_);
        fb.add(Blocks.f_50493_);
        FARMABLE_BLOCKS = Collections.unmodifiableList(fb);
        fab.add(Blocks.f_50050_);
        fab.add(Blocks.f_50051_);
        fab.add(Blocks.f_50052_);
        fab.add(Blocks.f_50053_);
        fab.add(Blocks.f_50054_);
        fab.add(Blocks.f_50055_);
        fab.add(Blocks.f_220838_);
        fab.add(Blocks.f_271115_);
        fab.add(Blocks.f_152470_);
        fab.add(Blocks.f_152471_);
        FOLIAGE_BLOCKS = Collections.unmodifiableList(fab);
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50493_, ModUtils.getProbability(0.28)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50069_, ModUtils.getProbability(0.25)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50228_, ModUtils.getProbability(0.22)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50122_, ModUtils.getProbability(0.2)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50334_, ModUtils.getProbability(0.03)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_49997_, ModUtils.getProbability(5.0E-4)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_152505_, ModUtils.getProbability(4.5E-4)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_49996_, ModUtils.getProbability(4.0E-4)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_49995_, ModUtils.getProbability(3.5E-4)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50059_, ModUtils.getProbability(2.8E-4)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50264_, ModUtils.getProbability(2.4E-4)));
        gpb.add(new KeyValue<Block, Double>(Blocks.f_50089_, ModUtils.getProbability(1.9E-4)));
        gpb.add(new KeyValue<Block, Double>((Block)ModBlocks.ANTIMONIUM_ORE.get(), ModUtils.getProbability(1.5E-4)));
        gpb.add(new KeyValue<Block, Double>((Block)ModBlocks.PLATINUM_ORE.get(), ModUtils.getProbability(1.0E-5)));
        GROUND_PROBABILITY_BLOCKS = Collections.unmodifiableList(gpb);
    }
}

