/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.StructureColorManager;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class UIRenderer {
    private static final int PADDING = 20;
    private final Map<String, Integer> statusColors;
    private final StructureColorManager colorManager;

    public UIRenderer(Map<String, Integer> statusColors, StructureColorManager colorManager) {
        this.statusColors = statusColors;
        this.colorManager = colorManager;
    }

    public void drawTitle(GuiGraphics ctx, int width) {
        Font font = Minecraft.getInstance().font;
        String title = Component.translatable((String)"gui.roadweaver.debug_map.title").getString();
        int tw = font.width(title);
        int x = (width - tw) / 2;
        int y = 28;
        RenderUtils.drawPanel(ctx, x - 10, y - 5, x + tw + 10, y + 14, -1073741824, -11890462);
        ctx.drawString(font, title, x, y, -1, true);
    }

    public void drawStatsPanel(GuiGraphics ctx, int width, List<Records.StructureInfo> structureInfos, List<Records.StructureConnection> connections, List<Records.RoadData> roads, double zoom, double baseScale) {
        Font font = Minecraft.getInstance().font;
        int planned = 0;
        int generating = 0;
        int completed = 0;
        int failed = 0;
        for (Records.StructureConnection structureConnection : connections) {
            switch (structureConnection.status()) {
                case PLANNED: {
                    ++planned;
                    break;
                }
                case GENERATING: {
                    ++generating;
                    break;
                }
                case COMPLETED: {
                    ++completed;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
            }
        }
        int validRoads = 0;
        for (Records.RoadData road : roads) {
            if (road.roadSegmentList() == null || road.roadSegmentList().size() < 2) continue;
            ++validRoads;
        }
        String[] stringArray = new String[]{Component.translatable((String)"gui.roadweaver.debug_map.structures", (Object[])new Object[]{structureInfos.size()}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.planned", (Object[])new Object[]{planned}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.generating", (Object[])new Object[]{generating}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.completed", (Object[])new Object[]{completed}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.failed", (Object[])new Object[]{failed}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.roads", (Object[])new Object[]{roads.size()}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.valid", (Object[])new Object[]{validRoads}).getString(), Component.translatable((String)"gui.roadweaver.debug_map.zoom", (Object[])new Object[]{String.format("%.1f", zoom)}).getString()};
        int[] colors = new int[]{this.statusColors.get("structure"), this.statusColors.get("planned"), this.statusColors.get("generating"), this.statusColors.get("completed"), this.statusColors.get("failed"), this.statusColors.get("road"), -16711936, -1};
        int maxWidth = 0;
        for (String label : stringArray) {
            maxWidth = Math.max(maxWidth, font.width(label));
        }
        int panelX = width - maxWidth - 20 - 20;
        int panelY = 60;
        int panelW = maxWidth + 16;
        int panelH = stringArray.length * 12 + 8;
        RenderUtils.drawPanel(ctx, panelX, panelY, panelX + panelW, panelY + panelH, -536870912, -13877680);
        for (int i = 0; i < stringArray.length; ++i) {
            int textY = panelY + 8 + i * 12;
            ctx.drawString(font, stringArray[i], panelX + 8, textY, colors[i], false);
        }
    }

    public void drawLegendPanel(GuiGraphics ctx, int height, List<Records.StructureInfo> visibleStructureInfos) {
        Font font = Minecraft.getInstance().font;
        LinkedHashMap<String, Integer> visibleStructureColors = new LinkedHashMap<String, Integer>();
        for (Records.StructureInfo info : visibleStructureInfos) {
            String structureId = info.structureId();
            if (visibleStructureColors.containsKey(structureId)) continue;
            visibleStructureColors.put(structureId, this.colorManager.getColorForStructure(structureId));
        }
        String[] fixedLabels = new String[]{Component.translatable((String)"gui.roadweaver.debug_map.legend.planned").getString(), Component.translatable((String)"gui.roadweaver.debug_map.legend.generating").getString(), Component.translatable((String)"gui.roadweaver.debug_map.legend.failed").getString(), Component.translatable((String)"gui.roadweaver.debug_map.legend.roads").getString(), Component.translatable((String)"gui.roadweaver.debug_map.legend.player").getString()};
        int[] fixedColors = new int[]{this.statusColors.get("planned"), this.statusColors.get("generating"), this.statusColors.get("failed"), this.statusColors.get("road"), -1618884};
        int maxWidth = 0;
        for (String label : fixedLabels) {
            maxWidth = Math.max(maxWidth, font.width(label));
        }
        for (String structureId : visibleStructureColors.keySet()) {
            String displayName = this.colorManager.getDisplayName(structureId);
            maxWidth = Math.max(maxWidth, font.width(displayName));
        }
        int totalItems = fixedLabels.length + visibleStructureColors.size();
        int panelX = 20;
        int panelY = height - totalItems * 12 - 20 - 16;
        int panelW = maxWidth + 32;
        int panelH = totalItems * 12 + 8;
        RenderUtils.drawPanel(ctx, panelX, panelY, panelX + panelW, panelY + panelH, -536870912, -13350562);
        int currentY = panelY + 8;
        for (Map.Entry entry : visibleStructureColors.entrySet()) {
            String displayName = this.colorManager.getDisplayName((String)entry.getKey());
            int color = (Integer)entry.getValue();
            RenderUtils.fillCircle(ctx, panelX + 12, currentY + 4, 3, color);
            ctx.drawString(font, displayName, panelX + 24, currentY, -1, false);
            currentY += 12;
        }
        for (int i = 0; i < fixedLabels.length; ++i) {
            RenderUtils.fillCircle(ctx, panelX + 12, currentY + 4, 3, fixedColors[i]);
            ctx.drawString(font, fixedLabels[i], panelX + 24, currentY, -1, false);
            currentY += 12;
        }
    }

    public void drawTooltip(GuiGraphics ctx, BlockPos structure, String structureId, int mouseX, int mouseY, int width) {
        Font font = Minecraft.getInstance().font;
        String displayName = this.colorManager.getDisplayName(structureId);
        String posText = Component.translatable((String)"gui.roadweaver.debug_map.position").getString() + ": " + structure.getX() + ", " + structure.getZ();
        int nameWidth = font.width(displayName);
        int posWidth = font.width(posText);
        int tooltipWidth = Math.max(nameWidth, posWidth) + 8;
        int tooltipHeight = 28;
        int x = mouseX + 10;
        int y = mouseY - 35;
        if (x + tooltipWidth > width) {
            x = mouseX - tooltipWidth - 10;
        }
        if (y < 0) {
            y = mouseY + 10;
        }
        int structureColor = this.colorManager.getColorForStructure(structureId);
        RenderUtils.drawPanel(ctx, x, y, x + tooltipWidth, y + tooltipHeight, -268435456, structureColor);
        ctx.drawString(font, displayName, x + 4, y + 5, -1, true);
        ctx.drawString(font, posText, x + 4, y + 16, -5592406, false);
    }
}

