/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.config.neoforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;

public class NeoForgeJsonConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("roadweaver.json");
    private static ConfigData data = new ConfigData();

    public static List<String> getStructuresToLocate() {
        return NeoForgeJsonConfig.data.structuresToLocate;
    }

    public static void setStructuresToLocate(List<String> value) {
        NeoForgeJsonConfig.data.structuresToLocate = value != null ? value : new ArrayList();
    }

    public static int getStructureSearchRadius() {
        return NeoForgeJsonConfig.data.structureSearchRadius;
    }

    public static void setStructureSearchRadius(int value) {
        NeoForgeJsonConfig.data.structureSearchRadius = value;
    }

    public static int getInitialLocatingCount() {
        return NeoForgeJsonConfig.data.initialLocatingCount;
    }

    public static void setInitialLocatingCount(int value) {
        NeoForgeJsonConfig.data.initialLocatingCount = value;
    }

    public static int getMaxConcurrentRoadGeneration() {
        return NeoForgeJsonConfig.data.maxConcurrentRoadGeneration;
    }

    public static void setMaxConcurrentRoadGeneration(int value) {
        NeoForgeJsonConfig.data.maxConcurrentRoadGeneration = value;
    }

    public static int getStructureSearchTriggerDistance() {
        return NeoForgeJsonConfig.data.structureSearchTriggerDistance;
    }

    public static void setStructureSearchTriggerDistance(int value) {
        NeoForgeJsonConfig.data.structureSearchTriggerDistance = Math.max(150, Math.min(1500, value));
    }

    public static int getAveragingRadius() {
        return NeoForgeJsonConfig.data.averagingRadius;
    }

    public static void setAveragingRadius(int value) {
        NeoForgeJsonConfig.data.averagingRadius = value;
    }

    public static boolean getAllowArtificial() {
        return NeoForgeJsonConfig.data.allowArtificial;
    }

    public static void setAllowArtificial(boolean value) {
        NeoForgeJsonConfig.data.allowArtificial = value;
    }

    public static boolean getAllowNatural() {
        return NeoForgeJsonConfig.data.allowNatural;
    }

    public static void setAllowNatural(boolean value) {
        NeoForgeJsonConfig.data.allowNatural = value;
    }

    public static int getStructureDistanceFromRoad() {
        return NeoForgeJsonConfig.data.structureDistanceFromRoad;
    }

    public static void setStructureDistanceFromRoad(int value) {
        NeoForgeJsonConfig.data.structureDistanceFromRoad = value;
    }

    public static int getMaxHeightDifference() {
        return NeoForgeJsonConfig.data.maxHeightDifference;
    }

    public static void setMaxHeightDifference(int value) {
        NeoForgeJsonConfig.data.maxHeightDifference = value;
    }

    public static int getMaxTerrainStability() {
        return NeoForgeJsonConfig.data.maxTerrainStability;
    }

    public static void setMaxTerrainStability(int value) {
        NeoForgeJsonConfig.data.maxTerrainStability = value;
    }

    public static boolean getPlaceWaypoints() {
        return NeoForgeJsonConfig.data.placeWaypoints;
    }

    public static void setPlaceWaypoints(boolean value) {
        NeoForgeJsonConfig.data.placeWaypoints = value;
    }

    public static boolean getPlaceRoadFences() {
        return NeoForgeJsonConfig.data.placeRoadFences;
    }

    public static void setPlaceRoadFences(boolean value) {
        NeoForgeJsonConfig.data.placeRoadFences = value;
    }

    public static boolean getPlaceSwings() {
        return NeoForgeJsonConfig.data.placeSwings;
    }

    public static void setPlaceSwings(boolean value) {
        NeoForgeJsonConfig.data.placeSwings = value;
    }

    public static boolean getPlaceBenches() {
        return NeoForgeJsonConfig.data.placeBenches;
    }

    public static void setPlaceBenches(boolean value) {
        NeoForgeJsonConfig.data.placeBenches = value;
    }

    public static boolean getPlaceGloriettes() {
        return NeoForgeJsonConfig.data.placeGloriettes;
    }

    public static void setPlaceGloriettes(boolean value) {
        NeoForgeJsonConfig.data.placeGloriettes = value;
    }

    public static int getManualMaxHeightDifference() {
        return NeoForgeJsonConfig.data.manualMaxHeightDifference;
    }

    public static void setManualMaxHeightDifference(int value) {
        NeoForgeJsonConfig.data.manualMaxHeightDifference = value;
    }

    public static int getManualMaxTerrainStability() {
        return NeoForgeJsonConfig.data.manualMaxTerrainStability;
    }

    public static void setManualMaxTerrainStability(int value) {
        NeoForgeJsonConfig.data.manualMaxTerrainStability = value;
    }

    public static boolean getManualIgnoreWater() {
        return NeoForgeJsonConfig.data.manualIgnoreWater;
    }

    public static void setManualIgnoreWater(boolean value) {
        NeoForgeJsonConfig.data.manualIgnoreWater = value;
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                data = (ConfigData)GSON.fromJson(json, ConfigData.class);
                if ((NeoForgeJsonConfig.data.structuresToLocate == null || NeoForgeJsonConfig.data.structuresToLocate.isEmpty()) && NeoForgeJsonConfig.data.structureToLocate != null && !NeoForgeJsonConfig.data.structureToLocate.isBlank()) {
                    NeoForgeJsonConfig.data.structuresToLocate = NeoForgeJsonConfig.tokenizeToList(NeoForgeJsonConfig.data.structureToLocate);
                    NeoForgeJsonConfig.data.structureToLocate = null;
                    NeoForgeJsonConfig.save();
                }
                if (NeoForgeJsonConfig.data.structureSearchTriggerDistance < 150 || NeoForgeJsonConfig.data.structureSearchTriggerDistance > 1500) {
                    NeoForgeJsonConfig.data.structureSearchTriggerDistance = 500;
                    NeoForgeJsonConfig.save();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (NeoForgeJsonConfig.data.structuresToLocate == null || NeoForgeJsonConfig.data.structuresToLocate.isEmpty()) {
                NeoForgeJsonConfig.data.structuresToLocate = new ArrayList<String>(List.of("#minecraft:village"));
            }
            NeoForgeJsonConfig.save();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> tokenizeToList(String raw) {
        ArrayList<String> list = new ArrayList<String>();
        if (raw == null) {
            return list;
        }
        String normalized = raw.replace('\r', '\n');
        List<String> lines = Arrays.asList(normalized.split("\n"));
        for (String line : lines) {
            String[] tokens;
            String trimmed;
            if (line == null || (trimmed = line.trim()).isEmpty()) continue;
            for (String t : tokens = trimmed.split("[;,\\s]+")) {
                String token;
                if (t == null || (token = t.trim()).isEmpty()) continue;
                list.add(token);
            }
        }
        return list;
    }

    private static class ConfigData {
        String structureToLocate = "#minecraft:village";
        List<String> structuresToLocate = new ArrayList<String>(List.of("#minecraft:village"));
        int structureSearchRadius = 100;
        int initialLocatingCount = 7;
        int maxConcurrentRoadGeneration = 3;
        int structureSearchTriggerDistance = 600;
        int averagingRadius = 1;
        boolean allowArtificial = true;
        boolean allowNatural = false;
        int structureDistanceFromRoad = 4;
        int maxHeightDifference = 5;
        int maxTerrainStability = 4;
        boolean placeWaypoints = false;
        boolean placeRoadFences = true;
        boolean placeSwings = false;
        boolean placeBenches = false;
        boolean placeGloriettes = false;
        int manualMaxHeightDifference = 10;
        int manualMaxTerrainStability = 10;
        boolean manualIgnoreWater = false;

        private ConfigData() {
        }
    }
}

