/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.config.neoforge;

import java.util.List;
import net.countered.settlementroads.features.config.neoforge.ModConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModPlacedFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModPlacedFeatures.class);
    public static final ResourceKey<PlacedFeature> ROAD_FEATURE_PLACED = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)"road_feature_placed"));

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        LOGGER.info("Bootstrapping placed features for NeoForge...");
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference roadFeature = configuredFeatures.getOrThrow(ModConfiguredFeatures.ROAD_FEATURE);
        List<HeightmapPlacement> roadPlacements = List.of(HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG));
        context.register(ROAD_FEATURE_PLACED, (Object)new PlacedFeature((Holder)roadFeature, roadPlacements));
        LOGGER.info("Placed features bootstrapped successfully.");
    }
}

