/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.StructureDecoration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GlorietteDecoration
extends StructureDecoration {
    public GlorietteDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world) {
        super(pos, direction, world, "gloriette", new Vec3i(5, 6, 5));
    }

    protected boolean checkGloriettePlacement() {
        if (!super.placeAllowed()) {
            return false;
        }
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 1; y <= 6; ++y) {
                    BlockPos checkPos = basePos.offset(x, y, z);
                    BlockState state = world.getBlockState(checkPos);
                    if (state.isAir() || state.getBlock().equals(Blocks.SHORT_GRASS) || state.getBlock().equals(Blocks.TALL_GRASS) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.LEAVES)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void place() {
        if (!this.checkGloriettePlacement()) {
            return;
        }
        super.place();
    }

    @Override
    protected void placeFallbackStructure() {
    }
}

