/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;

public class LamppostDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private final boolean leftRoadSide;
    private Records.WoodAssets wood;

    public LamppostDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, boolean leftRoadSide) {
        super(pos, direction, world);
        this.leftRoadSide = leftRoadSide;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        this.buildNewLamppost(basePos, world);
    }

    private void buildNewLamppost(BlockPos basePos, WorldGenLevel world) {
        world.setBlock(basePos, Blocks.COBBLED_DEEPSLATE_WALL.defaultBlockState(), 3);
        world.setBlock(basePos.above(1), Blocks.SPRUCE_FENCE.defaultBlockState(), 3);
        world.setBlock(basePos.above(2), Blocks.SPRUCE_FENCE.defaultBlockState(), 3);
        world.setBlock(basePos.above(3), Blocks.COBBLED_DEEPSLATE_WALL.defaultBlockState(), 3);
        BlockPos lampPos = basePos.above(4);
        world.setBlock(lampPos, Blocks.REDSTONE_LAMP.defaultBlockState(), 3);
        world.setBlock(basePos.above(5), (BlockState)Blocks.DAYLIGHT_DETECTOR.defaultBlockState().setValue((Property)BlockStateProperties.INVERTED, (Comparable)Boolean.valueOf(true)), 3);
        this.placeTrapdoorsAroundLamp(lampPos, world);
    }

    private void placeTrapdoorsAroundLamp(BlockPos lampPos, WorldGenLevel world) {
        world.setBlock(lampPos.east(), (BlockState)((BlockState)((BlockState)Blocks.SPRUCE_TRAPDOOR.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP), 3);
        world.setBlock(lampPos.west(), (BlockState)((BlockState)((BlockState)Blocks.SPRUCE_TRAPDOOR.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP), 3);
        world.setBlock(lampPos.south(), (BlockState)((BlockState)((BlockState)Blocks.SPRUCE_TRAPDOOR.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP), 3);
        world.setBlock(lampPos.north(), (BlockState)((BlockState)((BlockState)Blocks.SPRUCE_TRAPDOOR.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HALF, (Comparable)Half.TOP), 3);
    }

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }
}

