/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.io.InputStream;
import java.util.List;
import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StructureDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    protected Records.WoodAssets wood;
    private final String structureName;
    private final Vec3i structureSize;

    public StructureDecoration(BlockPos pos, Vec3i direction, WorldGenLevel world, String structureName, Vec3i structureSize) {
        super(pos, direction, world);
        this.structureName = structureName;
        this.structureSize = structureSize;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        if (!this.hasEnoughSpace()) {
            return;
        }
        StructureTemplate template = this.loadStructureTemplate();
        if (template != null) {
            this.placeStructure(template);
        } else {
            this.placeFallbackStructure();
        }
    }

    protected boolean hasEnoughSpace() {
        BlockPos basePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int x = 0; x < this.structureSize.getX(); ++x) {
            for (int z = 0; z < this.structureSize.getZ(); ++z) {
                BlockPos checkPos = basePos.offset(x, 0, z);
                int groundY = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, checkPos.getX(), checkPos.getZ());
                minY = Math.min(minY, groundY);
                maxY = Math.max(maxY, groundY);
            }
        }
        return maxY - minY <= 2;
    }

    protected StructureTemplate loadStructureTemplate() {
        try {
            ResourceLocation structureId = ResourceLocation.fromNamespaceAndPath((String)"roadweaver", (String)("structures/" + this.structureName));
            StructureTemplate template = new StructureTemplate();
            InputStream inputStream = this.getClass().getResourceAsStream("/data/roadweaver/structures/" + this.structureName + ".nbt");
            if (inputStream != null) {
                CompoundTag nbt = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                template.load((HolderGetter)this.getWorld().getLevel().holderLookup(Registries.BLOCK), nbt);
                return template;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load structure: {} using fallback. Error: {}", (Object)this.structureName, (Object)e.getMessage());
        }
        return null;
    }

    protected void placeStructure(StructureTemplate template) {
        BlockPos placePos = this.getPos();
        WorldGenLevel world = this.getWorld();
        BlockPos groundLevel = this.findGroundLevel(placePos, world);
        StructurePlaceSettings placementData = new StructurePlaceSettings().setMirror(Mirror.NONE).setRotation(this.getRotationFromDirection()).setIgnoreEntities(true);
        template.placeInWorld((ServerLevelAccessor)world, groundLevel, groundLevel, placementData, world.getRandom(), 2);
        this.cleanupAirBlocks(template, groundLevel, placementData);
    }

    protected BlockPos findGroundLevel(BlockPos basePos, WorldGenLevel world) {
        int minY = Integer.MAX_VALUE;
        Vec3i size = this.structureSize;
        for (int x = 0; x < size.getX(); ++x) {
            for (int z = 0; z < size.getZ(); ++z) {
                BlockPos checkPos = basePos.offset(x - size.getX() / 2, 0, z - size.getZ() / 2);
                int groundY = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, checkPos.getX(), checkPos.getZ());
                minY = Math.min(minY, groundY);
            }
        }
        return new BlockPos(basePos.getX(), minY - 1, basePos.getZ());
    }

    protected void cleanupAirBlocks(StructureTemplate template, BlockPos basePos, StructurePlaceSettings placementData) {
        List blocks = template.filterBlocks(basePos, placementData, Blocks.AIR);
        for (StructureTemplate.StructureBlockInfo blockInfo : blocks) {
            BlockPos airPos = blockInfo.pos();
            BlockState currentState = this.getWorld().getBlockState(airPos);
            if (!this.shouldReplaceWithAir(currentState)) continue;
            this.getWorld().setBlock(airPos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    protected boolean shouldReplaceWithAir(BlockState state) {
        return state.getBlock().equals(Blocks.SHORT_GRASS) || state.getBlock().equals(Blocks.TALL_GRASS) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.SAPLINGS) || state.is(BlockTags.LEAVES);
    }

    protected Rotation getRotationFromDirection() {
        Vec3i roadDirection = this.getRoadDirection();
        if (Math.abs(roadDirection.getX()) > Math.abs(roadDirection.getZ())) {
            return roadDirection.getX() > 0 ? Rotation.NONE : Rotation.CLOCKWISE_180;
        }
        return roadDirection.getZ() > 0 ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
    }

    protected Vec3i getRoadDirection() {
        Vec3i orthogonal = this.getOrthogonalVector();
        return new Vec3i(-orthogonal.getZ(), 0, orthogonal.getX());
    }

    protected abstract void placeFallbackStructure();

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }

    public Vec3i getStructureSize() {
        return this.structureSize;
    }
}

