/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.HashMap;
import java.util.Map;
import net.countered.settlementroads.client.gui.MapRenderer;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.RoadDebugScreen;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class GridRenderer {
    private static final int TARGET_GRID_PX = 80;
    private final Map<Integer, String> gridLabelCache = new HashMap<Integer, String>();

    public void drawGrid(class_332 ctx, MapRenderer.LODLevel lod, int width, int height, int padding, double baseScale, double zoom, double offsetX, double offsetY, int minX, int minZ, RoadDebugScreen.ScreenBounds bounds) {
        String label;
        if (lod == MapRenderer.LODLevel.MINIMAL) {
            return;
        }
        int w = width - padding * 2;
        int h = height - padding * 2;
        double worldX0 = (double)minX + -offsetX / (baseScale * zoom);
        double worldZ0 = (double)minZ + -offsetY / (baseScale * zoom);
        double worldX1 = (double)minX + ((double)w - offsetX) / (baseScale * zoom);
        double worldZ1 = (double)minZ + ((double)h - offsetY) / (baseScale * zoom);
        int spacing = this.computeGridSpacing(baseScale, zoom);
        int startWX = (int)Math.floor(worldX0 / (double)spacing) * spacing;
        int startWZ = (int)Math.floor(worldZ0 / (double)spacing) * spacing;
        int maxGridLines = switch (lod) {
            default -> throw new MatchException(null, null);
            case MapRenderer.LODLevel.HIGH -> 100;
            case MapRenderer.LODLevel.MEDIUM -> 50;
            case MapRenderer.LODLevel.LOW -> 25;
            case MapRenderer.LODLevel.MINIMAL -> 0;
        };
        boolean showLabels = lod == MapRenderer.LODLevel.HIGH || lod == MapRenderer.LODLevel.MEDIUM;
        int gridLineCount = 0;
        int x = startWX;
        while ((double)x <= worldX1 && gridLineCount < maxGridLines) {
            int sx = padding + (int)(((double)x - worldX0) * baseScale * zoom);
            if (sx >= bounds.left() && sx <= bounds.right()) {
                RenderUtils.fillV(ctx, sx, bounds.top(), bounds.bottom(), 0x40444444);
                if (showLabels) {
                    label = this.gridLabelCache.computeIfAbsent(x, String::valueOf);
                    RenderUtils.drawSmallLabel(ctx, label, sx + 2, bounds.top() + 2);
                }
                ++gridLineCount;
            }
            x += spacing;
        }
        gridLineCount = 0;
        int z = startWZ;
        while ((double)z <= worldZ1 && gridLineCount < maxGridLines) {
            int sz = padding + (int)(((double)z - worldZ0) * baseScale * zoom);
            if (sz >= bounds.top() && sz <= bounds.bottom()) {
                RenderUtils.fillH(ctx, bounds.left(), bounds.right(), sz, 0x40444444);
                if (showLabels) {
                    label = this.gridLabelCache.computeIfAbsent(z, String::valueOf);
                    RenderUtils.drawSmallLabel(ctx, label, bounds.left() + 2, sz + 2);
                }
                ++gridLineCount;
            }
            z += spacing;
        }
        this.drawGridScaleIndicator(ctx, width, height, spacing);
    }

    private void drawGridScaleIndicator(class_332 ctx, int width, int height, int spacing) {
        class_327 font = class_310.method_1551().field_1772;
        String scaleText = class_2561.method_43469((String)"gui.roadweaver.debug_map.blocks", (Object[])new Object[]{spacing}).getString();
        int textWidth = font.method_1727(scaleText);
        int x = width - textWidth - 10;
        int y = height - 20;
        RenderUtils.drawPanel(ctx, x - 4, y - 2, x + textWidth + 4, y + 10, -1073741824, -12303292);
        ctx.method_51433(font, scaleText, x, y, -1, false);
    }

    private int computeGridSpacing(double baseScale, double zoom) {
        int[] spacings;
        double worldPerPixel = 1.0 / (baseScale * zoom);
        double worldPerGrid = worldPerPixel * 80.0;
        for (int spacing : spacings = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000}) {
            if (!((double)spacing >= worldPerGrid * 0.8)) continue;
            return spacing;
        }
        return 10000;
    }
}

