/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.countered.settlementroads.client.gui.ClothConfigScreen;
import net.countered.settlementroads.client.gui.GridRenderer;
import net.countered.settlementroads.client.gui.MapRenderer;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.StructureColorManager;
import net.countered.settlementroads.client.gui.UIRenderer;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_1132;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class RoadDebugScreen
extends class_437 {
    private static final int PADDING = 20;
    private final List<Records.StructureInfo> structureInfos;
    private final List<Records.StructureConnection> connections;
    private final List<Records.RoadData> roads;
    private final StructureColorManager colorManager;
    private final Map<String, Integer> statusColors = Map.of("structure", -14176672, "planned", -865972, "generating", -1671646, "completed", -14176672, "failed", -1618884, "road", -13330213);
    private boolean dragging = false;
    private boolean firstLayout = true;
    private boolean layoutDirty = true;
    private double zoom = 3.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double baseScale = 1.0;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private double lastZoom = 1.0;
    private double lastOffsetX = 0.0;
    private double lastOffsetY = 0.0;
    private class_2338 hoveredStructure = null;
    private String hoveredStructureId = null;
    private boolean manualMode = false;
    private class_2338 manualFirst = null;
    private String toastMessage = null;
    private long toastExpireMs = 0L;
    private double mouseDownX = 0.0;
    private double mouseDownY = 0.0;
    private boolean hasDragged = false;
    private class_2338 pendingTeleport = null;
    private long teleportConfirmExpireMs = 0L;
    private final MapRenderer mapRenderer;
    private final GridRenderer gridRenderer;
    private final UIRenderer uiRenderer;
    private final ScreenBounds bounds;
    private class_4185 manualButton;
    private class_4185 configButton;
    private class_4185 refreshButton;

    public RoadDebugScreen(List<Records.StructureInfo> structureInfos, List<Records.StructureConnection> connections, List<Records.RoadData> roads) {
        super((class_2561)class_2561.method_43471((String)"gui.roadweaver.debug_map.title"));
        this.structureInfos = structureInfos != null ? new ArrayList<Records.StructureInfo>(structureInfos) : new ArrayList();
        this.connections = connections != null ? new ArrayList<Records.StructureConnection>(connections) : new ArrayList();
        this.roads = roads != null ? new ArrayList<Records.RoadData>(roads) : new ArrayList();
        this.colorManager = new StructureColorManager();
        if (!this.structureInfos.isEmpty()) {
            this.minX = this.structureInfos.stream().mapToInt(info -> info.pos().method_10263()).min().orElse(0);
            this.maxX = this.structureInfos.stream().mapToInt(info -> info.pos().method_10263()).max().orElse(0);
            this.minZ = this.structureInfos.stream().mapToInt(info -> info.pos().method_10260()).min().orElse(0);
            this.maxZ = this.structureInfos.stream().mapToInt(info -> info.pos().method_10260()).max().orElse(0);
        }
        this.bounds = new ScreenBounds();
        this.mapRenderer = new MapRenderer(this.statusColors, this.bounds, this.colorManager);
        this.gridRenderer = new GridRenderer();
        this.uiRenderer = new UIRenderer(this.statusColors, this.colorManager);
    }

    protected void method_25426() {
        super.method_25426();
        int configButtonW = 50;
        int configButtonH = 16;
        int configButtonX = this.field_22789 - configButtonW - 8;
        int configButtonY = 8;
        this.configButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.config"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(ClothConfigScreen.createConfigScreen(this));
            }
        }).method_46434(configButtonX, configButtonY, configButtonW, configButtonH).method_46431();
        this.method_37063((class_364)this.configButton);
        int refreshButtonW = 50;
        int refreshButtonH = 16;
        int refreshButtonX = configButtonX - refreshButtonW - 4;
        int refreshButtonY = 8;
        this.refreshButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.roadweaver.debug_map.refresh"), button -> this.refreshData()).method_46434(refreshButtonX, refreshButtonY, refreshButtonW, refreshButtonH).method_46431();
        this.method_37063((class_364)this.refreshButton);
        int buttonW = 110;
        int buttonH = 16;
        int buttonX = 8;
        int buttonY = this.field_22790 - buttonH - 8;
        this.manualButton = class_4185.method_46430((class_2561)this.getManualModeLabel(), b -> this.toggleManualMode()).method_46434(buttonX, buttonY, buttonW, buttonH).method_46431();
        this.method_37063((class_364)this.manualButton);
    }

    private class_2561 getManualModeLabel() {
        class_5250 state = class_2561.method_43471((String)(this.manualMode ? "gui.roadweaver.common.on" : "gui.roadweaver.common.off"));
        return class_2561.method_43469((String)"gui.roadweaver.debug_map.manual_mode", (Object[])new Object[]{state});
    }

    private void toggleManualMode() {
        this.manualMode = !this.manualMode;
        this.manualFirst = null;
        if (this.manualButton != null) {
            this.manualButton.method_25355(this.getManualModeLabel());
        }
        String msg = class_2561.method_43471((String)(this.manualMode ? "toast.roadweaver.manual_mode_on" : "toast.roadweaver.manual_mode_off")).getString();
        this.toast(msg, 2000L);
    }

    private void refreshData() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1576() == null) {
            return;
        }
        class_3218 world = mc.method_1576().method_30002();
        if (world == null) {
            return;
        }
        try {
            Records.StructureLocationData data = WorldDataProvider.getInstance().getStructureLocations(world);
            List<Records.StructureConnection> newConnections = WorldDataProvider.getInstance().getStructureConnections(world);
            List<Records.RoadData> newRoads = WorldDataProvider.getInstance().getRoadDataList(world);
            int failedCount = 0;
            if (newConnections != null) {
                ArrayList<Records.StructureConnection> filteredConnections = new ArrayList<Records.StructureConnection>();
                for (Records.StructureConnection conn : newConnections) {
                    if (conn.status() == Records.ConnectionStatus.FAILED) {
                        ++failedCount;
                        continue;
                    }
                    filteredConnections.add(conn);
                }
                if (failedCount > 0) {
                    WorldDataProvider.getInstance().setStructureConnections(world, filteredConnections);
                    newConnections = filteredConnections;
                }
            }
            this.structureInfos.clear();
            if (data != null && data.structureInfos() != null) {
                this.structureInfos.addAll(data.structureInfos());
            }
            this.connections.clear();
            if (newConnections != null) {
                this.connections.addAll(newConnections);
            }
            this.roads.clear();
            if (newRoads != null) {
                this.roads.addAll(newRoads);
            }
            if (!this.structureInfos.isEmpty()) {
                this.minX = this.structureInfos.stream().mapToInt(info -> info.pos().method_10263()).min().orElse(0);
                this.maxX = this.structureInfos.stream().mapToInt(info -> info.pos().method_10263()).max().orElse(0);
                this.minZ = this.structureInfos.stream().mapToInt(info -> info.pos().method_10260()).min().orElse(0);
                this.maxZ = this.structureInfos.stream().mapToInt(info -> info.pos().method_10260()).max().orElse(0);
            }
            this.layoutDirty = true;
            Object message = class_2561.method_43471((String)"gui.roadweaver.debug_map.refreshed").getString();
            if (failedCount > 0) {
                message = (String)message + " (" + class_2561.method_43469((String)"gui.roadweaver.debug_map.removed_failed", (Object[])new Object[]{failedCount}).getString() + ")";
            }
            this.toast((String)message, 2000L);
        }
        catch (Exception e) {
            this.toast("Refresh failed: " + e.getMessage(), 2000L);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    private void computeLayout() {
        if (this.structureInfos.isEmpty()) {
            this.baseScale = 1.0;
            return;
        }
        int w = this.field_22789 - 40;
        int h = this.field_22790 - 40;
        if (w <= 0 || h <= 0) {
            return;
        }
        int worldW = Math.max(1, this.maxX - this.minX);
        int worldH = Math.max(1, this.maxZ - this.minZ);
        double scaleX = (double)w / (double)worldW;
        double scaleY = (double)h / (double)worldH;
        this.baseScale = Math.min(scaleX, scaleY) * 0.8;
        if (this.firstLayout) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                double playerX = mc.field_1724.method_23317();
                double playerZ = mc.field_1724.method_23321();
                double playerScreenX = (playerX - (double)this.minX) * this.baseScale * this.zoom;
                double playerScreenZ = (playerZ - (double)this.minZ) * this.baseScale * this.zoom;
                this.offsetX = (double)w / 2.0 - playerScreenX;
                this.offsetY = (double)h / 2.0 - playerScreenZ;
            } else {
                this.offsetX = ((double)w - (double)worldW * this.baseScale * this.zoom) / 2.0;
                this.offsetY = ((double)h - (double)worldH * this.baseScale * this.zoom) / 2.0;
            }
            this.firstLayout = false;
        }
        this.layoutDirty = false;
    }

    private void updateUIBounds() {
        this.bounds.update(20, this.field_22789 - 20, 20, this.field_22790 - 20);
    }

    private ScreenPos worldToScreen(double worldX, double worldZ) {
        int x = 20 + (int)((worldX - (double)this.minX) * this.baseScale * this.zoom + this.offsetX);
        int y = 20 + (int)((worldZ - (double)this.minZ) * this.baseScale * this.zoom + this.offsetY);
        return new ScreenPos(x, y);
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.layoutDirty || this.lastWidth != this.field_22789 || this.lastHeight != this.field_22790 || this.lastZoom != this.zoom || this.lastOffsetX != this.offsetX || this.lastOffsetY != this.offsetY) {
            this.computeLayout();
            this.updateUIBounds();
            this.lastWidth = this.field_22789;
            this.lastHeight = this.field_22790;
            this.lastZoom = this.zoom;
            this.lastOffsetX = this.offsetX;
            this.lastOffsetY = this.offsetY;
            this.layoutDirty = false;
        }
        ctx.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        MapRenderer.LODLevel lod = this.mapRenderer.getLODLevel(this.zoom);
        MapRenderer.WorldToScreenConverter converter = this::worldToScreen;
        if (lod != MapRenderer.LODLevel.MINIMAL) {
            this.gridRenderer.drawGrid(ctx, lod, this.field_22789, this.field_22790, 20, this.baseScale, this.zoom, this.offsetX, this.offsetY, this.minX, this.minZ, this.bounds);
        }
        this.mapRenderer.drawRoadPaths(ctx, this.roads, lod, this.baseScale, this.zoom, converter);
        this.mapRenderer.drawConnections(ctx, this.connections, this.roads, lod, converter);
        this.mapRenderer.drawStructures(ctx, this.structureInfos, this.hoveredStructure, this.manualFirst, lod, converter);
        this.mapRenderer.drawPlayerMarker(ctx, lod, this.zoom, converter);
        List<Records.StructureInfo> visibleStructures = this.getVisibleStructures(converter);
        this.uiRenderer.drawTitle(ctx, this.field_22789);
        this.uiRenderer.drawStatsPanel(ctx, this.field_22789, this.structureInfos, this.connections, this.roads, this.zoom, this.baseScale);
        this.uiRenderer.drawLegendPanel(ctx, this.field_22790, visibleStructures);
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        super.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_51448().method_22909();
        if (this.hoveredStructure != null && this.hoveredStructureId != null) {
            this.uiRenderer.drawTooltip(ctx, this.hoveredStructure, this.hoveredStructureId, mouseX, mouseY, this.field_22789);
        }
        this.updateHoveredStructure(mouseX, mouseY);
        if (this.toastMessage != null && System.currentTimeMillis() < this.toastExpireMs) {
            this.drawToast(ctx, this.toastMessage);
        }
    }

    private void drawToast(class_332 ctx, String message) {
        class_327 font = class_310.method_1551().field_1772;
        int tw = font.method_1727(message);
        int x = 10;
        int y = 10;
        RenderUtils.drawPanel(ctx, x - 4, y - 4, x + tw + 6, y + 12, -1073741824, -10066330);
        ctx.method_51433(font, message, x, y, -1, false);
    }

    private void toast(String msg, long durationMs) {
        this.toastMessage = msg;
        this.toastExpireMs = System.currentTimeMillis() + durationMs;
    }

    public boolean method_25422() {
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.field_22787.field_1690.field_1839 != null) {
            for (class_304 keyMapping : this.field_22787.field_1690.field_1839) {
                if (!keyMapping.method_1431().equals("key.roadweaver.debug_map") || !keyMapping.method_1417(keyCode, scanCode)) continue;
                this.method_25419();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.dragging && button == 0) {
            double totalDrag = Math.abs(mouseX - this.mouseDownX) + Math.abs(mouseY - this.mouseDownY);
            if (totalDrag > 3.0) {
                this.hasDragged = true;
            }
            this.offsetX += dragX;
            this.offsetY += dragY;
            this.layoutDirty = true;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double old = this.zoom;
        this.zoom = verticalAmount > 0.0 ? this.zoom * 1.1 : this.zoom / 1.1;
        this.zoom = Math.max(0.1, Math.min(10.0, this.zoom));
        this.offsetX = (this.offsetX - mouseX + 20.0) * (this.zoom / old) + mouseX - 20.0;
        this.offsetY = (this.offsetY - mouseY + 20.0) * (this.zoom / old) + mouseY - 20.0;
        this.layoutDirty = true;
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        this.mouseDownX = mouseX;
        this.mouseDownY = mouseY;
        this.hasDragged = false;
        this.dragging = true;
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.dragging) {
            Records.StructureInfo clickedInfo;
            this.dragging = false;
            if (!this.hasDragged && (clickedInfo = this.findClickedStructure(mouseX, mouseY)) != null) {
                class_2338 clicked = clickedInfo.pos();
                if (this.manualMode) {
                    this.handleManualClick(clicked);
                } else if (this.pendingTeleport != null && this.pendingTeleport.equals((Object)clicked) && System.currentTimeMillis() < this.teleportConfirmExpireMs) {
                    this.teleportTo(clicked);
                    this.pendingTeleport = null;
                } else {
                    this.pendingTeleport = clicked;
                    this.teleportConfirmExpireMs = System.currentTimeMillis() + 3000L;
                    String confirm = class_2561.method_43469((String)"toast.roadweaver.teleport_confirm", (Object[])new Object[]{clicked.method_10263(), clicked.method_10260()}).getString();
                    this.toast(confirm, 3000L);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private void updateHoveredStructure(int mouseX, int mouseY) {
        Records.StructureInfo info = this.findClickedStructure(mouseX, mouseY);
        if (info != null) {
            this.hoveredStructure = info.pos();
            this.hoveredStructureId = info.structureId();
        } else {
            this.hoveredStructure = null;
            this.hoveredStructureId = null;
        }
    }

    private Records.StructureInfo findClickedStructure(double mouseX, double mouseY) {
        for (Records.StructureInfo info : this.structureInfos) {
            class_2338 structure = info.pos();
            ScreenPos pos = this.worldToScreen(structure.method_10263(), structure.method_10260());
            double dx = (double)pos.x - mouseX;
            double dy = (double)pos.y - mouseY;
            if (!(Math.sqrt(dx * dx + dy * dy) <= 7.0)) continue;
            return info;
        }
        return null;
    }

    private void handleManualClick(class_2338 clicked) {
        if (this.manualFirst == null) {
            this.manualFirst = clicked;
            String pick = class_2561.method_43469((String)"toast.roadweaver.manual_pick_start", (Object[])new Object[]{clicked.method_10263(), clicked.method_10260()}).getString();
            this.toast(pick, 2000L);
        } else if (this.manualFirst.equals((Object)clicked)) {
            this.manualFirst = null;
            String cancel = class_2561.method_43471((String)"toast.roadweaver.manual_cancelled").getString();
            this.toast(cancel, 2000L);
        } else {
            class_2338 first = this.manualFirst;
            this.manualFirst = null;
            this.createManualConnection(first, clicked);
        }
    }

    private void createManualConnection(class_2338 from, class_2338 to) {
        class_310 client = class_310.method_1551();
        class_1132 server = client.method_1576();
        if (server == null) {
            this.toast(class_2561.method_43471((String)"toast.roadweaver.manual_multiplayer_not_supported").getString(), 2500L);
            return;
        }
        Records.StructureConnection newConn = new Records.StructureConnection(from, to, Records.ConnectionStatus.PLANNED, true);
        server.execute(() -> RoadDebugScreen.lambda$createManualConnection$12((MinecraftServer)server, from, to, newConn));
        this.connections.removeIf(conn -> (conn.from().equals((Object)from) && conn.to().equals((Object)to) || conn.from().equals((Object)to) && conn.to().equals((Object)from)) && conn.status() == Records.ConnectionStatus.FAILED);
        this.connections.add(newConn);
        this.toast(class_2561.method_43471((String)"toast.roadweaver.manual_created").getString(), 2000L);
    }

    private void teleportTo(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.method_1576() == null) {
            return;
        }
        class_1132 server = mc.method_1576();
        String command = "/tp " + mc.field_1724.method_5477().getString() + " " + pos.method_10263() + " ~ " + pos.method_10260();
        server.method_3734().method_44252(server.method_3739(), command);
    }

    public boolean method_25421() {
        return false;
    }

    private List<Records.StructureInfo> getVisibleStructures(MapRenderer.WorldToScreenConverter converter) {
        ArrayList<Records.StructureInfo> visible = new ArrayList<Records.StructureInfo>();
        for (Records.StructureInfo info : this.structureInfos) {
            class_2338 pos = info.pos();
            ScreenPos screenPos = converter.worldToScreen(pos.method_10263(), pos.method_10260());
            if (screenPos.x < -50 || screenPos.x > this.field_22789 + 50 || screenPos.y < -50 || screenPos.y > this.field_22790 + 50) continue;
            visible.add(info);
        }
        return visible;
    }

    private static /* synthetic */ void lambda$createManualConnection$12(MinecraftServer server, class_2338 from, class_2338 to, Records.StructureConnection newConn) {
        class_3218 world = server.method_30002();
        WorldDataProvider provider = WorldDataProvider.getInstance();
        ArrayList<Records.StructureConnection> list = new ArrayList<Records.StructureConnection>(Optional.ofNullable(provider.getStructureConnections(world)).orElseGet(ArrayList::new));
        list.removeIf(conn -> (conn.from().equals((Object)from) && conn.to().equals((Object)to) || conn.from().equals((Object)to) && conn.to().equals((Object)from)) && conn.status() == Records.ConnectionStatus.FAILED);
        list.add(newConn);
        provider.setStructureConnections(world, list);
        StructureConnector.getQueueForWorld(world).add(newConn);
    }

    public static class ScreenBounds {
        private int left;
        private int right;
        private int top;
        private int bottom;

        public void update(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isInBounds(int x, int y, int margin) {
            return x >= this.left - margin && x <= this.right + margin && y >= this.top - margin && y <= this.bottom + margin;
        }

        public boolean isLineInBounds(int x1, int y1, int x2, int y2) {
            return !(x1 < this.left && x2 < this.left || x1 > this.right && x2 > this.right || y1 < this.top && y2 < this.top) && (y1 <= this.bottom || y2 <= this.bottom);
        }

        public int left() {
            return this.left;
        }

        public int right() {
            return this.right;
        }

        public int top() {
            return this.top;
        }

        public int bottom() {
            return this.bottom;
        }
    }

    public record ScreenPos(int x, int y) {
    }
}

