/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.client.gui;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.countered.settlementroads.client.gui.RenderUtils;
import net.countered.settlementroads.client.gui.StructureColorManager;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class UIRenderer {
    private static final int PADDING = 20;
    private final Map<String, Integer> statusColors;
    private final StructureColorManager colorManager;

    public UIRenderer(Map<String, Integer> statusColors, StructureColorManager colorManager) {
        this.statusColors = statusColors;
        this.colorManager = colorManager;
    }

    public void drawTitle(class_332 ctx, int width) {
        class_327 font = class_310.method_1551().field_1772;
        String title = class_2561.method_43471((String)"gui.roadweaver.debug_map.title").getString();
        int tw = font.method_1727(title);
        int x = (width - tw) / 2;
        int y = 28;
        RenderUtils.drawPanel(ctx, x - 10, y - 5, x + tw + 10, y + 14, -1073741824, -11890462);
        ctx.method_51433(font, title, x, y, -1, true);
    }

    public void drawStatsPanel(class_332 ctx, int width, List<Records.StructureInfo> structureInfos, List<Records.StructureConnection> connections, List<Records.RoadData> roads, double zoom, double baseScale) {
        class_327 font = class_310.method_1551().field_1772;
        int planned = 0;
        int generating = 0;
        int completed = 0;
        int failed = 0;
        for (Records.StructureConnection structureConnection : connections) {
            switch (structureConnection.status()) {
                case PLANNED: {
                    ++planned;
                    break;
                }
                case GENERATING: {
                    ++generating;
                    break;
                }
                case COMPLETED: {
                    ++completed;
                    break;
                }
                case FAILED: {
                    ++failed;
                }
            }
        }
        int validRoads = 0;
        for (Records.RoadData road : roads) {
            if (road.roadSegmentList() == null || road.roadSegmentList().size() < 2) continue;
            ++validRoads;
        }
        String[] stringArray = new String[]{class_2561.method_43469((String)"gui.roadweaver.debug_map.structures", (Object[])new Object[]{structureInfos.size()}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.planned", (Object[])new Object[]{planned}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.generating", (Object[])new Object[]{generating}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.completed", (Object[])new Object[]{completed}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.failed", (Object[])new Object[]{failed}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.roads", (Object[])new Object[]{roads.size()}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.valid", (Object[])new Object[]{validRoads}).getString(), class_2561.method_43469((String)"gui.roadweaver.debug_map.zoom", (Object[])new Object[]{String.format("%.1f", zoom)}).getString()};
        int[] colors = new int[]{this.statusColors.get("structure"), this.statusColors.get("planned"), this.statusColors.get("generating"), this.statusColors.get("completed"), this.statusColors.get("failed"), this.statusColors.get("road"), -16711936, -1};
        int maxWidth = 0;
        for (String label : stringArray) {
            maxWidth = Math.max(maxWidth, font.method_1727(label));
        }
        int panelX = width - maxWidth - 20 - 20;
        int panelY = 60;
        int panelW = maxWidth + 16;
        int panelH = stringArray.length * 12 + 8;
        RenderUtils.drawPanel(ctx, panelX, panelY, panelX + panelW, panelY + panelH, -536870912, -13877680);
        for (int i = 0; i < stringArray.length; ++i) {
            int textY = panelY + 8 + i * 12;
            ctx.method_51433(font, stringArray[i], panelX + 8, textY, colors[i], false);
        }
    }

    public void drawLegendPanel(class_332 ctx, int height, List<Records.StructureInfo> visibleStructureInfos) {
        class_327 font = class_310.method_1551().field_1772;
        LinkedHashMap<String, Integer> visibleStructureColors = new LinkedHashMap<String, Integer>();
        for (Records.StructureInfo info : visibleStructureInfos) {
            String structureId = info.structureId();
            if (visibleStructureColors.containsKey(structureId)) continue;
            visibleStructureColors.put(structureId, this.colorManager.getColorForStructure(structureId));
        }
        String[] fixedLabels = new String[]{class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.planned").getString(), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.generating").getString(), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.failed").getString(), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.roads").getString(), class_2561.method_43471((String)"gui.roadweaver.debug_map.legend.player").getString()};
        int[] fixedColors = new int[]{this.statusColors.get("planned"), this.statusColors.get("generating"), this.statusColors.get("failed"), this.statusColors.get("road"), -1618884};
        int maxWidth = 0;
        for (String label : fixedLabels) {
            maxWidth = Math.max(maxWidth, font.method_1727(label));
        }
        for (String structureId : visibleStructureColors.keySet()) {
            String displayName = this.colorManager.getDisplayName(structureId);
            maxWidth = Math.max(maxWidth, font.method_1727(displayName));
        }
        int totalItems = fixedLabels.length + visibleStructureColors.size();
        int panelX = 20;
        int panelY = height - totalItems * 12 - 20 - 16;
        int panelW = maxWidth + 32;
        int panelH = totalItems * 12 + 8;
        RenderUtils.drawPanel(ctx, panelX, panelY, panelX + panelW, panelY + panelH, -536870912, -13350562);
        int currentY = panelY + 8;
        for (Map.Entry entry : visibleStructureColors.entrySet()) {
            String displayName = this.colorManager.getDisplayName((String)entry.getKey());
            int color = (Integer)entry.getValue();
            RenderUtils.fillCircle(ctx, panelX + 12, currentY + 4, 3, color);
            ctx.method_51433(font, displayName, panelX + 24, currentY, -1, false);
            currentY += 12;
        }
        for (int i = 0; i < fixedLabels.length; ++i) {
            RenderUtils.fillCircle(ctx, panelX + 12, currentY + 4, 3, fixedColors[i]);
            ctx.method_51433(font, fixedLabels[i], panelX + 24, currentY, -1, false);
            currentY += 12;
        }
    }

    public void drawTooltip(class_332 ctx, class_2338 structure, String structureId, int mouseX, int mouseY, int width) {
        class_327 font = class_310.method_1551().field_1772;
        String displayName = this.colorManager.getDisplayName(structureId);
        String posText = class_2561.method_43471((String)"gui.roadweaver.debug_map.position").getString() + ": " + structure.method_10263() + ", " + structure.method_10260();
        int nameWidth = font.method_1727(displayName);
        int posWidth = font.method_1727(posText);
        int tooltipWidth = Math.max(nameWidth, posWidth) + 8;
        int tooltipHeight = 28;
        int x = mouseX + 10;
        int y = mouseY - 35;
        if (x + tooltipWidth > width) {
            x = mouseX - tooltipWidth - 10;
        }
        if (y < 0) {
            y = mouseY + 10;
        }
        int structureColor = this.colorManager.getColorForStructure(structureId);
        RenderUtils.drawPanel(ctx, x, y, x + tooltipWidth, y + tooltipHeight, -268435456, structureColor);
        ctx.method_51433(font, displayName, x + 4, y + 5, -1, true);
        ctx.method_51433(font, posText, x + 4, y + 16, -5592406, false);
    }
}

