/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.config.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class FabricModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("roadweaver.json");
    private static ConfigData data = new ConfigData();

    public static List<String> getStructuresToLocate() {
        return FabricModConfig.data.structuresToLocate;
    }

    public static void setStructuresToLocate(List<String> value) {
        FabricModConfig.data.structuresToLocate = value != null ? value : new ArrayList();
    }

    public static int getStructureSearchRadius() {
        return FabricModConfig.data.structureSearchRadius;
    }

    public static void setStructureSearchRadius(int value) {
        FabricModConfig.data.structureSearchRadius = value;
    }

    public static int getInitialLocatingCount() {
        return FabricModConfig.data.initialLocatingCount;
    }

    public static void setInitialLocatingCount(int value) {
        FabricModConfig.data.initialLocatingCount = value;
    }

    public static int getMaxConcurrentRoadGeneration() {
        return FabricModConfig.data.maxConcurrentRoadGeneration;
    }

    public static void setMaxConcurrentRoadGeneration(int value) {
        FabricModConfig.data.maxConcurrentRoadGeneration = value;
    }

    public static int getStructureSearchTriggerDistance() {
        return FabricModConfig.data.structureSearchTriggerDistance;
    }

    public static void setStructureSearchTriggerDistance(int value) {
        FabricModConfig.data.structureSearchTriggerDistance = Math.max(150, Math.min(1500, value));
    }

    public static int getAveragingRadius() {
        return FabricModConfig.data.averagingRadius;
    }

    public static void setAveragingRadius(int value) {
        FabricModConfig.data.averagingRadius = value;
    }

    public static boolean getAllowArtificial() {
        return FabricModConfig.data.allowArtificial;
    }

    public static void setAllowArtificial(boolean value) {
        FabricModConfig.data.allowArtificial = value;
    }

    public static boolean getAllowNatural() {
        return FabricModConfig.data.allowNatural;
    }

    public static void setAllowNatural(boolean value) {
        FabricModConfig.data.allowNatural = value;
    }

    public static int getStructureDistanceFromRoad() {
        return FabricModConfig.data.structureDistanceFromRoad;
    }

    public static void setStructureDistanceFromRoad(int value) {
        FabricModConfig.data.structureDistanceFromRoad = value;
    }

    public static int getMaxHeightDifference() {
        return FabricModConfig.data.maxHeightDifference;
    }

    public static void setMaxHeightDifference(int value) {
        FabricModConfig.data.maxHeightDifference = value;
    }

    public static int getMaxTerrainStability() {
        return FabricModConfig.data.maxTerrainStability;
    }

    public static void setMaxTerrainStability(int value) {
        FabricModConfig.data.maxTerrainStability = value;
    }

    public static boolean getPlaceWaypoints() {
        return FabricModConfig.data.placeWaypoints;
    }

    public static void setPlaceWaypoints(boolean value) {
        FabricModConfig.data.placeWaypoints = value;
    }

    public static boolean getPlaceRoadFences() {
        return FabricModConfig.data.placeRoadFences;
    }

    public static void setPlaceRoadFences(boolean value) {
        FabricModConfig.data.placeRoadFences = value;
    }

    public static boolean getPlaceSwings() {
        return FabricModConfig.data.placeSwings;
    }

    public static void setPlaceSwings(boolean value) {
        FabricModConfig.data.placeSwings = value;
    }

    public static boolean getPlaceBenches() {
        return FabricModConfig.data.placeBenches;
    }

    public static void setPlaceBenches(boolean value) {
        FabricModConfig.data.placeBenches = value;
    }

    public static boolean getPlaceGloriettes() {
        return FabricModConfig.data.placeGloriettes;
    }

    public static void setPlaceGloriettes(boolean value) {
        FabricModConfig.data.placeGloriettes = value;
    }

    public static int getManualMaxHeightDifference() {
        return FabricModConfig.data.manualMaxHeightDifference;
    }

    public static void setManualMaxHeightDifference(int value) {
        FabricModConfig.data.manualMaxHeightDifference = value;
    }

    public static int getManualMaxTerrainStability() {
        return FabricModConfig.data.manualMaxTerrainStability;
    }

    public static void setManualMaxTerrainStability(int value) {
        FabricModConfig.data.manualMaxTerrainStability = value;
    }

    public static boolean getManualIgnoreWater() {
        return FabricModConfig.data.manualIgnoreWater;
    }

    public static void setManualIgnoreWater(boolean value) {
        FabricModConfig.data.manualIgnoreWater = value;
    }

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                data = (ConfigData)GSON.fromJson(json, ConfigData.class);
                if ((FabricModConfig.data.structuresToLocate == null || FabricModConfig.data.structuresToLocate.isEmpty()) && FabricModConfig.data.structureToLocate != null && !FabricModConfig.data.structureToLocate.isBlank()) {
                    FabricModConfig.data.structuresToLocate = FabricModConfig.tokenizeToList(FabricModConfig.data.structureToLocate);
                    FabricModConfig.data.structureToLocate = null;
                    FabricModConfig.save();
                }
                if (FabricModConfig.data.structureSearchTriggerDistance < 150 || FabricModConfig.data.structureSearchTriggerDistance > 1500) {
                    FabricModConfig.data.structureSearchTriggerDistance = 500;
                    FabricModConfig.save();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (FabricModConfig.data.structuresToLocate == null || FabricModConfig.data.structuresToLocate.isEmpty()) {
                FabricModConfig.data.structuresToLocate = new ArrayList<String>(List.of("#minecraft:village"));
            }
            FabricModConfig.save();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> tokenizeToList(String raw) {
        ArrayList<String> list = new ArrayList<String>();
        if (raw == null) {
            return list;
        }
        String normalized = raw.replace('\r', '\n');
        List<String> lines = Arrays.asList(normalized.split("\n"));
        for (String line : lines) {
            String[] tokens;
            String trimmed;
            if (line == null || (trimmed = line.trim()).isEmpty()) continue;
            for (String t : tokens = trimmed.split("[;,\\s]+")) {
                String token;
                if (t == null || (token = t.trim()).isEmpty()) continue;
                list.add(token);
            }
        }
        return list;
    }

    private static class ConfigData {
        String structureToLocate = "#minecraft:village";
        List<String> structuresToLocate = new ArrayList<String>(List.of("#minecraft:village"));
        int structureSearchRadius = 100;
        int initialLocatingCount = 7;
        int maxConcurrentRoadGeneration = 3;
        int structureSearchTriggerDistance = 500;
        int averagingRadius = 1;
        boolean allowArtificial = true;
        boolean allowNatural = false;
        int structureDistanceFromRoad = 4;
        int maxHeightDifference = 5;
        int maxTerrainStability = 4;
        boolean placeWaypoints = false;
        boolean placeRoadFences = true;
        boolean placeSwings = false;
        boolean placeBenches = false;
        boolean placeGloriettes = false;
        int manualMaxHeightDifference = 10;
        int manualMaxTerrainStability = 10;
        boolean manualIgnoreWater = false;

        private ConfigData() {
        }
    }
}

