/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.decoration.BenchDecoration;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.GlorietteDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.RoadFenceDecoration;
import net.countered.settlementroads.features.decoration.RoadStructures;
import net.countered.settlementroads.features.decoration.SwingDecoration;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6796;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFeature
extends class_3031<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    public static final Set<class_2248> dontPlaceHere = new HashSet<class_2248>();
    public static int chunksForLocatingCounter;
    public static final class_5321<class_2975<?, ?>> ROAD_FEATURE_KEY;
    public static final class_5321<class_6796> ROAD_FEATURE_PLACED_KEY;
    public static final class_3031<RoadFeatureConfig> ROAD_FEATURE;

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<RoadFeatureConfig> context) {
        if (RoadPathCalculator.heightCache.size() > 100000) {
            RoadPathCalculator.heightCache.clear();
        }
        class_5281 level = context.method_33652();
        class_3218 serverLevel = level.method_8410();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData structureLocationData = dataProvider.getStructureLocations(serverLevel);
        if (structureLocationData == null) {
            return false;
        }
        List<class_2338> villageLocations = structureLocationData.structureLocations();
        if (chunksForLocatingCounter % 50 == 0) {
            LOGGER.info("RoadFeature.place() called, counter: {}, structures: {}", (Object)chunksForLocatingCounter, (Object)villageLocations.size());
        }
        this.tryFindNewStructureConnection(villageLocations, serverLevel);
        HashSet<Decoration> roadDecorationCache = new HashSet<Decoration>();
        this.runRoadLogic(level, context, roadDecorationCache);
        RoadStructures.tryPlaceDecorations(roadDecorationCache);
        return true;
    }

    private void tryFindNewStructureConnection(List<class_2338> villageLocations, class_3218 serverLevel) {
        int triggerDistance = ConfigProvider.get().structureSearchTriggerDistance();
        if (++chunksForLocatingCounter > triggerDistance) {
            LOGGER.info("\ud83d\udd0d Triggering new structure search (counter reached {}), current structures: {}", (Object)triggerDistance, (Object)villageLocations.size());
            serverLevel.method_8503().execute(() -> StructureConnector.cacheNewConnection(serverLevel, true));
            chunksForLocatingCounter = 1;
        }
    }

    private void runRoadLogic(class_5281 level, class_5821<RoadFeatureConfig> context, Set<Decoration> roadDecorationPlacementPositions) {
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        class_3218 serverLevel = level.method_8410();
        int averagingRadius = config.averagingRadius();
        List<Records.RoadData> roadDataList = dataProvider.getRoadDataList(serverLevel);
        if (roadDataList == null) {
            return;
        }
        class_1923 currentChunkPos = new class_1923(context.method_33655());
        HashSet<class_2338> posAlreadyContainsSegment = new HashSet<class_2338>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            List<class_2680> materials = data.materials();
            List<Records.RoadSegmentPlacement> segmentList = data.roadSegmentList();
            List<class_2338> middlePositions = segmentList.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segmentList.size() - 2; ++i) {
                class_1923 middleChunkPos;
                if (posAlreadyContainsSegment.contains(middlePositions.get(i))) continue;
                Records.RoadSegmentPlacement segment = segmentList.get(i);
                class_2338 segmentMiddlePos = segment.middlePos();
                if (++segmentIndex < 60 || segmentIndex > segmentList.size() - 60 || !(middleChunkPos = new class_1923(segmentMiddlePos)).equals((Object)currentChunkPos)) continue;
                class_2338 prevPos = middlePositions.get(i - 2);
                class_2338 nextPos = middlePositions.get(i + 2);
                ArrayList<Double> heights = new ArrayList<Double>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    class_2338 samplePos = middlePositions.get(j);
                    double y = level.method_8624(class_2902.class_2903.field_13194, samplePos.method_10263(), samplePos.method_10260());
                    heights.add(y);
                }
                int averageY = (int)Math.round(heights.stream().mapToDouble(Double::doubleValue).average().orElse(segmentMiddlePos.method_10264()));
                class_2338 averagedPos = new class_2338(segmentMiddlePos.method_10263(), averageY, segmentMiddlePos.method_10260());
                class_5819 random = context.method_33654();
                if (!config.placeWaypoints()) {
                    for (class_2338 widthBlock : segment.positions()) {
                        class_2338 correctedYPos = new class_2338(widthBlock.method_10263(), averageY, widthBlock.method_10260());
                        this.placeOnSurface(level, correctedYPos, materials, roadType, random);
                    }
                }
                this.addDecoration(level, roadDecorationPlacementPositions, averagedPos, segmentIndex, nextPos, prevPos, middlePositions, roadType, random, config);
                posAlreadyContainsSegment.add(segmentMiddlePos);
            }
        }
    }

    private static void tryPlaceDecorations(Set<Decoration> decorations) {
        RoadStructures.tryPlaceDecorations(decorations);
    }

    private void addDecoration(class_5281 level, Set<Decoration> roadDecorationPlacementPositions, class_2338 placePos, int segmentIndex, class_2338 nextPos, class_2338 prevPos, List<class_2338> middleBlockPositions, int roadType, class_5819 random, IModConfig config) {
        boolean isEnd;
        int dz;
        class_2338 surfacePos = placePos.method_33096(level.method_8624(class_2902.class_2903.field_13194, placePos.method_10263(), placePos.method_10260()));
        class_2680 blockStateAtPos = level.method_8320(surfacePos.method_10074());
        if (config.placeWaypoints()) {
            if (segmentIndex % 25 == 0) {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(surfacePos, level));
            }
            return;
        }
        int dx = nextPos.method_10263() - prevPos.method_10263();
        double length = Math.sqrt(dx * dx + (dz = nextPos.method_10260() - prevPos.method_10260()) * dz);
        int normDx = length != 0.0 ? (int)Math.round((double)dx / length) : 0;
        int normDz = length != 0.0 ? (int)Math.round((double)dz / length) : 0;
        class_2382 directionVector = new class_2382(normDx, 0, normDz);
        class_2382 orthogonalVector = new class_2382(-directionVector.method_10260(), 0, directionVector.method_10263());
        boolean bl = isEnd = segmentIndex != middleBlockPositions.size() - 65;
        if (segmentIndex == 65 || segmentIndex == middleBlockPositions.size() - 65) {
            class_2338 shiftedPos = isEnd ? placePos.method_10081(orthogonalVector.method_35862(2)) : placePos.method_10081(orthogonalVector.method_35862(-2));
            roadDecorationPlacementPositions.add(new DistanceSignDecoration(shiftedPos, orthogonalVector, level, isEnd, String.valueOf(middleBlockPositions.size())));
        } else if (segmentIndex % 59 == 0) {
            boolean leftRoadSide = random.method_43056();
            class_2338 shiftedPos = leftRoadSide ? placePos.method_10081(orthogonalVector.method_35862(2)) : placePos.method_10081(orthogonalVector.method_35862(-2));
            if (Math.abs((shiftedPos = shiftedPos.method_33096(level.method_8624(class_2902.class_2903.field_13194, shiftedPos.method_10263(), shiftedPos.method_10260()))).method_10264() - placePos.method_10264()) > 1) {
                return;
            }
            if (roadType == 0) {
                roadDecorationPlacementPositions.add(new LamppostDecoration(shiftedPos, orthogonalVector, level, leftRoadSide));
            } else {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(shiftedPos, level));
            }
        } else if (config.placeRoadFences() && segmentIndex % 15 == 0) {
            boolean leftRoadSide = random.method_43056();
            class_2338 shiftedPos = leftRoadSide ? placePos.method_10081(orthogonalVector.method_35862(2)) : placePos.method_10081(orthogonalVector.method_35862(-2));
            if (Math.abs((shiftedPos = shiftedPos.method_33096(level.method_8624(class_2902.class_2903.field_13194, shiftedPos.method_10263(), shiftedPos.method_10260()))).method_10264() - placePos.method_10264()) > 1) {
                return;
            }
            int fenceLength = random.method_43051(1, 4);
            roadDecorationPlacementPositions.add(new RoadFenceDecoration(shiftedPos, orthogonalVector, level, leftRoadSide, fenceLength));
        } else if (segmentIndex % 80 == 0) {
            ArrayList<String> availableStructures = new ArrayList<String>();
            if (config.placeSwings()) {
                availableStructures.add("swing");
            }
            if (config.placeBenches()) {
                availableStructures.add("bench");
            }
            if (config.placeGloriettes()) {
                availableStructures.add("gloriette");
            }
            if (availableStructures.isEmpty()) {
                return;
            }
            String chosenStructure = (String)availableStructures.get(random.method_43048(availableStructures.size()));
            boolean leftRoadSide = random.method_43056();
            int distanceFromRoad = config.structureDistanceFromRoad();
            class_2338 shiftedPos = leftRoadSide ? placePos.method_10081(orthogonalVector.method_35862(distanceFromRoad)) : placePos.method_10081(orthogonalVector.method_35862(-distanceFromRoad));
            if (Math.abs((shiftedPos = shiftedPos.method_33096(level.method_8624(class_2902.class_2903.field_13194, shiftedPos.method_10263(), shiftedPos.method_10260()))).method_10264() - placePos.method_10264()) > 2) {
                return;
            }
            switch (chosenStructure) {
                case "swing": {
                    roadDecorationPlacementPositions.add(new SwingDecoration(shiftedPos, orthogonalVector, level));
                    break;
                }
                case "bench": {
                    roadDecorationPlacementPositions.add(new BenchDecoration(shiftedPos, orthogonalVector, level));
                    break;
                }
                case "gloriette": {
                    roadDecorationPlacementPositions.add(new GlorietteDecoration(shiftedPos, orthogonalVector, level));
                }
            }
        }
    }

    private void placeOnSurface(class_5281 level, class_2338 placePos, List<class_2680> material, int natural, class_5819 random) {
        class_2338 topPos;
        class_2680 blockStateAtPos;
        IModConfig config = ConfigProvider.get();
        double naturalBlockChance = 0.5;
        class_2338 surfacePos = placePos;
        if (natural == 1 || config.averagingRadius() == 0) {
            surfacePos = new class_2338(placePos.method_10263(), level.method_8624(class_2902.class_2903.field_13194, placePos.method_10263(), placePos.method_10260()), placePos.method_10260());
        }
        if ((blockStateAtPos = level.method_8320((topPos = new class_2338(surfacePos.method_10263(), level.method_8624(class_2902.class_2903.field_13194, surfacePos.method_10263(), surfacePos.method_10260()), surfacePos.method_10260())).method_10074())).equals(class_2246.field_10382.method_9564())) {
            level.method_8652(topPos, (class_2680)class_2246.field_17350.method_9564().method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (natural == 0 || random.method_43058() < naturalBlockChance) {
            this.placeRoadBlock(level, blockStateAtPos, surfacePos, material, random);
        }
    }

    private void placeRoadBlock(class_5281 level, class_2680 blockStateAtPos, class_2338 surfacePos, List<class_2680> materials, class_5819 deterministicRandom) {
        class_2680 blockStateUp;
        if (!this.placeAllowedCheck(blockStateAtPos.method_26204()) || !level.method_8320(surfacePos.method_10074()).method_26225() && !level.method_8320(surfacePos.method_10087(2)).method_26225()) {
            return;
        }
        class_2680 material = materials.get(deterministicRandom.method_43048(materials.size()));
        level.method_8652(surfacePos.method_10074(), material, 3);
        for (int i = 0; !(i >= 3 || (blockStateUp = level.method_8320(surfacePos.method_10086(i))).method_26204().equals(class_2246.field_10124) || blockStateUp.method_26164(class_3481.field_15475) || blockStateUp.method_26164(class_3481.field_16584)); ++i) {
            level.method_8652(surfacePos.method_10086(i), class_2246.field_10124.method_9564(), 3);
        }
        class_2338 belowPos1 = surfacePos.method_10087(2);
        class_2680 belowState1 = level.method_8320(belowPos1);
        if (belowState1.method_26204().equals(class_2246.field_10219)) {
            level.method_8652(belowPos1, class_2246.field_10566.method_9564(), 3);
        }
    }

    private boolean placeAllowedCheck(class_2248 blockToCheck) {
        return !dontPlaceHere.contains(blockToCheck) && !blockToCheck.method_9564().method_26164(class_3481.field_15503) && !blockToCheck.method_9564().method_26164(class_3481.field_15475) && !blockToCheck.method_9564().method_26164(class_3481.field_15496) && !blockToCheck.method_9564().method_26164(class_3481.field_17619) && !blockToCheck.method_9564().method_26164(class_3481.field_15471);
    }

    static {
        dontPlaceHere.add(class_2246.field_10225);
        dontPlaceHere.add(class_2246.field_10295);
        dontPlaceHere.add(class_2246.field_10384);
        dontPlaceHere.add(class_2246.field_10238);
        dontPlaceHere.add(class_2246.field_37546);
        chunksForLocatingCounter = 1;
        ROAD_FEATURE_KEY = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)class_2960.method_60655((String)"roadweaver", (String)"road_feature"));
        ROAD_FEATURE_PLACED_KEY = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)class_2960.method_60655((String)"roadweaver", (String)"road_feature_placed"));
        ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    }
}

