/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.io.InputStream;
import java.util.List;
import net.countered.settlementroads.features.decoration.OrientedDecoration;
import net.countered.settlementroads.features.decoration.util.BiomeWoodAware;
import net.countered.settlementroads.helpers.Records;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StructureDecoration
extends OrientedDecoration
implements BiomeWoodAware {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");
    protected Records.WoodAssets wood;
    private final String structureName;
    private final class_2382 structureSize;

    public StructureDecoration(class_2338 pos, class_2382 direction, class_5281 world, String structureName, class_2382 structureSize) {
        super(pos, direction, world);
        this.structureName = structureName;
        this.structureSize = structureSize;
    }

    @Override
    public void place() {
        if (!this.placeAllowed()) {
            return;
        }
        if (!this.hasEnoughSpace()) {
            return;
        }
        class_3499 template = this.loadStructureTemplate();
        if (template != null) {
            this.placeStructure(template);
        } else {
            this.placeFallbackStructure();
        }
    }

    protected boolean hasEnoughSpace() {
        class_2338 basePos = this.getPos();
        class_5281 world = this.getWorld();
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (int x = 0; x < this.structureSize.method_10263(); ++x) {
            for (int z = 0; z < this.structureSize.method_10260(); ++z) {
                class_2338 checkPos = basePos.method_10069(x, 0, z);
                int groundY = world.method_8624(class_2902.class_2903.field_13194, checkPos.method_10263(), checkPos.method_10260());
                minY = Math.min(minY, groundY);
                maxY = Math.max(maxY, groundY);
            }
        }
        return maxY - minY <= 2;
    }

    protected class_3499 loadStructureTemplate() {
        try {
            class_2960 structureId = class_2960.method_60655((String)"roadweaver", (String)("structures/" + this.structureName));
            class_3499 template = new class_3499();
            InputStream inputStream = this.getClass().getResourceAsStream("/data/roadweaver/structures/" + this.structureName + ".nbt");
            if (inputStream != null) {
                class_2487 nbt = class_2507.method_10629((InputStream)inputStream, (class_2505)class_2505.method_53898());
                template.method_15183((class_7871)this.getWorld().method_8410().method_45448(class_7924.field_41254), nbt);
                return template;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load structure: {} using fallback. Error: {}", (Object)this.structureName, (Object)e.getMessage());
        }
        return null;
    }

    protected void placeStructure(class_3499 template) {
        class_2338 placePos = this.getPos();
        class_5281 world = this.getWorld();
        class_2338 groundLevel = this.findGroundLevel(placePos, world);
        class_3492 placementData = new class_3492().method_15125(class_2415.field_11302).method_15123(this.getRotationFromDirection()).method_15133(true);
        template.method_15172((class_5425)world, groundLevel, groundLevel, placementData, world.method_8409(), 2);
        this.cleanupAirBlocks(template, groundLevel, placementData);
    }

    protected class_2338 findGroundLevel(class_2338 basePos, class_5281 world) {
        int minY = Integer.MAX_VALUE;
        class_2382 size = this.structureSize;
        for (int x = 0; x < size.method_10263(); ++x) {
            for (int z = 0; z < size.method_10260(); ++z) {
                class_2338 checkPos = basePos.method_10069(x - size.method_10263() / 2, 0, z - size.method_10260() / 2);
                int groundY = world.method_8624(class_2902.class_2903.field_13194, checkPos.method_10263(), checkPos.method_10260());
                minY = Math.min(minY, groundY);
            }
        }
        return new class_2338(basePos.method_10263(), minY - 1, basePos.method_10260());
    }

    protected void cleanupAirBlocks(class_3499 template, class_2338 basePos, class_3492 placementData) {
        List blocks = template.method_16445(basePos, placementData, class_2246.field_10124);
        for (class_3499.class_3501 blockInfo : blocks) {
            class_2338 airPos = blockInfo.comp_1341();
            class_2680 currentState = this.getWorld().method_8320(airPos);
            if (!this.shouldReplaceWithAir(currentState)) continue;
            this.getWorld().method_8652(airPos, class_2246.field_10124.method_9564(), 3);
        }
    }

    protected boolean shouldReplaceWithAir(class_2680 state) {
        return state.method_26204().equals(class_2246.field_10479) || state.method_26204().equals(class_2246.field_10214) || state.method_26164(class_3481.field_20339) || state.method_26164(class_3481.field_15462) || state.method_26164(class_3481.field_15503);
    }

    protected class_2470 getRotationFromDirection() {
        class_2382 roadDirection = this.getRoadDirection();
        if (Math.abs(roadDirection.method_10263()) > Math.abs(roadDirection.method_10260())) {
            return roadDirection.method_10263() > 0 ? class_2470.field_11467 : class_2470.field_11464;
        }
        return roadDirection.method_10260() > 0 ? class_2470.field_11463 : class_2470.field_11465;
    }

    protected class_2382 getRoadDirection() {
        class_2382 orthogonal = this.getOrthogonalVector();
        return new class_2382(-orthogonal.method_10260(), 0, orthogonal.method_10263());
    }

    protected abstract void placeFallbackStructure();

    @Override
    public void setWoodType(Records.WoodAssets assets) {
        this.wood = assets;
    }

    public class_2382 getStructureSize() {
        return this.structureSize;
    }
}

