/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocatorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    private StructureLocatorImpl() {
    }

    public static void locateConfiguredStructure(class_3218 level, int locateCount, boolean locateAtPlayer) {
        if (locateCount <= 0) {
            return;
        }
        IModConfig config = ConfigProvider.get();
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        Records.StructureLocationData locationData = dataProvider.getStructureLocations(level);
        if (locationData == null) {
            locationData = new Records.StructureLocationData(new ArrayList<class_2338>());
        }
        ArrayList<class_2338> knownLocations = new ArrayList<class_2338>(locationData.structureLocations());
        ArrayList<Records.StructureInfo> structureInfos = new ArrayList<Records.StructureInfo>(locationData.structureInfos());
        HashSet<class_2338> newlyFound = new HashSet<class_2338>();
        Optional<class_6885<class_3195>> targetStructures = StructureLocatorImpl.resolveStructureTargets(level, config.structuresToLocate());
        if (targetStructures.isEmpty()) {
            LOGGER.warn("RoadWeaver: \u65e0\u6cd5\u89e3\u6790\u7ed3\u6784\u76ee\u6807\u5217\u8868\uff0c\u8df3\u8fc7\u5b9a\u4f4d\u3002");
            return;
        }
        List<class_2338> centers = StructureLocatorImpl.collectSearchCenters(level, locateAtPlayer);
        int radius = Math.max(config.structureSearchRadius(), 1);
        LOGGER.debug("RoadWeaver: locating up to {} structure(s) - centers={}, radius={}, atPlayer={}", new Object[]{locateCount, centers.size(), radius, locateAtPlayer});
        for (class_2338 center : centers) {
            if (locateCount <= 0) break;
            Pair result = level.method_14178().method_12129().method_12103(level, targetStructures.get(), center, radius, true);
            if (result == null) continue;
            class_2338 structurePos = (class_2338)result.getFirst();
            class_6880 structureHolder = (class_6880)result.getSecond();
            if (StructureLocatorImpl.containsBlockPos(knownLocations, structurePos)) continue;
            knownLocations.add(structurePos);
            newlyFound.add(structurePos);
            String structureId = structureHolder.method_40230().map(key -> key.method_29177().toString()).orElse("unknown");
            structureInfos.add(new Records.StructureInfo(structurePos, structureId));
            --locateCount;
        }
        if (!newlyFound.isEmpty()) {
            dataProvider.setStructureLocations(level, new Records.StructureLocationData(knownLocations, structureInfos));
            LOGGER.debug("RoadWeaver: \u5b9a\u4f4d\u5230 {} \u4e2a\u65b0\u7ed3\u6784: {}", (Object)newlyFound.size(), newlyFound);
        }
    }

    private static Optional<class_6885<class_3195>> resolveStructureTargets(class_3218 level, String identifiers) {
        String[] tokens;
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        ArrayList holders = new ArrayList();
        if (identifiers == null || identifiers.isBlank()) {
            return Optional.empty();
        }
        for (String raw : tokens = identifiers.split("[;,\\s]+")) {
            if (raw == null) continue;
            String token = raw.trim().replace("\r", "").replace("\n", "");
            token = token.replaceAll("^[\\\"'`]+|[\\\"'`]+$", "");
            if (!(token = token.replaceAll("[,;\uff0c\uff1b]+$", "")).isEmpty() && token.charAt(0) == '\ufeff') {
                token = token.substring(1);
            }
            if ((token = token.replace('\uff03', '#').replace('\u201c', ' ').replace('\u201d', ' ').replace('\u300c', ' ').replace('\u300d', ' ').replace('\u300e', ' ').replace('\u300f', ' ').replace('\u300a', ' ').replace('\u300b', ' ').trim()).isBlank()) continue;
            int hashIdx = token.indexOf(35);
            if (hashIdx >= 0) {
                String tagToken = token.substring(hashIdx + 1).trim();
                try {
                    class_2960 tagId = class_2960.method_60654((String)tagToken);
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)tagId);
                    registry.method_40266(tag).ifPresentOrElse(named -> {
                        for (class_6880 h : named) {
                            holders.add(h);
                        }
                    }, () -> LOGGER.warn("RoadWeaver: structure tag not found: #{}", (Object)tagToken));
                }
                catch (Exception ex) {
                    LOGGER.warn("RoadWeaver: invalid structure tag token skipped: #{} (raw='{}')", (Object)tagToken, (Object)raw);
                }
                continue;
            }
            try {
                String cleaned = token.replaceAll("^[^a-z0-9_.:/\\-]+", "");
                if (cleaned.contains("*")) {
                    String pattern = cleaned.replace("*", "");
                    int matchCount = 0;
                    for (Map.Entry entry : registry.method_29722()) {
                        String structureId = ((class_5321)entry.getKey()).method_29177().toString();
                        if (!structureId.startsWith(pattern)) continue;
                        registry.method_40264((class_5321)entry.getKey()).ifPresent(holders::add);
                        ++matchCount;
                    }
                    if (matchCount > 0) {
                        LOGGER.info("RoadWeaver: \u901a\u914d\u7b26 '{}' \u5339\u914d\u5230 {} \u4e2a\u7ed3\u6784", (Object)cleaned, (Object)matchCount);
                        continue;
                    }
                    LOGGER.warn("RoadWeaver: \u901a\u914d\u7b26 '{}' \u672a\u5339\u914d\u5230\u4efb\u4f55\u7ed3\u6784", (Object)cleaned);
                    continue;
                }
                class_2960 id = class_2960.method_60654((String)cleaned);
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)id);
                registry.method_40264(key).ifPresentOrElse(holders::add, () -> LOGGER.warn("RoadWeaver: structure id not found: {}", (Object)cleaned));
            }
            catch (Exception ex) {
                LOGGER.warn("RoadWeaver: invalid structure id token skipped: {} (raw='{}')", (Object)token, (Object)raw);
            }
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(class_6885.method_40242(holders));
    }

    private static Optional<class_6885<class_3195>> resolveStructureTargets(class_3218 level, List<String> identifiersList) {
        class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
        ArrayList holders = new ArrayList();
        if (identifiersList == null || identifiersList.isEmpty()) {
            return Optional.empty();
        }
        for (String line : identifiersList) {
            String[] tokens;
            String norm;
            if (line == null || (norm = line.replace('\r', ' ').replace('\n', ' ').trim()).isEmpty()) continue;
            for (String raw : tokens = norm.split("[;,\\s]+")) {
                String token;
                if (raw == null || (token = raw.trim()).isEmpty()) continue;
                token = token.replace("\r", "").replace("\n", "");
                token = token.replaceAll("^[\\\"'`]+|[\\\"'`]+$", "");
                if (!(token = token.replaceAll("[,;\uff0c\uff1b]+$", "")).isEmpty() && token.charAt(0) == '\ufeff') {
                    token = token.substring(1);
                }
                if ((token = token.replace('\uff03', '#').replace('\u201c', ' ').replace('\u201d', ' ').replace('\u300c', ' ').replace('\u300d', ' ').replace('\u300e', ' ').replace('\u300f', ' ').replace('\u300a', ' ').replace('\u300b', ' ').trim()).isEmpty()) continue;
                int hashIdx = token.indexOf(35);
                if (hashIdx >= 0) {
                    String tagToken = token.substring(hashIdx + 1).trim();
                    try {
                        class_2960 tagId = class_2960.method_60654((String)tagToken);
                        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)tagId);
                        registry.method_40266(tag).ifPresentOrElse(named -> {
                            for (class_6880 h : named) {
                                holders.add(h);
                            }
                        }, () -> LOGGER.warn("RoadWeaver: structure tag not found: #{}", (Object)tagToken));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("RoadWeaver: invalid structure tag token skipped: #{} (line='{}')", (Object)tagToken, (Object)line);
                    }
                    continue;
                }
                try {
                    String cleaned = token.replaceAll("^[^a-z0-9_.:/\\-]+", "");
                    if (cleaned.contains("*")) {
                        String pattern = cleaned.replace("*", "");
                        int matchCount = 0;
                        for (Map.Entry entry : registry.method_29722()) {
                            String structureId = ((class_5321)entry.getKey()).method_29177().toString();
                            if (!structureId.startsWith(pattern)) continue;
                            registry.method_40264((class_5321)entry.getKey()).ifPresent(holders::add);
                            ++matchCount;
                        }
                        if (matchCount > 0) {
                            LOGGER.info("RoadWeaver: \u901a\u914d\u7b26 '{}' \u5339\u914d\u5230 {} \u4e2a\u7ed3\u6784", (Object)cleaned, (Object)matchCount);
                            continue;
                        }
                        LOGGER.warn("RoadWeaver: \u901a\u914d\u7b26 '{}' \u672a\u5339\u914d\u5230\u4efb\u4f55\u7ed3\u6784", (Object)cleaned);
                        continue;
                    }
                    class_2960 id = class_2960.method_60654((String)cleaned);
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)id);
                    registry.method_40264(key).ifPresentOrElse(holders::add, () -> LOGGER.warn("RoadWeaver: structure id not found: {}", (Object)cleaned));
                }
                catch (Exception ex) {
                    LOGGER.warn("RoadWeaver: invalid structure id token skipped: {} (line='{}')", (Object)token, (Object)line);
                }
            }
        }
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(class_6885.method_40242(holders));
    }

    private static List<class_2338> collectSearchCenters(class_3218 level, boolean locateAtPlayer) {
        ArrayList<class_2338> centers = new ArrayList<class_2338>();
        if (locateAtPlayer) {
            for (class_3222 player : level.method_18456()) {
                centers.add(player.method_24515());
            }
        }
        class_2338 spawn = level.method_43126();
        if (centers.isEmpty()) {
            int[] muls;
            centers.add(spawn);
            int r = Math.max(ConfigProvider.get().structureSearchRadius(), 1);
            for (int m : muls = new int[]{3, 6}) {
                int d = r * m;
                centers.add(spawn.method_10069(d, 0, 0));
                centers.add(spawn.method_10069(-d, 0, 0));
                centers.add(spawn.method_10069(0, 0, d));
                centers.add(spawn.method_10069(0, 0, -d));
                centers.add(spawn.method_10069(d, 0, d));
                centers.add(spawn.method_10069(-d, 0, d));
                centers.add(spawn.method_10069(d, 0, -d));
                centers.add(spawn.method_10069(-d, 0, -d));
            }
        }
        return centers;
    }

    private static boolean containsBlockPos(List<class_2338> list, class_2338 pos) {
        for (class_2338 existing : list) {
            if (!existing.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }
}

