/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.helpers.fabric;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.countered.settlementroads.config.ConfigProvider;
import net.countered.settlementroads.config.IModConfig;
import net.countered.settlementroads.persistence.WorldDataProvider;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureLocatorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadweaver");

    public static void locateConfiguredStructure(class_3218 serverWorld, int locateCount, boolean locateAtPlayer) {
        net.countered.settlementroads.helpers.StructureLocatorImpl.locateConfiguredStructure(serverWorld, locateCount, locateAtPlayer);
    }

    private static void executeLocateStructure(class_2338 locatePos, class_3218 serverWorld, String structureId) {
        class_6885 structures;
        IModConfig config = ConfigProvider.get();
        class_2378 registry = serverWorld.method_30349().method_30530(class_7924.field_41246);
        if (structureId.startsWith("#")) {
            String tagId = structureId.substring(1);
            class_2960 tagLocation = class_2960.method_60654((String)tagId);
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)tagLocation);
            Optional tagOpt = registry.method_40266(tagKey);
            if (tagOpt.isEmpty()) {
                LOGGER.warn("Structure tag not found: {}", (Object)structureId);
                return;
            }
            structures = (class_6885)tagOpt.get();
        } else {
            class_2960 structureLocation = class_2960.method_60654((String)structureId);
            class_5321 structureKey = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)structureLocation);
            Optional holderOpt = registry.method_40264(structureKey);
            if (holderOpt.isEmpty()) {
                LOGGER.warn("Structure not found: {}", (Object)structureId);
                return;
            }
            structures = class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)holderOpt.get()});
        }
        Pair pair = serverWorld.method_14178().method_12129().method_12103(serverWorld, structures, locatePos, config.structureSearchRadius(), true);
        if (pair == null) {
            LOGGER.debug("\u274c Structure not found for: {} (search radius: {})", (Object)structureId, (Object)config.structureSearchRadius());
            return;
        }
        class_2338 structureLocation = (class_2338)pair.getFirst();
        LOGGER.info("\u2705 Structure found at {} for {}", (Object)structureLocation, (Object)structureId);
        WorldDataProvider dataProvider = WorldDataProvider.getInstance();
        int beforeCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        dataProvider.addStructureLocation(serverWorld, structureLocation);
        int afterCount = dataProvider.getStructureLocations(serverWorld).structureLocations().size();
        if (afterCount > beforeCount) {
            LOGGER.info("\ud83d\udccd Added new structure at {}, total: {}", (Object)structureLocation, (Object)afterCount);
        } else {
            LOGGER.debug("Structure already exists at {}", (Object)structureLocation);
        }
    }
}

