/*
 * Decompiled with CFR 0.152.
 */
package com.pixelindiedev.lazy_ai_pixelindiedev.mixin;

import com.pixelindiedev.lazy_ai_pixelindiedev.mixin.integration.MoveItemsTaskAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_11568;
import net.minecraft.class_1263;
import net.minecraft.class_1314;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_11568.class}, priority=1002)
public class MoveItemsTaskMixin {
    @Unique
    private static int horizontalRange;
    @Unique
    private static int verticalRange;
    @Unique
    private WeakHashMap<class_2338, Boolean> cachedStorages;
    @Final
    @Shadow
    private Predicate<class_2680> field_61236;
    @Final
    @Shadow
    private Predicate<class_2680> field_61237;
    @Unique
    private class_2338 lastUsedChest = null;
    @Unique
    private class_1792 lastCarriedItem = null;

    @Unique
    private WeakHashMap<class_2338, Boolean> getCache() {
        if (this.cachedStorages == null) {
            this.cachedStorages = new WeakHashMap();
        }
        return this.cachedStorages;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void captureMob(float speed, Predicate inputContainerPredicate, Predicate outputChestPredicate, int horizontalRange, int verticalRange, Map interactionCallbacks, Consumer travellingCallback, Predicate storagePredicate, CallbackInfo ci) {
        MoveItemsTaskMixin.horizontalRange = horizontalRange;
        MoveItemsTaskMixin.verticalRange = verticalRange;
    }

    @Inject(method={"findStorage"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCachedStorage(class_3218 world, class_1314 entity, CallbackInfoReturnable<Optional<class_11568.class_11572>> cir) {
        Optional<class_11568.class_11572> result;
        class_1792 currentItem;
        this.getCache().entrySet().removeIf(e -> {
            class_2586 be = world.method_8321((class_2338)e.getKey());
            return be == null || be.method_11015() || !(be instanceof class_1263);
        });
        class_1799 held = entity.method_6047();
        class_1792 class_17922 = currentItem = held.method_7960() ? null : held.method_7909();
        if (this.lastUsedChest != null && currentItem != null && currentItem == this.lastCarriedItem) {
            class_2586 be = world.method_8321(this.lastUsedChest);
            if (be instanceof class_1263) {
                class_1263 inv = (class_1263)be;
                boolean stillContains = this.containsMatchingItem(inv, this.lastCarriedItem);
                boolean full = this.isInventoryFull(inv, held);
                if (stillContains && !full) {
                    class_11568.class_11572 storage2 = class_11568.class_11572.method_72455((class_2586)be, (class_1937)world);
                    if (storage2 != null) {
                        cir.setReturnValue(Optional.of(storage2));
                        return;
                    }
                } else {
                    this.lastUsedChest = null;
                }
            } else {
                this.lastUsedChest = null;
            }
        }
        if ((result = this.findValidCachedStorage(world, entity)).isEmpty()) {
            this.rebuildCache(world, entity);
            result = this.findValidCachedStorage(world, entity);
        }
        result.ifPresent(storage -> {
            this.getCache().put(storage.comp_4427(), true);
            cir.setReturnValue(Optional.of(storage));
        });
    }

    @Unique
    private boolean isInventoryFull(class_1263 inv, class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return true;
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 slot = inv.method_5438(i);
            if (slot.method_7960()) {
                return false;
            }
            if (!class_1799.method_31577((class_1799)slot, (class_1799)stack) || slot.method_7947() >= slot.method_7914()) continue;
            return false;
        }
        return true;
    }

    @Unique
    private boolean containsMatchingItem(class_1263 inv, class_1792 stack) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 slot = inv.method_5438(i);
            if (slot.method_7960() || !class_1799.method_31577((class_1799)slot, (class_1799)stack.method_7854())) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"placeStack"}, at={@At(value="HEAD")})
    private void beforePlaceStack(class_1314 entity, class_1263 inventory, CallbackInfo ci) {
        this.lastCarriedItem = inventory.method_5438(0).method_7909();
    }

    @Inject(method={"placeStack"}, at={@At(value="RETURN")})
    private void afterPlaceStack(class_1314 entity, class_1263 inventory, CallbackInfo ci) {
        if (entity.method_6047().method_7960() && inventory instanceof class_2586) {
            class_2586 blockEntity = (class_2586)inventory;
            this.lastUsedChest = blockEntity.method_11016();
        }
    }

    @Inject(method={"markUnreachable"}, at={@At(value="HEAD")})
    private void onMarkUnreachable(class_1314 entity, class_1937 world, class_2338 pos, CallbackInfo ci) {
        this.cachedStorages.remove(pos);
        if (this.lastUsedChest != null && this.lastUsedChest.equals((Object)pos)) {
            this.lastUsedChest = null;
        }
    }

    @Unique
    private Optional<class_11568.class_11572> findValidCachedStorage(class_3218 world, class_1314 entity) {
        return this.getCache().entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).map(pos -> {
            class_2586 be = world.method_8321(pos);
            return be instanceof class_1263 ? class_11568.class_11572.method_72455((class_2586)be, (class_1937)world) : null;
        }).filter(Objects::nonNull).filter(storage -> this.testContainerFast(world, entity, (class_11568.class_11572)storage)).findFirst();
    }

    @Unique
    private boolean testContainerFast(class_3218 world, class_1314 entity, class_11568.class_11572 s) {
        class_2624 l;
        Set<class_4208> visited = MoveItemsTaskAccessor.invokeGetVisitedPositions(entity);
        Set<class_4208> unreachable = MoveItemsTaskAccessor.invokeGetUnreachablePositions(entity);
        class_4208 currentPos = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)s.comp_4427());
        if (visited.contains(currentPos) || unreachable.contains(currentPos)) {
            return false;
        }
        if (class_2281.method_9756((class_1936)world, (class_2338)s.comp_4427())) {
            return false;
        }
        class_2586 be = s.comp_4429();
        if (be instanceof class_2624 && (l = (class_2624)be).method_74145()) {
            return false;
        }
        class_2680 state = s.comp_4430();
        boolean canPickUp = MoveItemsTaskAccessor.invokeCanPickUpItem(entity);
        return canPickUp ? this.field_61236.test(state) : this.field_61237.test(state);
    }

    @Inject(method={"markVisited"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipUnchangedVisited(class_1314 entity, class_1937 world, class_2338 pos, CallbackInfo ci) {
        Set visited = entity.method_18868().method_18904(class_4140.field_61254).orElse(Set.of());
        if (visited.contains(pos)) {
            ci.cancel();
        }
    }

    @Inject(method={"resetNavigation"}, at={@At(value="HEAD")}, cancellable=true)
    private void reset(class_1314 entity, CallbackInfo ci) {
        if (entity.method_5942().method_6357()) {
            ci.cancel();
        }
    }

    @Unique
    private void rebuildCache(class_3218 world, class_1314 entity) {
        this.getCache().clear();
        class_2338 origin = entity.method_24515();
        class_238 area = new class_238(origin).method_1009((double)horizontalRange, (double)verticalRange, (double)horizontalRange);
        int minChunkX = Math.floorDiv((int)area.field_1323, 16);
        int maxChunkX = Math.floorDiv((int)area.field_1320, 16);
        int minChunkZ = Math.floorDiv((int)area.field_1321, 16);
        int maxChunkZ = Math.floorDiv((int)area.field_1324, 16);
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                class_2818 chunk = world.method_14178().method_21730(cx, cz);
                if (chunk == null) continue;
                for (class_2586 be : chunk.method_12214().values()) {
                    class_2595 chest;
                    class_2338 pos;
                    if (!(be instanceof class_2595) || !area.method_1008((double)(pos = (chest = (class_2595)be).method_11016()).method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5)) continue;
                    this.getCache().put(pos, false);
                }
            }
        }
    }

    @Inject(method={"resetVisitedPositions"}, at={@At(value="RETURN")})
    private void restVisited(class_1314 entity, CallbackInfo ci) {
        this.getCache().replaceAll((key, val) -> false);
    }
}

