/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.gametest;

import dev.potota.itemstats.BuiltInStats;
import dev.potota.itemstats.ItemStats;
import dev.potota.itemstats.StatsComponent;
import dev.potota.itemstats.gametest.MockPlayerBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ItemStatsGameTests {
    @GameTest(template="itemstats:empty")
    public static void gameTestTest(GameTestHelper test) {
        test.succeed();
    }

    @GameTest(template="itemstats:empty")
    public static void shearSheep(GameTestHelper test) {
        Player player = MockPlayerBuilder.survival().mainHand((ItemLike)Items.SHEARS).basicPlayer(test);
        ItemStatsGameTests.assertMainHandStat(player, BuiltInStats.Ids.SHEEP_SHEARED, 0.0);
        Sheep sheep = (Sheep)test.spawnWithNoFreeWill(EntityType.SHEEP, 0, 1, 0);
        player.interactOn((Entity)sheep, InteractionHand.MAIN_HAND);
        ItemStatsGameTests.assertMainHandStat(player, BuiltInStats.Ids.SHEEP_SHEARED, 1.0);
        test.succeed();
    }

    @GameTest(template="itemstats:empty")
    public static void mineBlock(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.survival().mainHand((ItemLike)Items.IRON_PICKAXE).serverPlayer(test);
        test.setBlock(0, 0, 0, Blocks.STONE);
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.BLOCKS_MINED, 0.0);
        if (!player.gameMode.destroyBlock(test.absolutePos(new BlockPos(0, 0, 0)))) {
            test.fail("Failed to destroy block");
        }
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.BLOCKS_MINED, 1.0);
        test.succeed();
    }

    @GameTest(template="itemstats:empty")
    public static void fireArrow(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.creative().mainHand((ItemLike)Items.BOW).serverPlayer(test);
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
        player.startUsingItem(InteractionHand.MAIN_HAND);
        test.runAfterDelay(5L, () -> {
            player.releaseUsingItem();
            ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.ARROWS_FIRED, 1.0);
            test.succeed();
        });
    }

    @GameTest(template="itemstats:empty")
    public static void fireMultiShotCrossbow(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.creative().mainHand((ItemLike)Items.CROSSBOW, (ResourceKey<Enchantment>)Enchantments.MULTISHOT).serverPlayer(test);
        ItemStack crossbow = player.getWeaponItem();
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
        player.startUsingItem(InteractionHand.MAIN_HAND);
        test.runAfterDelay(25L, () -> {
            player.releaseUsingItem();
            player.gameMode.useItem(player, (Level)test.getLevel(), crossbow, InteractionHand.MAIN_HAND);
            ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.ARROWS_FIRED, 3.0);
            test.succeed();
        });
    }

    @GameTest(template="itemstats:empty")
    public static void fireFireworkCrossbow(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.creative().mainHand((ItemLike)Items.CROSSBOW).offHand((ItemLike)Items.FIREWORK_ROCKET).serverPlayer(test);
        ItemStack crossbow = player.getWeaponItem();
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
        player.startUsingItem(InteractionHand.MAIN_HAND);
        test.runAfterDelay(25L, () -> {
            player.releaseUsingItem();
            player.gameMode.useItem(player, (Level)test.getLevel(), crossbow, InteractionHand.MAIN_HAND);
            ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
            test.succeed();
        });
    }

    @GameTest(template="itemstats:empty")
    public static void killMob(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.creative().mainHand((ItemLike)Items.NETHERITE_SWORD).serverPlayer(test);
        Bat bat = (Bat)test.spawnWithNoFreeWill(EntityType.BAT, 0, 0, 0);
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.MOBS_KILLED, 0.0);
        test.runAfterDelay(13L, () -> {
            player.attack((Entity)bat);
            ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.MOBS_KILLED, 1.0);
            test.succeed();
        });
    }

    @GameTest(template="itemstats:empty")
    public static void killMobWithAxe(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.creative().mainHand((ItemLike)Items.NETHERITE_AXE).serverPlayer(test);
        Bat bat = (Bat)test.spawnWithNoFreeWill(EntityType.BAT, 0, 0, 0);
        ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.MOBS_KILLED, 0.0);
        test.runAfterDelay(20L, () -> {
            player.attack((Entity)bat);
            ItemStatsGameTests.assertMainHandStat((Player)player, BuiltInStats.Ids.MOBS_KILLED, 1.0);
            test.succeed();
        });
    }

    @GameTest(template="itemstats:empty")
    public static void takeDamage(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.survival().equip(EquipmentSlot.CHEST, (ItemLike)Items.DIAMOND_CHESTPLATE).position(new Vec3(1.0, 0.0, 1.0)).serverPlayer(test);
        Husk husk = (Husk)test.spawn(EntityType.HUSK, 0, 0, 0);
        ItemStatsGameTests.assertStatEqual(player.getItemBySlot(EquipmentSlot.CHEST), BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        test.runAfterDelay(60L, () -> ItemStatsGameTests.lambda$takeDamage$5(husk, test, (Player)player));
    }

    @GameTest(template="itemstats:empty")
    public static void takeDamageWithProtection(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.survival().equip(EquipmentSlot.CHEST, (ItemLike)Items.DIAMOND_CHESTPLATE, (ResourceKey<Enchantment>)Enchantments.PROTECTION, 4).position(new Vec3(1.0, 0.0, 1.0)).serverPlayer(test);
        Husk husk = (Husk)test.spawn(EntityType.HUSK, 0, 0, 0);
        ItemStatsGameTests.assertStatEqual(player.getItemBySlot(EquipmentSlot.CHEST), BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        test.runAfterDelay(60L, () -> ItemStatsGameTests.lambda$takeDamageWithProtection$6(husk, test, (Player)player));
    }

    @GameTest(template="itemstats:empty")
    public static void takeDamageWithFullArmor(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.survival().equip(EquipmentSlot.HEAD, (ItemLike)Items.DIAMOND_HELMET).equip(EquipmentSlot.CHEST, (ItemLike)Items.DIAMOND_CHESTPLATE).equip(EquipmentSlot.LEGS, (ItemLike)Items.DIAMOND_LEGGINGS).equip(EquipmentSlot.FEET, (ItemLike)Items.DIAMOND_BOOTS).position(new Vec3(1.0, 0.0, 1.0)).serverPlayer(test);
        Husk husk = (Husk)test.spawn(EntityType.HUSK, 0, 0, 0);
        ItemStatsGameTests.assertStatEqual((Player)player, EquipmentSlot.HEAD, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        ItemStatsGameTests.assertStatEqual((Player)player, EquipmentSlot.CHEST, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        ItemStatsGameTests.assertStatEqual((Player)player, EquipmentSlot.LEGS, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        ItemStatsGameTests.assertStatEqual((Player)player, EquipmentSlot.FEET, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        test.runAfterDelay(60L, () -> ItemStatsGameTests.lambda$takeDamageWithFullArmor$7(husk, test, (Player)player));
    }

    @GameTest(template="itemstats:empty")
    public static void cartoonAnvilCrashSfx(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.survival().equip(EquipmentSlot.HEAD, (ItemLike)Items.DIAMOND_HELMET).position(5.0, -1.0, 5.0).serverPlayer(test);
        test.runAfterDelay(60L, () -> ItemStatsGameTests.lambda$cartoonAnvilCrashSfx$9(test, (Player)player));
    }

    @GameTest(template="itemstats:empty")
    public static void elytraGlide(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.creative().equip(EquipmentSlot.CHEST, (ItemLike)Items.ELYTRA).position(new Vec3(2.0, 5.0, 2.0)).serverPlayer(test);
        player.startFallFlying();
        test.runAfterDelay(20L, () -> {
            double expected = (double)player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.AVIATE_ONE_CM)) / 100.0;
            ItemStatsGameTests.assertStatEqual((Player)player, EquipmentSlot.CHEST, BuiltInStats.Ids.DISTANCE_FLOWN, expected);
            test.succeed();
        });
    }

    @GameTest(template="itemstats:empty")
    public static void stripLog(GameTestHelper test) {
        Player player = MockPlayerBuilder.creative().equip(EquipmentSlot.MAINHAND, (ItemLike)Items.WOODEN_AXE).basicPlayer(test);
        test.setBlock(1, 0, 1, Blocks.OAK_LOG);
        ItemStatsGameTests.useItemOn(new BlockPos(1, 0, 1), player, test);
        ItemStatsGameTests.assertStatEqual(player, EquipmentSlot.MAINHAND, BuiltInStats.Ids.LOGS_STRIPPED, 1.0);
        test.succeed();
    }

    private static void assertStatEqual(ItemStack stack, ResourceLocation stat, double expectedValue) {
        StatsComponent stats = (StatsComponent)stack.get(ItemStats.STATS_COMPONENT);
        if (stats == null) {
            throw new GameTestAssertException("Item stack of " + String.valueOf(stack.getItem()) + " did not have a stats component");
        }
        Double value = stats.stats().get(stat);
        if (value == null) {
            throw new GameTestAssertException("Stat " + String.valueOf(stat) + " did not exist on " + String.valueOf(stack.getItem()));
        }
        double delta = Math.abs(value - expectedValue);
        if (delta > 0.01) {
            throw new GameTestAssertException("Expected " + String.valueOf(stat) + " to be " + expectedValue + ", but was " + value);
        }
    }

    private static void assertStatEqual(Player player, EquipmentSlot slot, ResourceLocation stat, double expectedValue) {
        ItemStatsGameTests.assertStatEqual(player.getItemBySlot(slot), stat, expectedValue);
    }

    private static void assertMainHandStat(Player player, ResourceLocation stat, double expectedValue) {
        ItemStatsGameTests.assertStatEqual(player.getWeaponItem(), stat, expectedValue);
    }

    private static InteractionResult useItemOn(BlockPos pos, Player player, GameTestHelper test) {
        pos = test.absolutePos(pos);
        BlockHitResult result = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.NORTH, pos, true);
        UseOnContext context = new UseOnContext(player, InteractionHand.MAIN_HAND, result);
        return player.getItemInHand(InteractionHand.MAIN_HAND).useOn(context);
    }

    private static /* synthetic */ void lambda$cartoonAnvilCrashSfx$9(GameTestHelper test, Player player) {
        test.setBlock(5, 4, 5, Blocks.ANVIL);
        test.runAfterDelay(20L, () -> {
            ItemStatsGameTests.assertStatEqual(player, EquipmentSlot.HEAD, BuiltInStats.Ids.DAMAGE_ABSORBED, 2.14);
            test.succeed();
        });
    }

    private static /* synthetic */ void lambda$takeDamageWithFullArmor$7(Husk husk, GameTestHelper test, Player player) {
        husk.doHurtTarget(test.getLevel(), (Entity)player);
        ItemStatsGameTests.assertStatEqual(player, EquipmentSlot.HEAD, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.35);
        ItemStatsGameTests.assertStatEqual(player, EquipmentSlot.CHEST, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.92);
        ItemStatsGameTests.assertStatEqual(player, EquipmentSlot.LEGS, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.69);
        ItemStatsGameTests.assertStatEqual(player, EquipmentSlot.FEET, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.35);
        test.succeed();
    }

    private static /* synthetic */ void lambda$takeDamageWithProtection$6(Husk husk, GameTestHelper test, Player player) {
        husk.doHurtTarget(test.getLevel(), (Entity)player);
        ItemStatsGameTests.assertStatEqual(player.getItemBySlot(EquipmentSlot.CHEST), BuiltInStats.Ids.DAMAGE_ABSORBED, 1.17);
        test.succeed();
    }

    private static /* synthetic */ void lambda$takeDamage$5(Husk husk, GameTestHelper test, Player player) {
        husk.doHurtTarget(test.getLevel(), (Entity)player);
        ItemStatsGameTests.assertStatEqual(player.getItemBySlot(EquipmentSlot.CHEST), BuiltInStats.Ids.DAMAGE_ABSORBED, 0.82);
        test.succeed();
    }
}

