/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.gametest;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPlayerBuilder {
    private GameType gameType;
    private Vec3 position;
    private final EnumMap<EquipmentSlot, ItemStack> equipment = new EnumMap(EquipmentSlot.class);
    private final EnumMap<EquipmentSlot, Pair<ResourceKey<Enchantment>, Integer>> enchantments = new EnumMap(EquipmentSlot.class);

    private MockPlayerBuilder() {
    }

    private static MockPlayerBuilder withType(GameType gameType) {
        MockPlayerBuilder builder = new MockPlayerBuilder();
        builder.gameType = gameType;
        return builder;
    }

    public static MockPlayerBuilder survival() {
        return MockPlayerBuilder.withType(GameType.SURVIVAL);
    }

    public static MockPlayerBuilder creative() {
        return MockPlayerBuilder.withType(GameType.CREATIVE);
    }

    public MockPlayerBuilder equip(EquipmentSlot slot, ItemStack stack) {
        this.equipment.put(slot, stack);
        return this;
    }

    public MockPlayerBuilder equip(EquipmentSlot slot, ItemLike item) {
        return this.equip(slot, new ItemStack(item));
    }

    public MockPlayerBuilder equip(EquipmentSlot slot, ItemLike item, ResourceKey<Enchantment> enchantment, int level) {
        this.enchantments.put(slot, (Pair<ResourceKey<Enchantment>, Integer>)Pair.of(enchantment, (Object)level));
        return this.equip(slot, new ItemStack(item));
    }

    public MockPlayerBuilder mainHand(ItemStack stack) {
        return this.equip(EquipmentSlot.MAINHAND, stack);
    }

    public MockPlayerBuilder mainHand(ItemLike item) {
        return this.mainHand(new ItemStack(item));
    }

    public MockPlayerBuilder mainHand(ItemLike item, ResourceKey<Enchantment> enchantment, int level) {
        this.enchantments.put(EquipmentSlot.MAINHAND, (Pair<ResourceKey<Enchantment>, Integer>)Pair.of(enchantment, (Object)level));
        return this.mainHand(new ItemStack(item));
    }

    public MockPlayerBuilder mainHand(ItemLike item, ResourceKey<Enchantment> enchantment) {
        return this.mainHand(item, enchantment, 1);
    }

    public MockPlayerBuilder offHand(ItemStack stack) {
        return this.equip(EquipmentSlot.OFFHAND, stack);
    }

    public MockPlayerBuilder offHand(ItemLike item) {
        return this.offHand(new ItemStack(item));
    }

    public MockPlayerBuilder position(Vec3 vec) {
        this.position = vec;
        return this;
    }

    public MockPlayerBuilder position(double x, double y, double z) {
        return this.position(new Vec3(x, y, z));
    }

    public Player basicPlayer(GameTestHelper test) {
        Player player = test.makeMockPlayer(this.gameType);
        this.setPosition(player, test);
        this.applyEnchantments(test);
        this.giveItems(player);
        return player;
    }

    public ServerPlayer serverPlayer(GameTestHelper test) {
        ServerPlayer player = MockPlayerBuilder.makeMockServerPlayerInLevel(test, this.gameType);
        this.setPosition((Player)player, test);
        this.applyEnchantments(test);
        this.giveItems((Player)player);
        return player;
    }

    private void setPosition(Player player, GameTestHelper test) {
        player.setPos(test.absoluteVec(this.position != null ? this.position : new Vec3(0.0, 0.0, 0.0)));
    }

    private void applyEnchantments(GameTestHelper test) {
        Registry registry = test.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        for (Map.Entry<EquipmentSlot, Pair<ResourceKey<Enchantment>, Integer>> entry : this.enchantments.entrySet()) {
            ItemStack stack = this.equipment.get(entry.getKey());
            if (stack == null) continue;
            stack.enchant((Holder)registry.getOrThrow((ResourceKey)entry.getValue().getFirst()), ((Integer)entry.getValue().getSecond()).intValue());
        }
    }

    private void giveItems(Player player) {
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.equipment.entrySet()) {
            player.setItemSlot(entry.getKey(), entry.getValue());
        }
    }

    private static ServerPlayer makeMockServerPlayerInLevel(GameTestHelper test, GameType mode) {
        CommonListenerCookie commonlistenercookie = CommonListenerCookie.createInitial((GameProfile)new GameProfile(UUID.randomUUID(), "test-mock-player"), (boolean)false);
        ServerPlayer serverplayer = new ServerPlayer(test.getLevel().getServer(), test.getLevel(), commonlistenercookie.gameProfile(), commonlistenercookie.clientInformation());
        Connection connection = MockPlayerBuilder.createConnection(serverplayer);
        test.getLevel().getServer().getPlayerList().placeNewPlayer(connection, serverplayer, commonlistenercookie);
        test.getLevel().getServer().getConnection().getConnections().add(connection);
        serverplayer.gameMode.changeGameModeForPlayer(mode);
        serverplayer.setYRot(180.0f);
        serverplayer.connection.chunkSender.sendNextChunks(serverplayer);
        serverplayer.connection.chunkSender.onChunkBatchReceivedByClient(64.0f);
        return serverplayer;
    }

    @NotNull
    private static Connection createConnection(final ServerPlayer serverplayer) {
        Connection connection = new Connection(PacketFlow.SERVERBOUND){

            public void tick() {
                super.tick();
                serverplayer.resetLastActionTime();
            }

            public boolean isMemoryConnection() {
                return true;
            }

            public void send(@NotNull Packet<?> packet, @Nullable PacketSendListener listeners, boolean flush) {
                super.send(packet, listeners, flush);
                if (packet instanceof ClientboundKeepAlivePacket) {
                    ClientboundKeepAlivePacket ckp = (ClientboundKeepAlivePacket)packet;
                    serverplayer.connection.handleKeepAlive(new ServerboundKeepAlivePacket(ckp.getId()));
                }
            }
        };
        new EmbeddedChannel(new ChannelHandler[]{connection});
        return connection;
    }
}

