/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.gametest;

import dev.potota.itemstats.BuiltInStats;
import dev.potota.itemstats.ItemStats;
import dev.potota.itemstats.StatsComponent;
import dev.potota.itemstats.gametest.MockPlayerBuilder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1420;
import net.minecraft.class_1472;
import net.minecraft.class_1576;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_4512;
import net.minecraft.class_4516;
import net.minecraft.class_5321;
import net.minecraft.class_6302;

public class ItemStatsGameTests {
    @class_6302(method_35936="itemstats:empty")
    public static void gameTestTest(class_4516 test) {
        test.method_36036();
    }

    @class_6302(method_35936="itemstats:empty")
    public static void shearSheep(class_4516 test) {
        class_1657 player = MockPlayerBuilder.survival().mainHand((class_1935)class_1802.field_8868).basicPlayer(test);
        ItemStatsGameTests.assertMainHandStat(player, BuiltInStats.Ids.SHEEP_SHEARED, 0.0);
        class_1472 sheep = (class_1472)test.method_36007(class_1299.field_6115, 0, 1, 0);
        player.method_7287((class_1297)sheep, class_1268.field_5808);
        ItemStatsGameTests.assertMainHandStat(player, BuiltInStats.Ids.SHEEP_SHEARED, 1.0);
        test.method_36036();
    }

    @class_6302(method_35936="itemstats:empty")
    public static void mineBlock(class_4516 test) {
        class_3222 player = MockPlayerBuilder.survival().mainHand((class_1935)class_1802.field_8403).serverPlayer(test);
        test.method_35946(0, 0, 0, class_2246.field_10340);
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.BLOCKS_MINED, 0.0);
        if (!player.field_13974.method_14266(test.method_36052(new class_2338(0, 0, 0)))) {
            test.method_35995("Failed to destroy block");
        }
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.BLOCKS_MINED, 1.0);
        test.method_36036();
    }

    @class_6302(method_35936="itemstats:empty")
    public static void fireArrow(class_4516 test) {
        class_3222 player = MockPlayerBuilder.creative().mainHand((class_1935)class_1802.field_8102).serverPlayer(test);
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
        player.method_6019(class_1268.field_5808);
        test.method_36003(5L, () -> {
            player.method_6075();
            ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.ARROWS_FIRED, 1.0);
            test.method_36036();
        });
    }

    @class_6302(method_35936="itemstats:empty")
    public static void fireMultiShotCrossbow(class_4516 test) {
        class_3222 player = MockPlayerBuilder.creative().mainHand((class_1935)class_1802.field_8399, (class_5321<class_1887>)class_1893.field_9108).serverPlayer(test);
        class_1799 crossbow = player.method_59958();
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
        player.method_6019(class_1268.field_5808);
        test.method_36003(25L, () -> {
            player.method_6075();
            player.field_13974.method_14256(player, (class_1937)test.method_35943(), crossbow, class_1268.field_5808);
            ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.ARROWS_FIRED, 3.0);
            test.method_36036();
        });
    }

    @class_6302(method_35936="itemstats:empty")
    public static void fireFireworkCrossbow(class_4516 test) {
        class_3222 player = MockPlayerBuilder.creative().mainHand((class_1935)class_1802.field_8399).offHand((class_1935)class_1802.field_8639).serverPlayer(test);
        class_1799 crossbow = player.method_59958();
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
        player.method_6019(class_1268.field_5808);
        test.method_36003(25L, () -> {
            player.method_6075();
            player.field_13974.method_14256(player, (class_1937)test.method_35943(), crossbow, class_1268.field_5808);
            ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.ARROWS_FIRED, 0.0);
            test.method_36036();
        });
    }

    @class_6302(method_35936="itemstats:empty")
    public static void killMob(class_4516 test) {
        class_3222 player = MockPlayerBuilder.creative().mainHand((class_1935)class_1802.field_22022).serverPlayer(test);
        class_1420 bat = (class_1420)test.method_36007(class_1299.field_6108, 0, 0, 0);
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.MOBS_KILLED, 0.0);
        test.method_36003(13L, () -> {
            player.method_7324((class_1297)bat);
            ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.MOBS_KILLED, 1.0);
            test.method_36036();
        });
    }

    @class_6302(method_35936="itemstats:empty")
    public static void killMobWithAxe(class_4516 test) {
        class_3222 player = MockPlayerBuilder.creative().mainHand((class_1935)class_1802.field_22025).serverPlayer(test);
        class_1420 bat = (class_1420)test.method_36007(class_1299.field_6108, 0, 0, 0);
        ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.MOBS_KILLED, 0.0);
        test.method_36003(20L, () -> {
            player.method_7324((class_1297)bat);
            ItemStatsGameTests.assertMainHandStat((class_1657)player, BuiltInStats.Ids.MOBS_KILLED, 1.0);
            test.method_36036();
        });
    }

    @class_6302(method_35936="itemstats:empty")
    public static void takeDamage(class_4516 test) {
        class_3222 player = MockPlayerBuilder.survival().equip(class_1304.field_6174, (class_1935)class_1802.field_8058).position(new class_243(1.0, 0.0, 1.0)).serverPlayer(test);
        class_1576 husk = (class_1576)test.method_35962(class_1299.field_6071, 0, 0, 0);
        ItemStatsGameTests.assertStatEqual(player.method_6118(class_1304.field_6174), BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        test.method_36003(60L, () -> ItemStatsGameTests.lambda$takeDamage$5(husk, (class_1657)player, test));
    }

    @class_6302(method_35936="itemstats:empty")
    public static void takeDamageWithProtection(class_4516 test) {
        class_3222 player = MockPlayerBuilder.survival().equip(class_1304.field_6174, (class_1935)class_1802.field_8058, (class_5321<class_1887>)class_1893.field_9111, 4).position(new class_243(1.0, 0.0, 1.0)).serverPlayer(test);
        class_1576 husk = (class_1576)test.method_35962(class_1299.field_6071, 0, 0, 0);
        ItemStatsGameTests.assertStatEqual(player.method_6118(class_1304.field_6174), BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        test.method_36003(60L, () -> ItemStatsGameTests.lambda$takeDamageWithProtection$6(husk, (class_1657)player, test));
    }

    @class_6302(method_35936="itemstats:empty")
    public static void takeDamageWithFullArmor(class_4516 test) {
        class_3222 player = MockPlayerBuilder.survival().equip(class_1304.field_6169, (class_1935)class_1802.field_8805).equip(class_1304.field_6174, (class_1935)class_1802.field_8058).equip(class_1304.field_6172, (class_1935)class_1802.field_8348).equip(class_1304.field_6166, (class_1935)class_1802.field_8285).position(new class_243(1.0, 0.0, 1.0)).serverPlayer(test);
        class_1576 husk = (class_1576)test.method_35962(class_1299.field_6071, 0, 0, 0);
        ItemStatsGameTests.assertStatEqual((class_1657)player, class_1304.field_6169, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        ItemStatsGameTests.assertStatEqual((class_1657)player, class_1304.field_6174, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        ItemStatsGameTests.assertStatEqual((class_1657)player, class_1304.field_6172, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        ItemStatsGameTests.assertStatEqual((class_1657)player, class_1304.field_6166, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.0);
        test.method_36003(60L, () -> ItemStatsGameTests.lambda$takeDamageWithFullArmor$7(husk, (class_1657)player, test));
    }

    @class_6302(method_35936="itemstats:empty")
    public static void cartoonAnvilCrashSfx(class_4516 test) {
        class_3222 player = MockPlayerBuilder.survival().equip(class_1304.field_6169, (class_1935)class_1802.field_8805).position(5.0, 0.0, 5.0).serverPlayer(test);
        test.method_36003(60L, () -> ItemStatsGameTests.lambda$cartoonAnvilCrashSfx$9(test, (class_1657)player));
    }

    @class_6302(method_35936="itemstats:empty")
    public static void elytraGlide(class_4516 test) {
        class_3222 player = MockPlayerBuilder.creative().equip(class_1304.field_6174, (class_1935)class_1802.field_8833).position(new class_243(2.0, 5.0, 2.0)).serverPlayer(test);
        player.method_23669();
        test.method_36003(20L, () -> {
            double expected = (double)player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15374)) / 100.0;
            ItemStatsGameTests.assertStatEqual((class_1657)player, class_1304.field_6174, BuiltInStats.Ids.DISTANCE_FLOWN, expected);
            test.method_36036();
        });
    }

    @class_6302(method_35936="itemstats:empty")
    public static void stripLog(class_4516 test) {
        class_1657 player = MockPlayerBuilder.creative().equip(class_1304.field_6173, (class_1935)class_1802.field_8406).basicPlayer(test);
        test.method_35946(1, 0, 1, class_2246.field_10431);
        ItemStatsGameTests.useItemOn(new class_2338(1, 0, 1), player, test);
        ItemStatsGameTests.assertStatEqual(player, class_1304.field_6173, BuiltInStats.Ids.LOGS_STRIPPED, 1.0);
        test.method_36036();
    }

    private static void assertStatEqual(class_1799 stack, class_2960 stat, double expectedValue) {
        StatsComponent stats = (StatsComponent)stack.method_57824(ItemStats.STATS_COMPONENT);
        if (stats == null) {
            throw new class_4512("Item stack of " + String.valueOf(stack.method_7909()) + " did not have a stats component");
        }
        Double value = stats.stats().get(stat);
        if (value == null) {
            throw new class_4512("Stat " + String.valueOf(stat) + " did not exist on " + String.valueOf(stack.method_7909()));
        }
        double delta = Math.abs(value - expectedValue);
        if (delta > 0.01) {
            throw new class_4512("Expected " + String.valueOf(stat) + " to be " + expectedValue + ", but was " + value);
        }
    }

    private static void assertStatEqual(class_1657 player, class_1304 slot, class_2960 stat, double expectedValue) {
        ItemStatsGameTests.assertStatEqual(player.method_6118(slot), stat, expectedValue);
    }

    private static void assertMainHandStat(class_1657 player, class_2960 stat, double expectedValue) {
        ItemStatsGameTests.assertStatEqual(player.method_59958(), stat, expectedValue);
    }

    private static class_1269 useItemOn(class_2338 pos, class_1657 player, class_4516 test) {
        pos = test.method_36052(pos);
        class_3965 result = new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11043, pos, true);
        class_1838 context = new class_1838(player, class_1268.field_5808, result);
        return player.method_5998(class_1268.field_5808).method_7981(context);
    }

    private static /* synthetic */ void lambda$cartoonAnvilCrashSfx$9(class_4516 test, class_1657 player) {
        test.method_35946(5, 5, 5, class_2246.field_10535);
        test.method_36003(20L, () -> {
            ItemStatsGameTests.assertStatEqual(player, class_1304.field_6169, BuiltInStats.Ids.DAMAGE_ABSORBED, 2.14);
            test.method_36036();
        });
    }

    private static /* synthetic */ void lambda$takeDamageWithFullArmor$7(class_1576 husk, class_1657 player, class_4516 test) {
        husk.method_6121((class_1297)player);
        ItemStatsGameTests.assertStatEqual(player, class_1304.field_6169, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.35);
        ItemStatsGameTests.assertStatEqual(player, class_1304.field_6174, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.92);
        ItemStatsGameTests.assertStatEqual(player, class_1304.field_6172, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.69);
        ItemStatsGameTests.assertStatEqual(player, class_1304.field_6166, BuiltInStats.Ids.DAMAGE_ABSORBED, 0.35);
        test.method_36036();
    }

    private static /* synthetic */ void lambda$takeDamageWithProtection$6(class_1576 husk, class_1657 player, class_4516 test) {
        husk.method_6121((class_1297)player);
        ItemStatsGameTests.assertStatEqual(player.method_6118(class_1304.field_6174), BuiltInStats.Ids.DAMAGE_ABSORBED, 1.17);
        test.method_36036();
    }

    private static /* synthetic */ void lambda$takeDamage$5(class_1576 husk, class_1657 player, class_4516 test) {
        husk.method_6121((class_1297)player);
        ItemStatsGameTests.assertStatEqual(player.method_6118(class_1304.field_6174), BuiltInStats.Ids.DAMAGE_ABSORBED, 0.82);
        test.method_36036();
    }
}

