/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.gametest;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2670;
import net.minecraft.class_2827;
import net.minecraft.class_3222;
import net.minecraft.class_4516;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7648;
import net.minecraft.class_7924;
import net.minecraft.class_8792;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPlayerBuilder {
    private class_1934 gameType;
    private class_243 position;
    private final EnumMap<class_1304, class_1799> equipment = new EnumMap(class_1304.class);
    private final EnumMap<class_1304, Pair<class_5321<class_1887>, Integer>> enchantments = new EnumMap(class_1304.class);

    private MockPlayerBuilder() {
    }

    private static MockPlayerBuilder withType(class_1934 gameType) {
        MockPlayerBuilder builder = new MockPlayerBuilder();
        builder.gameType = gameType;
        return builder;
    }

    public static MockPlayerBuilder survival() {
        return MockPlayerBuilder.withType(class_1934.field_9215);
    }

    public static MockPlayerBuilder creative() {
        return MockPlayerBuilder.withType(class_1934.field_9220);
    }

    public MockPlayerBuilder equip(class_1304 slot, class_1799 stack) {
        this.equipment.put(slot, stack);
        return this;
    }

    public MockPlayerBuilder equip(class_1304 slot, class_1935 item) {
        return this.equip(slot, new class_1799(item));
    }

    public MockPlayerBuilder equip(class_1304 slot, class_1935 item, class_5321<class_1887> enchantment, int level) {
        this.enchantments.put(slot, (Pair<class_5321<class_1887>, Integer>)Pair.of(enchantment, (Object)level));
        return this.equip(slot, new class_1799(item));
    }

    public MockPlayerBuilder mainHand(class_1799 stack) {
        return this.equip(class_1304.field_6173, stack);
    }

    public MockPlayerBuilder mainHand(class_1935 item) {
        return this.mainHand(new class_1799(item));
    }

    public MockPlayerBuilder mainHand(class_1935 item, class_5321<class_1887> enchantment, int level) {
        this.enchantments.put(class_1304.field_6173, (Pair<class_5321<class_1887>, Integer>)Pair.of(enchantment, (Object)level));
        return this.mainHand(new class_1799(item));
    }

    public MockPlayerBuilder mainHand(class_1935 item, class_5321<class_1887> enchantment) {
        return this.mainHand(item, enchantment, 1);
    }

    public MockPlayerBuilder offHand(class_1799 stack) {
        return this.equip(class_1304.field_6171, stack);
    }

    public MockPlayerBuilder offHand(class_1935 item) {
        return this.offHand(new class_1799(item));
    }

    public MockPlayerBuilder position(class_243 vec) {
        this.position = vec;
        return this;
    }

    public MockPlayerBuilder position(double x, double y, double z) {
        return this.position(new class_243(x, y, z));
    }

    public class_1657 basicPlayer(class_4516 test) {
        class_1657 player = test.method_36021(this.gameType);
        this.setPosition(player, test);
        this.applyEnchantments(test);
        this.giveItems(player);
        return player;
    }

    public class_3222 serverPlayer(class_4516 test) {
        class_3222 player = MockPlayerBuilder.makeMockServerPlayerInLevel(test, this.gameType);
        this.setPosition((class_1657)player, test);
        this.applyEnchantments(test);
        this.giveItems((class_1657)player);
        return player;
    }

    private void setPosition(class_1657 player, class_4516 test) {
        player.method_33574(test.method_35978(this.position != null ? this.position : new class_243(0.0, 0.0, 0.0)));
    }

    private void applyEnchantments(class_4516 test) {
        class_2378 registry = test.method_35943().method_30349().method_30530(class_7924.field_41265);
        for (Map.Entry<class_1304, Pair<class_5321<class_1887>, Integer>> entry : this.enchantments.entrySet()) {
            class_1799 stack = this.equipment.get(entry.getKey());
            if (stack == null) continue;
            stack.method_7978((class_6880)registry.method_40290((class_5321)entry.getValue().getFirst()), ((Integer)entry.getValue().getSecond()).intValue());
        }
    }

    private void giveItems(class_1657 player) {
        for (Map.Entry<class_1304, class_1799> entry : this.equipment.entrySet()) {
            player.method_5673(entry.getKey(), entry.getValue());
        }
    }

    private static class_3222 makeMockServerPlayerInLevel(class_4516 test, class_1934 mode) {
        class_8792 commonlistenercookie = class_8792.method_53824((GameProfile)new GameProfile(UUID.randomUUID(), "test-mock-player"), (boolean)false);
        class_3222 serverplayer = new class_3222(test.method_35943().method_8503(), test.method_35943(), commonlistenercookie.comp_1959(), commonlistenercookie.comp_1961());
        class_2535 connection = MockPlayerBuilder.createConnection(serverplayer);
        test.method_35943().method_8503().method_3760().method_14570(connection, serverplayer, commonlistenercookie);
        test.method_35943().method_8503().method_3787().method_37909().add(connection);
        serverplayer.field_13974.method_30118(mode);
        serverplayer.method_36456(180.0f);
        serverplayer.field_13987.field_45026.method_52386(serverplayer);
        serverplayer.field_13987.field_45026.method_52383(64.0f);
        return serverplayer;
    }

    @NotNull
    private static class_2535 createConnection(final class_3222 serverplayer) {
        class_2535 connection = new class_2535(class_2598.field_11941){

            public void method_10754() {
                super.method_10754();
                serverplayer.method_14234();
            }

            public boolean method_10756() {
                return true;
            }

            public void method_52906(@NotNull class_2596<?> packet, @Nullable class_7648 listeners, boolean flush) {
                super.method_52906(packet, listeners, flush);
                if (packet instanceof class_2670) {
                    class_2670 ckp = (class_2670)packet;
                    serverplayer.field_13987.method_52393(new class_2827(ckp.method_11517()));
                }
            }
        };
        new EmbeddedChannel(new ChannelHandler[]{connection});
        return connection;
    }
}

